/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MemMgmt;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TownyAdminCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> ta_help;
    private static final List<String> ta_panel;
    private static final List<String> ta_unclaim;
    private boolean isConsole;
    private Player player;
    private CommandSender sender;

    public TownyAdminCommand(Towny towny) {
        plugin = towny;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        this.sender = commandSender;
        if (commandSender instanceof Player) {
            this.player = (Player)commandSender;
            this.isConsole = false;
            System.out.println("[PLAYER_COMMAND] " + this.player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
        } else {
            this.isConsole = true;
            this.player = null;
        }
        try {
            return this.parseTownyAdminCommand(stringArray);
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)commandSender, townyException.getMessage());
            return true;
        }
    }

    private Object getSender() {
        if (this.isConsole) {
            return this.sender;
        }
        return this.player;
    }

    public boolean parseTownyAdminCommand(String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            this.buildTAPanel();
            for (String string : ta_panel) {
                this.sender.sendMessage(string);
            }
        } else if (stringArray[0].equalsIgnoreCase("?") || stringArray[0].equalsIgnoreCase("help")) {
            for (String string : ta_help) {
                this.sender.sendMessage(string);
            }
        } else {
            if (stringArray[0].equalsIgnoreCase("set")) {
                this.adminSet(StringMgmt.remFirstArg(stringArray));
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("town")) {
                this.parseAdminTownCommand(StringMgmt.remFirstArg(stringArray));
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("nation")) {
                this.parseAdminNationCommand(StringMgmt.remFirstArg(stringArray));
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("toggle")) {
                this.parseToggleCommand(StringMgmt.remFirstArg(stringArray));
                return true;
            }
            if (!this.isConsole && !TownyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN.getNode(stringArray[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (stringArray[0].equalsIgnoreCase("givebonus")) {
                this.giveBonus(StringMgmt.remFirstArg(stringArray));
            } else if (stringArray[0].equalsIgnoreCase("reload")) {
                this.reloadTowny(false);
            } else if (stringArray[0].equalsIgnoreCase("reset")) {
                this.reloadTowny(true);
            } else if (stringArray[0].equalsIgnoreCase("backup")) {
                try {
                    TownyUniverse.getDataSource().backup();
                    TownyMessaging.sendMsg(this.getSender(), TownySettings.getLangString("mag_backup_success"));
                }
                catch (IOException iOException) {
                    TownyMessaging.sendErrorMsg(this.getSender(), "Error: " + iOException.getMessage());
                }
            } else if (stringArray[0].equalsIgnoreCase("newday")) {
                TownyTimerHandler.newDay();
            } else if (stringArray[0].equalsIgnoreCase("purge")) {
                this.purge(StringMgmt.remFirstArg(stringArray));
            } else if (stringArray[0].equalsIgnoreCase("delete")) {
                String[] stringArray2 = StringMgmt.remFirstArg(stringArray);
                this.residentDelete(this.player, stringArray2);
            } else if (stringArray[0].equalsIgnoreCase("unclaim")) {
                this.parseAdminUnclaimCommand(StringMgmt.remFirstArg(stringArray));
            } else {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_sub"));
                return false;
            }
        }
        return true;
    }

    private void giveBonus(String[] stringArray) throws TownyException {
        try {
            Town town;
            if (stringArray.length != 2) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_input"), "Eg: givebonus [town/player] [n]"));
            }
            try {
                town = TownyUniverse.getDataSource().getTown(stringArray[0]);
            }
            catch (NotRegisteredException notRegisteredException) {
                town = TownyUniverse.getDataSource().getResident(stringArray[0]).getTown();
            }
            try {
                town.setBonusBlocks(town.getBonusBlocks() + Integer.parseInt(stringArray[1].trim()));
                TownyMessaging.sendMsg(this.getSender(), String.format(TownySettings.getLangString("msg_give_total"), town.getName(), stringArray[1], town.getBonusBlocks()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
            }
            TownyUniverse.getDataSource().saveTown(town);
        }
        catch (TownyException townyException) {
            throw new TownyException(townyException.getMessage());
        }
    }

    private void buildTAPanel() {
        ta_panel.clear();
        Runtime runtime = Runtime.getRuntime();
        ta_panel.add(ChatTools.formatTitle(TownySettings.getLangString("ta_panel_1")));
        ta_panel.add("\u00a73[\u00a7bTowny\u00a73] \u00a72" + TownySettings.getLangString("ta_panel_2") + "\u00a7a" + TownyUniverse.isWarTime() + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_3") + (TownyTimerHandler.isHealthRegenRunning() ? "\u00a7aOn" : "\u00a7cOff") + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_5") + (TownyTimerHandler.isDailyTimerRunning() ? "\u00a7aOn" : "\u00a7cOff"));
        ta_panel.add("\u00a73[\u00a7b" + TownySettings.getLangString("ta_panel_8") + "\u00a73" + "] " + "\u00a72" + TownySettings.getLangString("ta_panel_9") + "\u00a7a" + MemMgmt.getMemSize(runtime.totalMemory()) + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_10") + "\u00a7a" + Thread.getAllStackTraces().keySet().size() + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_11") + "\u00a7a" + TownyFormatter.getTime());
        ta_panel.add("\u00a7e" + MemMgmt.getMemoryBar(50, runtime));
    }

    public void parseAdminUnclaimCommand(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("?")) {
            for (String string : ta_unclaim) {
                ((CommandSender)this.getSender()).sendMessage(string);
            }
        } else {
            if (this.isConsole) {
                this.sender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
                return;
            }
            try {
                if (TownyUniverse.isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordArea(null, new WorldCoord(this.player.getWorld().getName(), Coord.parseCoord((Entity)this.player)), stringArray);
                new TownClaim(plugin, this.player, null, list, false, false, true).start();
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)this.player, townyException.getMessage());
                return;
            }
        }
    }

    public void parseAdminTownCommand(String[] stringArray) throws TownyException {
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin town"));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town] add/kick [] .. []", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town] rename [newname]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town] delete", ""));
            return;
        }
        try {
            Town town = TownyUniverse.getDataSource().getTown(stringArray[0]);
            if (stringArray.length == 1) {
                TownyMessaging.sendMessage(this.getSender(), TownyFormatter.getStatus(town));
                return;
            }
            if (!TownyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN.getNode(stringArray[1].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (stringArray[1].equalsIgnoreCase("add")) {
                TownCommand.townAdd(this.getSender(), town, StringMgmt.remArgs(stringArray, 2));
            } else if (stringArray[1].equalsIgnoreCase("kick")) {
                TownCommand.townKickResidents(this.getSender(), town.getMayor(), town, TownyUniverse.getValidatedResidents(this.getSender(), StringMgmt.remArgs(stringArray, 2)));
            } else if (stringArray[1].equalsIgnoreCase("delete")) {
                TownyUniverse.getDataSource().removeTown(town);
            } else if (stringArray[1].equalsIgnoreCase("rename")) {
                if (!NameValidation.isBlacklistName(stringArray[2])) {
                    TownyUniverse.getDataSource().renameTown(town, stringArray[2]);
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_name"), this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", town.getName()));
                } else {
                    TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_invalid_name"));
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg(this.getSender(), notRegisteredException.getMessage());
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg(this.getSender(), townyException.getMessage());
        }
    }

    public void parseAdminNationCommand(String[] stringArray) throws TownyException {
        if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin nation"));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation] add [] .. []", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation] rename [newname]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation] delete", ""));
            return;
        }
        try {
            Nation nation = TownyUniverse.getDataSource().getNation(stringArray[0]);
            if (stringArray.length == 1) {
                TownyMessaging.sendMessage(this.getSender(), TownyFormatter.getStatus(nation));
                return;
            }
            if (!TownyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION.getNode(stringArray[1].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (stringArray[1].equalsIgnoreCase("add")) {
                NationCommand.nationAdd(nation, TownyUniverse.getDataSource().getTowns(StringMgmt.remArgs(stringArray, 2)));
            } else if (stringArray[1].equalsIgnoreCase("delete")) {
                TownyUniverse.getDataSource().removeNation(nation);
            } else if (stringArray[1].equalsIgnoreCase("rename")) {
                if (!NameValidation.isBlacklistName(stringArray[2])) {
                    TownyUniverse.getDataSource().renameNation(nation, stringArray[2]);
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_set_name"), this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", nation.getName()));
                } else {
                    TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_invalid_name"));
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg(this.getSender(), notRegisteredException.getMessage());
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            TownyMessaging.sendErrorMsg(this.getSender(), alreadyRegisteredException.getMessage());
        }
    }

    public void adminSet(String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set"));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "mayor [town] " + TownySettings.getLangString("town_help_2"), ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "mayor [town] npc", ""));
            return;
        }
        if (!TownyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET.getNode(stringArray[0].toLowerCase()))) {
            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
        }
        if (stringArray[0].equalsIgnoreCase("mayor")) {
            if (stringArray.length < 3) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set mayor"));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/townyadmin set mayor", "[town] " + TownySettings.getLangString("town_help_2"), ""));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/townyadmin set mayor", "[town] npc", ""));
            } else {
                try {
                    Object object;
                    Resident resident = null;
                    Town town = TownyUniverse.getDataSource().getTown(stringArray[1]);
                    if (stringArray[2].equalsIgnoreCase("npc")) {
                        object = this.nextNpcName();
                        TownyUniverse.getDataSource().newResident((String)object);
                        resident = TownyUniverse.getDataSource().getResident((String)object);
                        resident.setRegistered(System.currentTimeMillis());
                        resident.setLastOnline(0L);
                        resident.setNPC(true);
                        TownyUniverse.getDataSource().saveResident(resident);
                        TownyUniverse.getDataSource().saveResidentList();
                        town.setHasUpkeep(false);
                    } else {
                        resident = TownyUniverse.getDataSource().getResident(stringArray[2]);
                        town.setHasUpkeep(true);
                    }
                    if (!town.hasResident(resident)) {
                        TownCommand.townAddResident(town, resident);
                    }
                    object = town.getMayor();
                    town.setMayor(resident);
                    if (((Resident)object).isNPC()) {
                        try {
                            town.removeResident((Resident)object);
                            TownyUniverse.getDataSource().removeResident((Resident)object);
                            TownyUniverse.getDataSource().removeResidentList((Resident)object);
                        }
                        catch (EmptyTownException emptyTownException) {
                            emptyTownException.printStackTrace();
                        }
                    }
                    TownyUniverse.getDataSource().saveTown(town);
                    String[] stringArray2 = TownySettings.getNewMayorMsg(resident.getName());
                    TownyMessaging.sendTownMessage(town, stringArray2);
                }
                catch (TownyException townyException) {
                    TownyMessaging.sendErrorMsg(this.getSender(), townyException.getMessage());
                }
            }
        } else {
            TownyMessaging.sendErrorMsg(this.getSender(), String.format(TownySettings.getLangString("msg_err_invalid_property"), "administrative"));
            return;
        }
    }

    public String nextNpcName() throws TownyException {
        int n = 0;
        do {
            String string = TownySettings.getNPCPrefix() + ++n;
            if (TownyUniverse.getDataSource().hasResident(string)) continue;
            return string;
        } while (n <= 100000);
        throw new TownyException(TownySettings.getLangString("msg_err_too_many_npc"));
    }

    public void reloadTowny(Boolean bl) {
        if (bl.booleanValue()) {
            TownyUniverse.getDataSource().deleteFile(plugin.getConfigPath());
        }
        TownyLogger.shutDown();
        plugin.load();
        TownyMessaging.sendMsg(this.sender, TownySettings.getLangString("msg_reloaded"));
    }

    public void purge(String[] stringArray) {
        if (stringArray.length == 0) {
            this.player.sendMessage(ChatTools.formatTitle("/townyadmin purge"));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin purge", "[number of days]", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "", "Removes offline residents not seen for this duration.", ""));
            return;
        }
        int n = 1;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_error_must_be_int"));
            return;
        }
        new ResidentPurge(plugin, this.sender, TimeTools.getMillis(n + "d")).start();
    }

    public void residentDelete(Player player, String[] stringArray) {
        if (stringArray.length == 0) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        } else {
            try {
                if (!TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
                    throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete"));
                }
                for (String string : stringArray) {
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(string);
                        if (!resident.isNPC() && !BukkitTools.isOnline(resident.getName())) {
                            TownyUniverse.getDataSource().removeResident(resident);
                            TownyUniverse.getDataSource().removeResidentList(resident);
                            TownyMessaging.sendGlobalMessage(TownySettings.getDelResidentMsg(resident));
                            continue;
                        }
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_online_or_npc"), string));
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_name"), string));
                    }
                }
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                return;
            }
        }
    }

    public void parseToggleCommand(String[] stringArray) throws TownyException {
        if (stringArray.length == 0) {
            this.player.sendMessage(ChatTools.formatTitle("/townyadmin toggle"));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "war", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "neutral", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "devmode", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "debug", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "townwithdraw/nationwithdraw", ""));
            return;
        }
        if (!TownyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOGGLE.getNode(stringArray[0].toLowerCase()))) {
            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
        }
        if (stringArray[0].equalsIgnoreCase("war")) {
            boolean bl = TownyUniverse.isWarTime();
            if (!bl) {
                plugin.getTownyUniverse().startWarEvent();
                TownyMessaging.sendMsg(this.getSender(), TownySettings.getLangString("msg_war_started"));
            } else {
                plugin.getTownyUniverse().endWarEvent();
                TownyMessaging.sendMsg(this.getSender(), TownySettings.getLangString("msg_war_ended"));
            }
        } else if (stringArray[0].equalsIgnoreCase("neutral")) {
            try {
                boolean bl = !TownySettings.isDeclaringNeutral();
                TownySettings.setDeclaringNeutral(bl);
                TownyMessaging.sendMsg(this.getSender(), String.format(TownySettings.getLangString("msg_nation_allow_neutral"), bl ? "Enabled" : "Disabled"));
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
                return;
            }
        } else if (stringArray[0].equalsIgnoreCase("devmode")) {
            try {
                boolean bl = !TownySettings.isDevMode();
                TownySettings.setDevMode(bl);
                TownyMessaging.sendMsg(this.getSender(), "Dev Mode " + (bl ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else if (stringArray[0].equalsIgnoreCase("debug")) {
            try {
                boolean bl = !TownySettings.getDebug();
                TownySettings.setDebug(bl);
                TownyMessaging.sendMsg(this.getSender(), "Debug Mode " + (bl ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else if (stringArray[0].equalsIgnoreCase("townwithdraw")) {
            try {
                boolean bl = !TownySettings.getTownBankAllowWithdrawls();
                TownySettings.SetTownBankAllowWithdrawls(bl);
                TownyMessaging.sendMsg(this.getSender(), "Town Withdrawls " + (bl ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else if (stringArray[0].equalsIgnoreCase("nationwithdraw")) {
            try {
                boolean bl = !TownySettings.geNationBankAllowWithdrawls();
                TownySettings.SetNationBankAllowWithdrawls(bl);
                TownyMessaging.sendMsg(this.getSender(), "Nation Withdrawls " + (bl ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else {
            TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
        }
    }

    static {
        ta_help = new ArrayList<String>();
        ta_panel = new ArrayList<String>();
        ta_unclaim = new ArrayList<String>();
        ta_help.add(ChatTools.formatTitle("/townyadmin"));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "", TownySettings.getLangString("admin_panel_1")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "set [] .. []", "'/townyadmin set' " + TownySettings.getLangString("res_5")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "unclaim [radius]", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "town/nation", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "givebonus [town/player] [num]", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "toggle neutral/war/debug/devmode", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "reload", TownySettings.getLangString("admin_panel_2")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "reset", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "backup", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "newday", TownySettings.getLangString("admin_panel_3")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "purge [number of days]", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "delete [] .. []", "delete a residents data files."));
        ta_unclaim.add(ChatTools.formatTitle("/townyadmin unclaim"));
        ta_unclaim.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin unclaim", "", TownySettings.getLangString("townyadmin_help_1")));
        ta_unclaim.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin unclaim", "[radius]", TownySettings.getLangString("townyadmin_help_2")));
    }
}

