/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> towny_general_help;
    private static final List<String> towny_help;
    private static final List<String> towny_top;
    private static final List<String> towny_war;
    private static String towny_version;

    public TownyCommand(Towny towny) {
        plugin = towny;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    towny_version = "\u00a72Towny version: \u00a7a" + plugin.getVersion();
                                    towny_war.add(ChatTools.formatTitle("/towny war"));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "stats", ""));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "scores", ""));
                                    if (!(commandSender instanceof Player)) break block4;
                                    Player player = (Player)commandSender;
                                    System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + string + " " + StringMgmt.join(stringArray));
                                    this.parseTownyCommand(player, stringArray);
                                    break block5;
                                }
                                if (stringArray.length != 0) break block6;
                                for (String string2 : towny_general_help) {
                                    commandSender.sendMessage(Colors.strip(string2));
                                }
                                break block5;
                            }
                            if (!stringArray[0].equalsIgnoreCase("tree")) break block7;
                            plugin.getTownyUniverse().sendUniverseTree(commandSender);
                            break block5;
                        }
                        if (!stringArray[0].equalsIgnoreCase("time")) break block8;
                        TownyMessaging.sendMsg("Time until a New Day: " + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
                        break block5;
                    }
                    if (!stringArray[0].equalsIgnoreCase("version") && !stringArray[0].equalsIgnoreCase("v")) break block9;
                    commandSender.sendMessage(Colors.strip(towny_version));
                    break block5;
                }
                if (!stringArray[0].equalsIgnoreCase("war")) break block10;
                boolean bl = this.TownyWar(StringMgmt.remFirstArg(stringArray));
                for (String string3 : towny_war) {
                    commandSender.sendMessage(Colors.strip(string3));
                }
                if (!bl) {
                    commandSender.sendMessage("The world isn't currently at war.");
                }
                towny_war.clear();
                break block5;
            }
            if (!stringArray[0].equalsIgnoreCase("universe")) break block5;
            for (String string4 : this.getUniverseStats()) {
                commandSender.sendMessage(Colors.strip(string4));
            }
        }
        return true;
    }

    private void parseTownyCommand(Player player, String[] stringArray) {
        block39: {
            if (stringArray.length == 0) {
                for (String string : towny_general_help) {
                    player.sendMessage(string);
                }
                return;
            }
            if (stringArray[0].equalsIgnoreCase("?") || stringArray[0].equalsIgnoreCase("help")) {
                for (String string : towny_help) {
                    player.sendMessage(Colors.strip(string));
                }
                return;
            }
            try {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY.getNode(stringArray[0].toLowerCase()))) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (stringArray[0].equalsIgnoreCase("map")) {
                    if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("big")) {
                        TownyAsciiMap.generateAndSend(plugin, player, 18);
                    } else {
                        TownyCommand.showMap(player);
                    }
                    break block39;
                }
                if (stringArray[0].equalsIgnoreCase("prices")) {
                    Town town = null;
                    if (stringArray.length > 1) {
                        try {
                            town = TownyUniverse.getDataSource().getTown(stringArray[1]);
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            this.sendErrorMsg((CommandSender)player, notRegisteredException.getMessage());
                            return;
                        }
                    }
                    if (stringArray.length == 1) {
                        try {
                            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                            town = resident.getTown();
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                    }
                    for (String string : this.getTownyPrices(town)) {
                        player.sendMessage(string);
                    }
                    break block39;
                }
                if (stringArray[0].equalsIgnoreCase("top")) {
                    this.TopCommand(player, StringMgmt.remFirstArg(stringArray));
                } else if (stringArray[0].equalsIgnoreCase("tree")) {
                    this.consoleUseOnly(player);
                } else if (stringArray[0].equalsIgnoreCase("time")) {
                    TownyMessaging.sendMsg((Object)player, "Time until a New Day: " + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
                } else if (stringArray[0].equalsIgnoreCase("universe")) {
                    for (String string : this.getUniverseStats()) {
                        player.sendMessage(string);
                    }
                } else if (stringArray[0].equalsIgnoreCase("version") || stringArray[0].equalsIgnoreCase("v")) {
                    player.sendMessage(towny_version);
                } else if (stringArray[0].equalsIgnoreCase("war")) {
                    boolean bl = this.TownyWar(StringMgmt.remFirstArg(stringArray));
                    for (String string : towny_war) {
                        player.sendMessage(Colors.strip(string));
                    }
                    if (!bl) {
                        this.sendErrorMsg((CommandSender)player, "The world isn't currently at war.");
                    }
                    towny_war.clear();
                } else if (stringArray[0].equalsIgnoreCase("spy")) {
                    if (plugin.isPermissions() && TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
                        if (plugin.hasPlayerMode(player, "spy")) {
                            plugin.removePlayerMode(player);
                        } else {
                            plugin.setPlayerMode(player, stringArray, true);
                        }
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
                    }
                } else {
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            }
        }
    }

    private boolean TownyWar(String[] stringArray) {
        if (TownyUniverse.isWarTime() && stringArray.length > 0) {
            towny_war.clear();
            if (stringArray[0].equalsIgnoreCase("stats")) {
                towny_war.addAll(plugin.getTownyUniverse().getWarEvent().getStats());
            } else if (stringArray[0].equalsIgnoreCase("scores")) {
                towny_war.addAll(plugin.getTownyUniverse().getWarEvent().getScores(-1));
            }
        }
        return TownyUniverse.isWarTime();
    }

    private void TopCommand(Player player, String[] stringArray) {
        block27: {
            ArrayList<TownyEconomyObject> arrayList;
            if (stringArray.length == 0 || stringArray[0].equalsIgnoreCase("?")) {
                towny_top.add(ChatTools.formatTitle("/towny top"));
                towny_top.add(ChatTools.formatCommand("", "/towny top", "money [all/resident/town/nation]", ""));
                towny_top.add(ChatTools.formatCommand("", "/towny top", "residents [all/town/nation]", ""));
                towny_top.add(ChatTools.formatCommand("", "/towny top", "land [all/resident/town]", ""));
            } else if (stringArray[0].equalsIgnoreCase("money")) {
                try {
                    if (stringArray.length == 1 || stringArray[1].equalsIgnoreCase("all")) {
                        arrayList = new ArrayList<Resident>(TownyUniverse.getDataSource().getResidents());
                        arrayList.addAll(TownyUniverse.getDataSource().getTowns());
                        arrayList.addAll(TownyUniverse.getDataSource().getNations());
                        towny_top.add(ChatTools.formatTitle("Top Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(arrayList, 10));
                        break block27;
                    }
                    if (stringArray[1].equalsIgnoreCase("resident")) {
                        towny_top.add(ChatTools.formatTitle("Top Resident Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getResidents()), 10));
                        break block27;
                    }
                    if (stringArray[1].equalsIgnoreCase("town")) {
                        towny_top.add(ChatTools.formatTitle("Top Town Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getTowns()), 10));
                        break block27;
                    }
                    if (stringArray[1].equalsIgnoreCase("nation")) {
                        towny_top.add(ChatTools.formatTitle("Top Nation Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getNations()), 10));
                        break block27;
                    }
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
                catch (EconomyException economyException) {
                    this.sendErrorMsg((CommandSender)player, "Economy error.");
                    this.sendErrorMsg((CommandSender)player, economyException.getError());
                }
            } else if (stringArray[0].equalsIgnoreCase("residents")) {
                if (stringArray.length == 1 || stringArray[1].equalsIgnoreCase("all")) {
                    arrayList = new ArrayList<Town>(TownyUniverse.getDataSource().getTowns());
                    arrayList.addAll(TownyUniverse.getDataSource().getNations());
                    towny_top.add(ChatTools.formatTitle("Most Residents"));
                    towny_top.addAll(this.getMostResidents(arrayList, 10));
                } else if (stringArray[1].equalsIgnoreCase("town")) {
                    towny_top.add(ChatTools.formatTitle("Most Residents in a Town"));
                    towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(TownyUniverse.getDataSource().getTowns()), 10));
                } else if (stringArray[1].equalsIgnoreCase("nation")) {
                    towny_top.add(ChatTools.formatTitle("Most Residents in a Nation"));
                    towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(TownyUniverse.getDataSource().getNations()), 10));
                } else {
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
            } else if (stringArray[0].equalsIgnoreCase("land")) {
                if (stringArray.length == 1 || stringArray[1].equalsIgnoreCase("all")) {
                    arrayList = new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getResidents());
                    arrayList.addAll(TownyUniverse.getDataSource().getTowns());
                    towny_top.add(ChatTools.formatTitle("Most Land Owned"));
                    towny_top.addAll(this.getMostLand(arrayList, 10));
                } else if (stringArray[1].equalsIgnoreCase("resident")) {
                    towny_top.add(ChatTools.formatTitle("Most Land Owned by Resident"));
                    towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(TownyUniverse.getDataSource().getResidents()), 10));
                } else if (stringArray[1].equalsIgnoreCase("town")) {
                    towny_top.add(ChatTools.formatTitle("Most Land Owned by Town"));
                    towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(TownyUniverse.getDataSource().getTowns()), 10));
                } else {
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
            } else {
                this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
            }
        }
        for (String string : towny_top) {
            player.sendMessage(string);
        }
        towny_top.clear();
    }

    public List<String> getUniverseStats() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("\u00a70-\u00a74###\u00a70---\u00a74###\u00a70-");
        arrayList.add("\u00a74#\u00a7c###\u00a74#\u00a70-\u00a74#\u00a7c###\u00a74#\u00a70   \u00a76[\u00a7eTowny " + plugin.getVersion() + "\u00a76]");
        arrayList.add("\u00a74#\u00a7c####\u00a74#\u00a7c####\u00a74#   \u00a73By: \u00a7bChris H (Shade)/Llmdl/ElgarL");
        arrayList.add("\u00a70-\u00a74#\u00a7c#######\u00a74#\u00a70-");
        arrayList.add("\u00a70--\u00a74##\u00a7c###\u00a74##\u00a70-- \u00a73Residents: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getResidents().size()) + "\u00a78" + " | " + "\u00a73Towns: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getTowns().size()) + "\u00a78" + " | " + "\u00a73Nations: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getNations().size()));
        arrayList.add("\u00a70----\u00a74#\u00a7c#\u00a74#\u00a70---- \u00a73Worlds: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getWorlds().size()) + "\u00a78" + " | " + "\u00a73TownBlocks: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getAllTownBlocks().size()));
        arrayList.add("\u00a70-----\u00a74#\u00a70----- ");
        return arrayList;
    }

    public static void showMap(Player player) {
        TownyAsciiMap.generateAndSend(plugin, player, 7);
    }

    public List<String> getTownyPrices(Town town) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Nation nation = null;
        if (town != null && town.hasNation()) {
            try {
                nation = town.getNation();
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
        arrayList.add(ChatTools.formatTitle("Prices"));
        arrayList.add("\u00a7e[New] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNewTownPrice()) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNewNationPrice()));
        arrayList.add("\u00a7e[Upkeep] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeepCost(town)) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeepCost(nation)));
        arrayList.add("\u00a78Town upkeep is based on \u00a7a the " + (TownySettings.isUpkeepByPlot() ? " number of plots" : " town level (num residents)."));
        if (town != null) {
            arrayList.add("\u00a7eTown [" + TownyFormatter.getFormattedName(town) + "]");
            arrayList.add("\u00a7c    [Price] \u00a72Plot: \u00a7a" + Double.toString(town.getPlotPrice()) + "\u00a78" + " | " + "\u00a72" + "Outpost: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()));
            arrayList.add("\u00a7c    [Upkeep] \u00a72Resident: \u00a7a" + Double.toString(town.getTaxes()) + "\u00a78" + " | " + "\u00a72" + "Plot: " + "\u00a7a" + Double.toString(town.getPlotTax()));
            if (nation != null) {
                arrayList.add("\u00a7eNation [" + TownyFormatter.getFormattedName(nation) + "]");
                arrayList.add("\u00a7c    [Upkeep] \u00a72Town: \u00a7a" + Double.toString(nation.getTaxes()) + "\u00a78" + " | " + "\u00a72" + "Neutrality: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationNeutralityCost()));
            }
        }
        return arrayList;
    }

    public List<String> getTopBankBalance(List<TownyEconomyObject> list, int n) throws EconomyException {
        ArrayList<String> arrayList = new ArrayList<String>();
        KeyValueTable<TownyEconomyObject, Double> keyValueTable = new KeyValueTable<TownyEconomyObject, Double>();
        for (TownyEconomyObject object : list) {
            keyValueTable.put(object, object.getHoldingBalance());
        }
        keyValueTable.sortByValue();
        keyValueTable.revese();
        int n2 = 0;
        for (KeyValue keyValue : keyValueTable.getKeyValues()) {
            if (n != -1 && ++n2 > n) break;
            TownyEconomyObject townyEconomyObject = (TownyEconomyObject)keyValue.key;
            arrayList.add(String.format("\u00a77%-20s \u00a76|\u00a73 %s", TownyFormatter.getFormattedName(townyEconomyObject), TownyEconomyHandler.getFormattedBalance((Double)keyValue.value)));
        }
        return arrayList;
    }

    public List<String> getMostResidents(List<ResidentList> list, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        KeyValueTable<ResidentList, Integer> keyValueTable = new KeyValueTable<ResidentList, Integer>();
        for (ResidentList object : list) {
            keyValueTable.put(object, object.getResidents().size());
        }
        keyValueTable.sortByValue();
        keyValueTable.revese();
        int n2 = 0;
        for (KeyValue keyValue : keyValueTable.getKeyValues()) {
            if (n != -1 && ++n2 > n) break;
            ResidentList residentList = (ResidentList)keyValue.key;
            arrayList.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", TownyFormatter.getFormattedName((TownyObject)((Object)residentList)), (Integer)keyValue.value));
        }
        return arrayList;
    }

    public List<String> getMostLand(List<TownBlockOwner> list, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        KeyValueTable<TownBlockOwner, Integer> keyValueTable = new KeyValueTable<TownBlockOwner, Integer>();
        for (TownBlockOwner object : list) {
            keyValueTable.put(object, object.getTownBlocks().size());
        }
        keyValueTable.sortByValue();
        keyValueTable.revese();
        int n2 = 0;
        for (KeyValue keyValue : keyValueTable.getKeyValues()) {
            if (n != -1 && ++n2 > n) break;
            TownBlockOwner townBlockOwner = (TownBlockOwner)keyValue.key;
            arrayList.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", TownyFormatter.getFormattedName(townBlockOwner), (Integer)keyValue.value));
        }
        return arrayList;
    }

    public void consoleUseOnly(Player player) {
        TownyMessaging.sendErrorMsg((Object)player, "This command was designed for use in the console only.");
    }

    public void inGameUseOnly(CommandSender commandSender) {
        commandSender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
    }

    public boolean sendErrorMsg(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            TownyMessaging.sendErrorMsg((Object)player, string);
        } else {
            commandSender.sendMessage("[Towny] ConsoleError: " + string);
        }
        return false;
    }

    static {
        towny_general_help = new ArrayList<String>();
        towny_help = new ArrayList<String>();
        towny_top = new ArrayList<String>();
        towny_war = new ArrayList<String>();
        towny_general_help.add(ChatTools.formatTitle(TownySettings.getLangString("help_0")));
        towny_general_help.add(TownySettings.getLangString("help_1"));
        towny_general_help.add(ChatTools.formatCommand("", "/resident", "?", "") + ", " + ChatTools.formatCommand("", "/town", "?", "") + ", " + ChatTools.formatCommand("", "/nation", "?", "") + ", " + ChatTools.formatCommand("", "/plot", "?", "") + ", " + ChatTools.formatCommand("", "/towny", "?", ""));
        towny_general_help.add(ChatTools.formatCommand("", "/tc", "[msg]", TownySettings.getLangString("help_2")) + ", " + ChatTools.formatCommand("", "/nc", "[msg]", TownySettings.getLangString("help_3")).trim());
        towny_general_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin", "?", ""));
        towny_help.add(ChatTools.formatTitle("/towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "", "General help for Towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "map", "Displays a map of the nearby townblocks"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "prices", "Display the prices used with Economy"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "top", "Display highscores"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "time", "Display time until a new day"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "universe", "Displays stats"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "v", "Displays the version of Towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "war", "'/towny war' for more info"));
    }
}

