/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.util.NameValidation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import org.bukkit.entity.Player;

public abstract class TownyDatabaseHandler
extends TownyDataSource {
    @Override
    public boolean hasResident(String string) {
        try {
            return TownySettings.isFakeResident(string) || this.universe.getResidentMap().containsKey(NameValidation.checkAndFilterPlayerName(string).toLowerCase());
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
    }

    @Override
    public boolean hasTown(String string) {
        return this.universe.getTownsMap().containsKey(string.toLowerCase());
    }

    @Override
    public boolean hasNation(String string) {
        return this.universe.getNationsMap().containsKey(string.toLowerCase());
    }

    @Override
    public List<Resident> getResidents(Player player, String[] stringArray) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (String string : stringArray) {
            try {
                Resident resident = this.getResident(string);
                arrayList.add(resident);
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            }
        }
        return arrayList;
    }

    @Override
    public List<Resident> getResidents(String[] stringArray) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (String string : stringArray) {
            try {
                arrayList.add(this.getResident(string));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    public List<Resident> getResidents() {
        return new ArrayList<Resident>(this.universe.getResidentMap().values());
    }

    @Override
    public Resident getResident(String string) throws NotRegisteredException {
        try {
            string = NameValidation.checkAndFilterPlayerName(string).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasResident(string)) {
            throw new NotRegisteredException(String.format("The resident '%s' is not registered.", string));
        }
        if (TownySettings.isFakeResident(string)) {
            Resident resident = new Resident(string);
            resident.setNPC(true);
            return resident;
        }
        return this.universe.getResidentMap().get(string);
    }

    @Override
    public List<Town> getTowns(String[] stringArray) {
        ArrayList<Town> arrayList = new ArrayList<Town>();
        for (String string : stringArray) {
            try {
                arrayList.add(this.getTown(string));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    public List<Town> getTowns() {
        return new ArrayList<Town>(this.universe.getTownsMap().values());
    }

    @Override
    public Town getTown(String string) throws NotRegisteredException {
        try {
            string = NameValidation.checkAndFilterName(string).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasTown(string)) {
            throw new NotRegisteredException(String.format("The town '%s' is not registered.", string));
        }
        return this.universe.getTownsMap().get(string);
    }

    @Override
    public List<Nation> getNations(String[] stringArray) {
        ArrayList<Nation> arrayList = new ArrayList<Nation>();
        for (String string : stringArray) {
            try {
                arrayList.add(this.getNation(string));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    public List<Nation> getNations() {
        return new ArrayList<Nation>(this.universe.getNationsMap().values());
    }

    @Override
    public Nation getNation(String string) throws NotRegisteredException {
        try {
            string = NameValidation.checkAndFilterName(string).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasNation(string)) {
            throw new NotRegisteredException(String.format("The nation '%s' is not registered.", string));
        }
        return this.universe.getNationsMap().get(string.toLowerCase());
    }

    @Override
    public TownyWorld getWorld(String string) throws NotRegisteredException {
        TownyWorld townyWorld = this.universe.getWorldMap().get(string.toLowerCase());
        if (townyWorld == null) {
            throw new NotRegisteredException("World not registered!");
        }
        return townyWorld;
    }

    @Override
    public List<TownyWorld> getWorlds() {
        return new ArrayList<TownyWorld>(this.universe.getWorldMap().values());
    }

    @Override
    public TownyWorld getTownWorld(String string) {
        for (TownyWorld townyWorld : this.universe.getWorldMap().values()) {
            if (!townyWorld.hasTown(string)) continue;
            return townyWorld;
        }
        return null;
    }

    @Override
    public void removeResident(Resident resident) {
        Town town = null;
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
        try {
            if (town != null) {
                town.removeResident(resident);
                if (town.hasNation()) {
                    this.saveNation(town.getNation());
                }
                this.saveTown(town);
            }
            resident.clear();
        }
        catch (EmptyTownException emptyTownException) {
            this.removeTown(town);
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
        }
        this.universe.setChangedNotify(TownyObservableType.REMOVE_RESIDENT);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        PlotBlockData plotBlockData;
        Resident resident = null;
        Town town = null;
        try {
            resident = townBlock.getResident();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            town = townBlock.getTown();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        TownyWorld townyWorld = townBlock.getWorld();
        townyWorld.removeTownBlock(townBlock);
        this.saveWorld(townyWorld);
        this.deleteTownBlock(townBlock);
        if (resident != null) {
            this.saveResident(resident);
        }
        if (town != null) {
            this.saveTown(town);
        }
        if (townBlock.getWorld().isUsingPlotManagementDelete()) {
            TownyRegenAPI.addDeleteTownBlockIdQueue(townBlock.getWorldCoord());
        }
        if (townBlock.getWorld().isUsingPlotManagementRevert() && (plotBlockData = TownyRegenAPI.getPlotChunkSnapshot(townBlock)) != null && !plotBlockData.getBlockList().isEmpty()) {
            TownyRegenAPI.addPlotChunk(plotBlockData, true);
        }
        this.universe.setChangedNotify(TownyObservableType.REMOVE_TOWN_BLOCK);
    }

    @Override
    public void removeTownBlocks(Town town) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(town.getTownBlocks())) {
            this.removeTownBlock(townBlock);
        }
    }

    @Override
    public List<TownBlock> getAllTownBlocks() {
        ArrayList<TownBlock> arrayList = new ArrayList<TownBlock>();
        for (TownyWorld townyWorld : this.getWorlds()) {
            arrayList.addAll(townyWorld.getTownBlocks());
        }
        return arrayList;
    }

    @Override
    public void newResident(String string) throws AlreadyRegisteredException, NotRegisteredException {
        String string2;
        try {
            string2 = NameValidation.checkAndFilterPlayerName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new NotRegisteredException(invalidNameException.getMessage());
        }
        if (this.universe.getResidentMap().containsKey(string2.toLowerCase())) {
            throw new AlreadyRegisteredException("A resident with the name " + string2 + " is already in use.");
        }
        this.universe.getResidentMap().put(string2.toLowerCase(), new Resident(string2));
        this.universe.setChangedNotify(TownyObservableType.NEW_RESIDENT);
    }

    @Override
    public void newTown(String string) throws AlreadyRegisteredException, NotRegisteredException {
        String string2;
        try {
            string2 = NameValidation.checkAndFilterName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new NotRegisteredException(invalidNameException.getMessage());
        }
        if (this.universe.getTownsMap().containsKey(string2.toLowerCase())) {
            throw new AlreadyRegisteredException("The town " + string2 + " is already in use.");
        }
        this.universe.getTownsMap().put(string2.toLowerCase(), new Town(string2));
        this.universe.setChangedNotify(TownyObservableType.NEW_TOWN);
    }

    @Override
    public void newNation(String string) throws AlreadyRegisteredException, NotRegisteredException {
        String string2;
        try {
            string2 = NameValidation.checkAndFilterName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new NotRegisteredException(invalidNameException.getMessage());
        }
        if (this.universe.getNationsMap().containsKey(string2.toLowerCase())) {
            throw new AlreadyRegisteredException("The nation " + string2 + " is already in use.");
        }
        this.universe.getNationsMap().put(string2.toLowerCase(), new Nation(string2));
        this.universe.setChangedNotify(TownyObservableType.NEW_NATION);
    }

    @Override
    public void newWorld(String string) throws AlreadyRegisteredException, NotRegisteredException {
        String string2 = string;
        if (this.universe.getWorldMap().containsKey(string2.toLowerCase())) {
            throw new AlreadyRegisteredException("The world " + string2 + " is already in use.");
        }
        this.universe.getWorldMap().put(string2.toLowerCase(), new TownyWorld(string2));
        this.universe.setChangedNotify(TownyObservableType.NEW_WORLD);
    }

    @Override
    public void removeResidentList(Resident resident) {
        String string = resident.getName();
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Resident resident2 : new ArrayList<Resident>(this.universe.getResidentMap().values())) {
            TownyMessaging.sendDebugMsg("Checking friends of: " + resident2.getName());
            if (!resident2.hasFriend(resident)) continue;
            try {
                TownyMessaging.sendDebugMsg("       - Removing Friend: " + resident.getName());
                resident2.removeFriend(resident);
                arrayList.add(resident2);
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
        for (Resident resident2 : arrayList) {
            this.saveResident(resident2);
        }
        try {
            resident.clear();
        }
        catch (EmptyTownException emptyTownException) {
            this.removeTown(emptyTownException.getTown());
        }
        this.deleteResident(resident);
        this.universe.getResidentMap().remove(string.toLowerCase());
        if (TownySettings.isUsingEconomy() && TownySettings.isDeleteEcoAccount()) {
            resident.removeAccount();
        }
        this.plugin.deleteCache(string);
        this.saveResidentList();
    }

    @Override
    public void removeTown(Town town) {
        this.removeTownBlocks(town);
        ArrayList<Resident> arrayList = new ArrayList<Resident>(town.getResidents());
        TownyWorld townyWorld = town.getWorld();
        try {
            if (town.hasNation()) {
                Nation nation = town.getNation();
                nation.removeTown(town);
                this.saveNation(nation);
            }
            this.removeTownBlocks(town);
            town.clear();
        }
        catch (EmptyNationException emptyNationException) {
            this.removeNation(emptyNationException.getNation());
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_del_nation"), emptyNationException.getNation()));
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
        }
        for (Resident resident : arrayList) {
            this.removeResident(resident);
            this.saveResident(resident);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                town.payTo(town.getHoldingBalance(), new WarSpoils(), "Remove Town");
                town.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        this.universe.getTownsMap().remove(town.getName().toLowerCase());
        this.plugin.resetCache();
        this.deleteTown(town);
        this.saveTownList();
        try {
            townyWorld.removeTown(town);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.saveWorld(townyWorld);
        this.universe.setChangedNotify(TownyObservableType.REMOVE_TOWN);
    }

    @Override
    public void removeNation(Nation nation) {
        ArrayList<Nation> arrayList = new ArrayList<Nation>();
        for (Nation object2 : new ArrayList<Nation>(this.universe.getNationsMap().values())) {
            if (!object2.hasAlly(nation) && !object2.hasEnemy(nation)) continue;
            try {
                if (object2.hasAlly(nation)) {
                    object2.removeAlly(nation);
                } else {
                    object2.removeEnemy(nation);
                }
                arrayList.add(object2);
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
        for (Nation nation2 : arrayList) {
            this.saveNation(nation2);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                nation.payTo(nation.getHoldingBalance(), new WarSpoils(), "Remove Nation");
                nation.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        this.deleteNation(nation);
        ArrayList<Town> arrayList2 = new ArrayList<Town>(nation.getTowns());
        nation.clear();
        this.universe.getNationsMap().remove(nation.getName().toLowerCase());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Town town = (Town)iterator.next();
            ArrayList<Resident> arrayList3 = new ArrayList<Resident>(town.getResidents());
            for (Resident resident : arrayList3) {
                if (!resident.hasTitle() && !resident.hasSurname()) continue;
                resident.setTitle("");
                resident.setSurname("");
                this.saveResident(resident);
            }
            this.saveTown(town);
        }
        this.plugin.resetCache();
        this.saveNationList();
        this.universe.setChangedNotify(TownyObservableType.REMOVE_NATION);
    }

    @Override
    public void removeWorld(TownyWorld townyWorld) throws UnsupportedOperationException {
        this.deleteWorld(townyWorld);
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getResidentKeys() {
        return this.universe.getResidentMap().keySet();
    }

    @Override
    public Set<String> getTownsKeys() {
        return this.universe.getTownsMap().keySet();
    }

    @Override
    public Set<String> getNationsKeys() {
        return this.universe.getNationsMap().keySet();
    }

    @Override
    public List<Town> getTownsWithoutNation() {
        ArrayList<Town> arrayList = new ArrayList<Town>();
        for (Town town : this.getTowns()) {
            if (town.hasNation()) continue;
            arrayList.add(town);
        }
        return arrayList;
    }

    @Override
    public List<Resident> getResidentsWithoutTown() {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Resident resident : this.universe.getResidentMap().values()) {
            if (resident.hasTown()) continue;
            arrayList.add(resident);
        }
        return arrayList;
    }

    @Override
    public void renameTown(Town town, String string) throws AlreadyRegisteredException, NotRegisteredException {
        String string2;
        try {
            string2 = NameValidation.checkAndFilterName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new NotRegisteredException(invalidNameException.getMessage());
        }
        if (this.hasTown(string2)) {
            throw new AlreadyRegisteredException("The town " + string2 + " is already in use.");
        }
        ArrayList<Resident> arrayList = new ArrayList<Resident>(town.getResidents());
        Boolean bl = false;
        Nation nation = null;
        Double d = 0.0;
        if (TownySettings.isUsingEconomy()) {
            try {
                d = town.getHoldingBalance();
                town.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        if (town.hasNation()) {
            nation = town.getNation();
            bl = town.isCapital();
        }
        this.deleteTown(town);
        this.universe.getTownsMap().remove(town.getName().toLowerCase());
        town.setName(string2);
        this.universe.getTownsMap().put(string2.toLowerCase(), town);
        if (bl.booleanValue()) {
            nation.setCapital(town);
            this.saveNation(nation);
        }
        if (TownySettings.isUsingEconomy()) {
            town.setBalance(d, "Rename Town - Transfer to new account");
        }
        for (Resident resident : arrayList) {
            this.saveResident(resident);
        }
        this.saveTown(town);
        this.saveTownList();
        this.saveWorld(town.getWorld());
        this.universe.setChangedNotify(TownyObservableType.RENAME_TOWN);
    }

    @Override
    public void renameNation(Nation nation, String string) throws AlreadyRegisteredException, NotRegisteredException {
        String string2;
        try {
            string2 = NameValidation.checkAndFilterName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new NotRegisteredException(invalidNameException.getMessage());
        }
        if (this.hasNation(string2)) {
            throw new AlreadyRegisteredException("The nation " + string2 + " is already in use.");
        }
        ArrayList<Town> arrayList = new ArrayList<Town>(nation.getTowns());
        Double d = 0.0;
        if (TownySettings.isUsingEconomy()) {
            try {
                d = nation.getHoldingBalance();
                nation.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        this.deleteNation(nation);
        String string3 = nation.getName();
        this.universe.getNationsMap().remove(string3.toLowerCase());
        nation.setName(string2);
        this.universe.getNationsMap().put(string2.toLowerCase(), nation);
        if (TownyEconomyHandler.isActive()) {
            nation.setBalance(d, "Rename Nation - Transfer to new account");
        }
        for (Town object2 : arrayList) {
            this.saveTown(object2);
        }
        this.saveNation(nation);
        this.saveNationList();
        Nation nation3 = new Nation(string3);
        ArrayList<Nation> arrayList2 = new ArrayList<Nation>(this.getNations());
        for (Nation nation2 : arrayList2) {
            if (nation2.hasAlly(nation3) || nation2.hasEnemy(nation3)) {
                try {
                    if (nation2.hasAlly(nation3)) {
                        nation2.removeAlly(nation3);
                        nation2.addAlly(nation);
                        continue;
                    }
                    nation2.removeEnemy(nation3);
                    nation2.addEnemy(nation);
                }
                catch (NotRegisteredException notRegisteredException) {
                    notRegisteredException.printStackTrace();
                }
                continue;
            }
            arrayList.remove(nation2);
        }
        for (Nation nation2 : arrayList2) {
            this.saveNation(nation2);
        }
        this.universe.setChangedNotify(TownyObservableType.RENAME_NATION);
    }
}

