/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.KeyValueFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.bukkit.World;

public class TownyHModFlatFileSource
extends TownyFlatFileSource {
    @Override
    public void initialize(Towny towny, TownyUniverse townyUniverse) {
        this.universe = townyUniverse;
        this.plugin = towny;
        this.rootFolder = townyUniverse.getRootFolder();
        this.dataFolder = "/data-hmod";
        try {
            FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + this.dataFolder, this.rootFolder + this.dataFolder + "/residents", this.rootFolder + this.dataFolder + "/towns", this.rootFolder + this.dataFolder + "/nations"});
            FileMgmt.checkFiles(new String[]{this.rootFolder + this.dataFolder + "/residents.txt", this.rootFolder + this.dataFolder + "/towns.txt", this.rootFolder + this.dataFolder + "/nations.txt", this.rootFolder + this.dataFolder + "/townblocks.txt"});
        }
        catch (IOException iOException) {
            System.out.println("[Towny] Error: Could not create hmod-flatfile default files and folders.");
        }
    }

    @Override
    public void backup() throws IOException {
    }

    @Override
    public boolean loadWorldList() {
        TownyMessaging.sendDebugMsg("Loading World List");
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg("Loading Server World List");
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    alreadyRegisteredException.printStackTrace();
                }
                catch (NotRegisteredException notRegisteredException) {
                    notRegisteredException.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorlds() {
        System.out.println("[Towny] [hMod Conversion] Town Blocks");
        TownyWorld townyWorld = this.getWorlds().toArray(new TownyWorld[0])[0];
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.rootFolder + this.dataFolder + "/townblocks.csv"));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(",");
                if (stringArray.length < 4) continue;
                try {
                    Town town = this.getTown(stringArray[2]);
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    try {
                        townyWorld.newTownBlock(n, n2);
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {
                        // empty catch block
                    }
                    TownBlock townBlock = townyWorld.getTownBlock(n, n2);
                    if (town != null) {
                        townBlock.setTown(town);
                    }
                    try {
                        townBlock.setResident(this.getResident(stringArray[3]));
                    }
                    catch (NotRegisteredException notRegisteredException) {
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                catch (NotRegisteredException notRegisteredException) {
                    notRegisteredException.printStackTrace();
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        System.out.println("[Towny] [hMod Conversion] Resident: " + resident.getName());
        String string = this.rootFolder + this.dataFolder + "/residents/" + resident.getName() + ".txt";
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                KeyValueFile keyValueFile = new KeyValueFile(string);
                resident.setLastOnline(Long.parseLong(keyValueFile.get("lastLogin")));
                String string2 = keyValueFile.get("registered");
                if (string2 != null) {
                    resident.setRegistered(Long.parseLong(string2));
                } else {
                    resident.setRegistered(resident.getLastOnline());
                }
                string2 = keyValueFile.get("town");
                if (string2 != null) {
                    resident.setTown(this.getTown(string2));
                }
                if ((string2 = keyValueFile.get("friends")) != null) {
                    String[] stringArray;
                    for (String string3 : stringArray = string2.split(",")) {
                        Resident resident2 = this.getResident(string3);
                        if (resident2 == null) continue;
                        resident.addFriend(resident2);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("[Towny] Loading Error: Exception while reading resident file " + resident.getName());
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadTown(Town town) {
        System.out.println("[Towny] [hMod Conversion] Town: " + town.getName());
        String string = this.rootFolder + this.dataFolder + "/towns/" + town.getName() + ".txt";
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                KeyValueFile keyValueFile = new KeyValueFile(string);
                String string2 = keyValueFile.get("residents");
                if (string2 != null) {
                    String[] stringArray;
                    for (String string3 : stringArray = string2.split(",")) {
                        Resident resident = this.getResident(string3);
                        if (resident == null) continue;
                        town.addResident(resident);
                    }
                }
                if ((string2 = keyValueFile.get("mayor")) != null) {
                    town.setMayor(this.getResident(string2));
                }
                town.setTownBoard(keyValueFile.get("townBoard"));
                string2 = keyValueFile.get("bonusBlocks");
                if (string2 != null) {
                    try {
                        town.setBonusBlocks(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        town.setBonusBlocks(0);
                    }
                }
                if ((string2 = keyValueFile.get("purchasedBlocks")) != null) {
                    try {
                        town.setPurchasedBlocks(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        town.setPurchasedBlocks(0);
                    }
                }
                if ((string2 = keyValueFile.get("plotPrice")) != null) {
                    try {
                        town.setPlotPrice(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        town.setPlotPrice(0.0);
                    }
                }
                if ((string2 = keyValueFile.get("taxes")) != null) {
                    try {
                        town.setTaxes(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        town.setTaxes(0.0);
                    }
                }
                if ((string2 = keyValueFile.get("plotTax")) != null) {
                    try {
                        town.setPlotTax(Integer.parseInt(string2));
                    }
                    catch (Exception exception) {
                        town.setPlotTax(0.0);
                    }
                }
                if ((string2 = keyValueFile.get("pvp")) != null) {
                    try {
                        town.setPVP(Boolean.parseBoolean(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = keyValueFile.get("explosion")) != null) {
                    try {
                        town.setBANG(Boolean.parseBoolean(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = keyValueFile.get("taxpercent")) != null) {
                    try {
                        town.setTaxPercentage(Boolean.parseBoolean(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = keyValueFile.get("fire")) != null) {
                    try {
                        town.setFire(Boolean.parseBoolean(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                System.out.println("[Towny] Loading Error: Exception while reading town file " + town.getName());
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        System.out.println("[Towny] [hMod Conversion] Nation: " + nation.getName());
        String string = "";
        String string2 = this.rootFolder + this.dataFolder + "/nations/" + nation.getName() + ".txt";
        File file = new File(string2);
        if (file.exists() && file.isFile()) {
            try {
                TownyEconomyObject townyEconomyObject;
                String[] stringArray;
                KeyValueFile keyValueFile = new KeyValueFile(string2);
                string = keyValueFile.get("towns");
                if (string != null) {
                    for (String string3 : stringArray = string.split(",")) {
                        townyEconomyObject = this.getTown(string3);
                        if (townyEconomyObject == null) continue;
                        nation.addTown((Town)townyEconomyObject);
                    }
                }
                string = keyValueFile.get("capital");
                nation.setCapital(this.getTown(string));
                string = keyValueFile.get("allies");
                if (string != null) {
                    for (String string3 : stringArray = string.split(",")) {
                        townyEconomyObject = this.getNation(string3);
                        if (townyEconomyObject == null) continue;
                        nation.setAllegiance("ally", (Nation)townyEconomyObject);
                    }
                }
                if ((string = keyValueFile.get("enemies")) != null) {
                    for (String string3 : stringArray = string.split(",")) {
                        townyEconomyObject = this.getNation(string3);
                        if (townyEconomyObject == null) continue;
                        nation.setAllegiance("enemy", (Nation)townyEconomyObject);
                    }
                }
                if ((string = keyValueFile.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Integer.parseInt(string));
                    }
                    catch (Exception exception) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((string = keyValueFile.get("neutral")) != null) {
                    try {
                        nation.setNeutral(Boolean.parseBoolean(string));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                System.out.println("[Towny] Loading Error: Exception while reading nation file " + nation.getName());
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld townyWorld) {
        return false;
    }

    @Override
    public boolean saveResidentList() {
        return false;
    }

    @Override
    public boolean saveTownList() {
        return false;
    }

    @Override
    public boolean saveNationList() {
        return false;
    }

    @Override
    public boolean saveWorldList() {
        return false;
    }

    @Override
    public boolean saveResident(Resident resident) {
        return false;
    }

    @Override
    public boolean saveTown(Town town) {
        return false;
    }

    @Override
    public boolean saveNation(Nation nation) {
        return false;
    }

    @Override
    public boolean saveWorld(TownyWorld townyWorld) {
        return false;
    }
}

