/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;

public class TownySQLSource
extends TownyFlatFileSource {
    protected String driver = "";
    protected String dsn = "";
    protected String hostname = "";
    protected String port = "";
    protected String db_name = "";
    protected String username = "";
    protected String password = "";
    protected String tb_prefix = "";
    private Connection cntx = null;
    private String type = "";

    public TownySQLSource(String string) {
        this.type = string.toLowerCase();
    }

    @Override
    public void initialize(Towny towny, TownyUniverse townyUniverse) {
        Object object;
        Object object2;
        Object object3;
        block20: {
            Object object4;
            Object object5;
            Object object6;
            this.universe = townyUniverse;
            this.plugin = towny;
            this.rootFolder = townyUniverse.getRootFolder();
            try {
                FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + this.dataFolder, this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data"});
                FileMgmt.checkFiles(new String[]{this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt", this.rootFolder + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"});
            }
            catch (IOException iOException) {
                TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
            }
            this.hostname = TownySettings.getSQLHostName();
            this.port = TownySettings.getSQLPort();
            this.db_name = TownySettings.getSQLDBName();
            this.tb_prefix = TownySettings.getSQLTablePrefix().toUpperCase();
            if (this.type.equals("h2")) {
                this.driver = "org.h2.Driver";
                this.dsn = "jdbc:h2:" + this.rootFolder + this.dataFolder + File.separator + this.db_name + ".h2db;AUTO_RECONNECT=TRUE";
                this.username = "sa";
                this.password = "sa";
            }
            if (this.type.equals("mysql")) {
                this.driver = "com.mysql.jdbc.Driver";
                this.dsn = "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.db_name;
                this.username = TownySettings.getSQLUsername();
                this.password = TownySettings.getSQLPassword();
            } else {
                this.driver = "org.sqlite.JDBC";
                this.dsn = "jdbc:sqlite:" + this.rootFolder + this.dataFolder + File.separator + this.db_name + ".sqldb";
                this.username = TownySettings.getSQLUsername();
                this.password = TownySettings.getSQLPassword();
            }
            try {
                object6 = (Driver)Class.forName(this.driver).newInstance();
                DriverManager.registerDriver((Driver)object6);
            }
            catch (Exception exception) {
                System.out.println("[Towny] Driver error: " + exception);
            }
            TownyMessaging.sendDebugMsg("Checking for tables existence");
            if (!this.getContext()) {
                TownyMessaging.sendErrorMsg("Failed when connecting to Database");
                return;
            }
            TownyMessaging.sendDebugMsg("[Towny] Connected to Database");
            object6 = "CREATE TABLE IF NOT EXISTS " + this.tb_prefix + "TOWNS (" + "`name` VARCHAR(32) NOT NULL," + "`residents` mediumtext," + "`mayor` mediumtext," + "`nation` mediumtext NOT NULL," + "`assistants` text DEFAULT NULL," + "`townBoard` mediumtext DEFAULT NULL," + "`tag` mediumtext DEFAULT NULL," + "`protectionStatus` mediumtext DEFAULT NULL," + "`bonus` int(11) DEFAULT 0," + "`purchased` int(11)  DEFAULT 0," + "`taxpercent` bool NOT NULL DEFAULT '0'," + "`taxes` float DEFAULT 0," + "`hasUpkeep` bool NOT NULL DEFAULT '0'," + "`plotPrice` float DEFAULT NULL," + "`plotTax` float DEFAULT NULL," + "`commercialPlotPrice` float DEFAULT NULL," + "`commercialPlotTax` float NOT NULL," + "`embassyPlotPrice` float NOT NULL," + "`embassyPlotTax` float NOT NULL," + "`open` bool NOT NULL DEFAULT '0'," + "`public` bool NOT NULL DEFAULT '0'," + "`homeblock` mediumtext NOT NULL," + "`townBlocks` mediumtext NOT NULL," + "`spawn` mediumtext NOT NULL," + "`outpostSpawns` mediumtext DEFAULT NULL," + "PRIMARY KEY (`name`)" + ")";
            try {
                object5 = this.cntx.createStatement();
                object5.executeUpdate((String)object6);
                TownyMessaging.sendDebugMsg("Table TOWNS is ok!");
            }
            catch (SQLException sQLException) {
                TownyMessaging.sendErrorMsg("Creating table TOWNS :" + sQLException.getMessage());
            }
            object5 = "CREATE TABLE IF NOT EXISTS " + this.tb_prefix + "RESIDENTS (" + " `name` VARCHAR(16) NOT NULL," + "`town` mediumtext," + "`town-ranks` mediumtext," + "`nation-ranks` mediumtext," + "`lastOnline` BIGINT NOT NULL," + "`registered` BIGINT NOT NULL," + "`isNPC` bool NOT NULL DEFAULT '0'," + "`title` mediumtext," + "`surname` mediumtext," + "`protectionStatus` mediumtext," + "`friends` mediumtext," + "`townBlocks` mediumtext," + "PRIMARY KEY (`name`)" + ")";
            try {
                object4 = this.cntx.createStatement();
                object4.executeUpdate((String)object5);
                TownyMessaging.sendDebugMsg("Table RESIDENTS is ok!");
            }
            catch (SQLException sQLException) {
                TownyMessaging.sendErrorMsg("Error Creating table RESIDENTS :" + sQLException.getMessage());
            }
            try {
                object4 = "ALTER TABLE `" + this.db_name + "`.`" + this.tb_prefix + "RESIDENTS` ADD COLUMN `town-ranks`  mediumtext";
                object3 = this.cntx.createStatement();
                object3.executeUpdate((String)object4);
                object4 = "ALTER TABLE `" + this.db_name + "`.`" + this.tb_prefix + "RESIDENTS` ADD COLUMN `nation-ranks`  mediumtext";
                object3 = this.cntx.createStatement();
                object3.executeUpdate((String)object4);
                TownyMessaging.sendDebugMsg("Table RESIDENTS is updated!");
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1060) break block20;
                TownyMessaging.sendErrorMsg("Error updating table RESIDENTS :" + sQLException.getMessage());
            }
        }
        object3 = "CREATE TABLE IF NOT EXISTS " + this.tb_prefix + "NATIONS (" + "`name` VARCHAR(32) NOT NULL," + "`towns` mediumtext NOT NULL," + "`capital` mediumtext NOT NULL," + "`assistants` mediumtext NOT NULL," + "`tag` mediumtext NOT NULL," + "`allies` mediumtext NOT NULL," + "`enemies` mediumtext NOT NULL," + "`taxes` float NOT NULL," + "`neutral` bool NOT NULL DEFAULT '0', " + "PRIMARY KEY (`name`)" + ")";
        try {
            object2 = this.cntx.createStatement();
            object2.executeUpdate((String)object3);
            TownyMessaging.sendDebugMsg("Table NATIONS is ok!");
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("Error Creating table NATIONS : " + sQLException.getMessage());
        }
        object2 = "CREATE TABLE IF NOT EXISTS " + this.tb_prefix + "TOWNBLOCKS (" + "`world` VARCHAR(32) NOT NULL," + "`x` bigint(20) NOT NULL," + "`z` bigint(20) NOT NULL," + "`permissions` mediumtext NOT NULL," + "`locked` bool NOT NULL DEFAULT '0'," + "`changed` bool NOT NULL DEFAULT '0'," + "PRIMARY KEY (`world`,`x`,`z`)" + ")";
        try {
            object = this.cntx.createStatement();
            object.executeUpdate((String)object2);
            TownyMessaging.sendDebugMsg("Table TOWNBLOCKS is ok!");
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("Error Creating table TOWNBLOCKS : " + sQLException.getMessage());
        }
        object = "CREATE TABLE IF NOT EXISTS " + this.tb_prefix + "WORLDS (" + "`name` VARCHAR(32) NOT NULL," + "`towns` mediumtext NOT NULL," + "`claimable` bool NOT NULL DEFAULT '0'," + "`pvp` bool NOT NULL DEFAULT '0'," + "`forcepvp` bool NOT NULL DEFAULT '0'," + "`forcetownmobs` bool NOT NULL DEFAULT '0'," + "`worldmobs` bool NOT NULL DEFAULT '0'," + "`firespread` bool NOT NULL DEFAULT '0'," + "`forcefirespread` bool NOT NULL DEFAULT '0'," + "`explosions` bool NOT NULL DEFAULT '0'," + "`forceexplosions` bool NOT NULL DEFAULT '0'," + "`endermanprotect` bool NOT NULL DEFAULT '0'," + "`disableplayertrample` bool NOT NULL DEFAULT '0'," + "`disablecreaturetrample` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneBuild` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneDestroy` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneSwitch` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneItemUse` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneName` mediumtext NOT NULL," + "`unclaimedZoneIgnoreIds` mediumtext NOT NULL," + "`usingPlotManagementDelete` bool NOT NULL DEFAULT '0'," + "`plotManagementDeleteIds` mediumtext NOT NULL," + "`usingPlotManagementMayorDelete` bool NOT NULL DEFAULT '0'," + "`plotManagementMayorDelete` mediumtext NOT NULL," + "`usingPlotManagementRevert` bool NOT NULL DEFAULT '0'," + "`plotManagementRevertSpeed` long NOT NULL," + "`plotManagementIgnoreIds` mediumtext NOT NULL," + "`usingPlotManagementWildRegen` bool NOT NULL DEFAULT '0'," + "`plotManagementWildRegenEntities` mediumtext NOT NULL," + "`plotManagementWildRegenSpeed` long NOT NULL," + "`usingTowny` bool NOT NULL DEFAULT '0'," + "PRIMARY KEY (`name`)" + ")";
        try {
            Statement statement = this.cntx.createStatement();
            statement.executeUpdate((String)object);
            TownyMessaging.sendDebugMsg("Table WORLDS is ok!");
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("Error Creating table WORLDS : " + sQLException.getMessage());
        }
        TownyMessaging.sendDebugMsg("Checking done!");
    }

    public boolean getContext() {
        try {
            if (this.cntx == null || this.cntx.isClosed()) {
                this.cntx = this.username.equalsIgnoreCase("") && this.password.equalsIgnoreCase("") ? DriverManager.getConnection(this.dsn) : DriverManager.getConnection(this.dsn, this.username, this.password);
            }
            return this.cntx != null && !this.cntx.isClosed();
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("Error could not Connect to db " + this.dsn + ": " + sQLException.getMessage());
            return false;
        }
    }

    public boolean UpdateDB(String string, HashMap<String, Object> hashMap, List<String> list) {
        Object object;
        if (!this.getContext()) {
            return false;
        }
        if (list == null) {
            String string2 = "INSERT INTO " + this.tb_prefix + string.toUpperCase() + " ";
            String string3 = "(";
            String string4 = " VALUES (";
            Set<Map.Entry<String, Object>> set = hashMap.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                string3 = string3 + "`" + entry.getKey() + "`";
                string3 = string3 + "" + (iterator.hasNext() ? ", " : ")");
                string4 = entry.getValue() instanceof String ? string4 + "'" + ((String)entry.getValue()).replace("'", "''") + "'" : (entry.getValue() instanceof Boolean ? string4 + "'" + ((Boolean)entry.getValue() != false ? "1" : "0") + "'" : string4 + "'" + entry.getValue() + "'");
                string4 = string4 + (iterator.hasNext() ? "," : ")");
            }
            string2 = string2 + string3;
            string2 = string2 + string4;
            try {
                Statement statement = this.cntx.createStatement();
                int n = statement.executeUpdate(string2);
                statement.close();
                return n != 0;
            }
            catch (SQLException sQLException) {
                TownyMessaging.sendErrorMsg("SQL: Insert sql error " + sQLException.getMessage() + " --> " + string2);
                return false;
            }
        }
        String string5 = "UPDATE " + this.tb_prefix + string.toUpperCase() + " SET ";
        Set<Map.Entry<String, Object>> set = hashMap.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            string5 = string5 + "`" + object.getKey() + "` = ";
            string5 = object.getValue() instanceof String ? string5 + "'" + ((String)object.getValue()).replace("'", "''") + "'" : (object.getValue() instanceof Boolean ? string5 + "'" + ((Boolean)object.getValue() != false ? "1" : "0") + "'" : string5 + "'" + object.getValue() + "'");
            string5 = string5 + (iterator.hasNext() ? "," : "");
        }
        string5 = string5 + " WHERE ";
        object = list.iterator();
        while (object.hasNext()) {
            String string6 = (String)object.next();
            string5 = string5 + "`" + string6 + "` = ";
            Object object2 = hashMap.get(string6);
            string5 = object2 instanceof String ? string5 + "'" + object2 + "'" : (object2 instanceof Boolean ? string5 + "'" + ((Boolean)object2 != false ? "1" : "0") + "'" : string5 + object2);
            string5 = string5 + (object.hasNext() ? " AND " : "");
        }
        try {
            Statement statement = this.cntx.createStatement();
            int n = statement.executeUpdate(string5);
            statement.close();
            if (n == 0) {
                return this.UpdateDB(string, hashMap, null);
            }
            return true;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: Update sql error " + sQLException.getMessage() + " --> " + string5);
            return false;
        }
    }

    public boolean DeleteDB(String string, HashMap<String, Object> hashMap) {
        if (!this.getContext()) {
            return false;
        }
        try {
            Object object;
            String string2 = "DELETE FROM " + this.tb_prefix + string.toUpperCase() + " WHERE ";
            Set<Map.Entry<String, Object>> set = hashMap.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                string2 = string2 + "`" + (String)object.getKey() + "` = ";
                string2 = object.getValue() instanceof String ? string2 + "'" + ((String)object.getValue()).replace("'", "''") + "'" : (object.getValue() instanceof Boolean ? string2 + "'" + ((Boolean)object.getValue() != false ? "1" : "0") + "'" : string2 + "'" + object.getValue() + "'");
                string2 = string2 + (iterator.hasNext() ? " AND " : "");
            }
            object = this.cntx.createStatement();
            int n = object.executeUpdate(string2);
            object.close();
            if (n == 0) {
                TownyMessaging.sendDebugMsg("SQL: delete returned 0: " + string2);
            }
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: Error delete : " + sQLException.getMessage());
        }
        return false;
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT name FROM " + this.tb_prefix + "RESIDENTS");
            while (resultSet.next()) {
                try {
                    this.newResident(resultSet.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT name FROM " + this.tb_prefix + "TOWNS");
            while (resultSet.next()) {
                try {
                    this.newTown(resultSet.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: town list sql error : " + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: town list unknown error: ");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT name FROM " + this.tb_prefix + "NATIONS");
            while (resultSet.next()) {
                try {
                    this.newNation(resultSet.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: nation list sql error : " + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: nation list unknown error : ");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorldList() {
        TownyMessaging.sendDebugMsg("Loading World List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT name FROM " + this.tb_prefix + "WORLDS");
            while (resultSet.next()) {
                try {
                    this.newWorld(resultSet.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: world list sql error : " + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: world list unknown error : ");
            exception.printStackTrace();
        }
        if (this.plugin != null) {
            for (ResultSet resultSet : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(resultSet.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                }
                catch (NotRegisteredException notRegisteredException) {}
            }
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Loading resident " + resident.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.tb_prefix + "RESIDENTS " + " WHERE name='" + resident.getName() + "'");
            if (resultSet.next()) {
                try {
                    resident.setLastOnline(resultSet.getLong("lastOnline"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    resident.setRegistered(resultSet.getLong("registered"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    resident.setNPC(resultSet.getBoolean("isNPC"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    resident.setTitle(resultSet.getString("title"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    resident.setSurname(resultSet.getString("surname"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string = resultSet.getString("town");
                if (string != null && !string.isEmpty()) {
                    resident.setTown(this.getTown(string));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set to Town " + string);
                }
                if ((string = resultSet.getString("town-ranks")) != null && !string.isEmpty()) {
                    resident.setTownRanks(new ArrayList<String>(Arrays.asList(string.split(","))));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set Town-ranks " + string);
                }
                if ((string = resultSet.getString("nation-ranks")) != null && !string.isEmpty()) {
                    resident.setNationRanks(new ArrayList<String>(Arrays.asList(string.split(","))));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set Nation-ranks " + string);
                }
                try {
                    string = resultSet.getString("friends");
                    if (string != null) {
                        String[] stringArray;
                        for (String string2 : stringArray = string.split(",")) {
                            Resident resident2;
                            if (string2.isEmpty() || (resident2 = this.getResident(string2)) == null) continue;
                            resident.addFriend(resident2);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    resident.setPermissions(resultSet.getString("protectionStatus"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = resultSet.getString("townBlocks");
                if (string != null && !string.isEmpty()) {
                    this.utilLoadTownBlocks(string, null, resident);
                }
                statement.close();
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Load resident unknown error");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTown(Town town) {
        TownyMessaging.sendDebugMsg("Loading town " + town.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNS " + " WHERE name='" + town.getName() + "'");
            if (resultSet.next()) {
                Object object;
                int n;
                int n2;
                String[] stringArray;
                String[] stringArray2;
                String string = resultSet.getString("residents");
                if (string != null) {
                    stringArray = stringArray2 = string.split(",");
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        Resident object2;
                        object = stringArray[n];
                        if (((String)object).isEmpty() || (object2 = this.getResident((String)object)) == null) continue;
                        town.addResident(object2);
                    }
                }
                town.setMayor(this.getResident(resultSet.getString("mayor")));
                town.setTownBoard(resultSet.getString("townBoard"));
                string = resultSet.getString("tag");
                if (string != null) {
                    try {
                        town.setTag(string);
                    }
                    catch (TownyException townyException) {
                        town.setTag("");
                    }
                }
                town.setPermissions(resultSet.getString("protectionStatus"));
                town.setBonusBlocks(resultSet.getInt("bonus"));
                town.setTaxPercentage(resultSet.getBoolean("taxpercent"));
                town.setTaxes(resultSet.getFloat("taxes"));
                town.setHasUpkeep(resultSet.getBoolean("hasUpkeep"));
                town.setPlotPrice(resultSet.getFloat("plotPrice"));
                town.setPlotTax(resultSet.getFloat("plotTax"));
                town.setEmbassyPlotPrice(resultSet.getFloat("embassyPlotPrice"));
                town.setEmbassyPlotTax(resultSet.getFloat("embassyPlotTax"));
                town.setCommercialPlotPrice(resultSet.getFloat("commercialPlotPrice"));
                town.setCommercialPlotTax(resultSet.getFloat("commercialPlotTax"));
                town.setOpen(resultSet.getBoolean("open"));
                town.setPublic(resultSet.getBoolean("public"));
                town.setPurchasedBlocks(resultSet.getInt("purchased"));
                string = resultSet.getString("townBlocks");
                if (string != null) {
                    this.utilLoadTownBlocks(string, town, null);
                }
                if ((string = resultSet.getString("homeBlock")) != null && (stringArray2 = string.split(",")).length == 3) {
                    try {
                        stringArray = this.getWorld(stringArray2[0]);
                        try {
                            n2 = Integer.parseInt(stringArray2[1]);
                            n = Integer.parseInt(stringArray2[2]);
                            object = stringArray.getTownBlock(n2, n);
                            town.setHomeBlock((TownBlock)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                    }
                }
                if ((string = resultSet.getString("spawn")) != null) {
                    stringArray2 = string.split(",");
                    if (stringArray2.length >= 4) {
                        try {
                            stringArray = this.plugin.getServerWorld(stringArray2[0]);
                            double d = Double.parseDouble(stringArray2[1]);
                            double d2 = Double.parseDouble(stringArray2[2]);
                            double numberFormatException = Double.parseDouble(stringArray2[3]);
                            Location location = new Location((World)stringArray, d, d2, numberFormatException);
                            if (stringArray2.length == 6) {
                                location.setPitch(Float.parseFloat(stringArray2[4]));
                                location.setYaw(Float.parseFloat(stringArray2[5]));
                            }
                            town.setSpawn(location);
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (NotRegisteredException notRegisteredException) {
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (TownyException townyException) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a spawn point.");
                        }
                    }
                    if ((string = resultSet.getString("outpostSpawns")) != null) {
                        for (String string2 : stringArray = string.split(";")) {
                            stringArray2 = string2.split(",");
                            if (stringArray2.length < 4) continue;
                            try {
                                World notRegisteredException = this.plugin.getServerWorld(stringArray2[0]);
                                double d = Double.parseDouble(stringArray2[1]);
                                double d2 = Double.parseDouble(stringArray2[2]);
                                double d3 = Double.parseDouble(stringArray2[3]);
                                Location location = new Location(notRegisteredException, d, d2, d3);
                                if (stringArray2.length == 6) {
                                    location.setPitch(Float.parseFloat(stringArray2[4]));
                                    location.setYaw(Float.parseFloat(stringArray2[5]));
                                }
                                town.addOutpostSpawn(location);
                            }
                            catch (NumberFormatException nullPointerException) {
                            }
                            catch (NotRegisteredException townyException) {
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (TownyException townyException) {
                                // empty catch block
                            }
                        }
                    }
                }
                statement.close();
                return true;
            }
            statement.close();
            return false;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: Load Town sql Error - " + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Load Town unknown Error - ");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        String string = "";
        TownyMessaging.sendDebugMsg("Loading nation " + nation.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.tb_prefix + "NATIONS WHERE name='" + nation.getName() + "'");
            while (resultSet.next()) {
                TownyEconomyObject townyEconomyObject;
                String[] stringArray;
                string = resultSet.getString("towns");
                if (string != null) {
                    for (String string2 : stringArray = string.split(",")) {
                        if (string2.isEmpty() || (townyEconomyObject = this.getTown(string2)) == null) continue;
                        nation.addTown((Town)townyEconomyObject);
                    }
                }
                nation.setCapital(this.getTown(resultSet.getString("capital")));
                nation.setTag(resultSet.getString("tag"));
                string = resultSet.getString("allies");
                if (string != null) {
                    for (String string2 : stringArray = string.split(",")) {
                        if (string2.isEmpty() || (townyEconomyObject = this.getNation(string2)) == null) continue;
                        nation.addAlly((Nation)townyEconomyObject);
                    }
                }
                if ((string = resultSet.getString("enemies")) != null) {
                    for (String string2 : stringArray = string.split(",")) {
                        if (string2.isEmpty() || (townyEconomyObject = this.getNation(string2)) == null) continue;
                        nation.addEnemy((Nation)townyEconomyObject);
                    }
                }
                nation.setTaxes(resultSet.getDouble("taxes"));
                nation.setNeutral(resultSet.getBoolean("neutral"));
            }
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation sql error " + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation unknown error - ");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld townyWorld) {
        String string = "";
        Boolean bl = false;
        TownyMessaging.sendDebugMsg("Loading world " + townyWorld.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement statement = this.cntx.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.tb_prefix + "WORLDS WHERE name='" + townyWorld.getName() + "'");
            while (resultSet.next()) {
                Long l;
                Object object;
                string = resultSet.getString("towns");
                if (string != null) {
                    String[] stringArray = string.split(",");
                    for (String string2 : stringArray) {
                        Town town;
                        if (string2.isEmpty() || (town = this.getTown(string2)) == null) continue;
                        town.setWorld(townyWorld);
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("claimable"))) != null) {
                    try {
                        townyWorld.setClaimable(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("pvp"))) != null) {
                    try {
                        townyWorld.setPVP(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("forcepvp"))) != null) {
                    try {
                        townyWorld.setForcePVP(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("forcetownmobs"))) != null) {
                    try {
                        townyWorld.setForceTownMobs(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("worldmobs"))) != null) {
                    try {
                        townyWorld.setWorldMobs(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("firespread"))) != null) {
                    try {
                        townyWorld.setFire(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("forcefirespread"))) != null) {
                    try {
                        townyWorld.setForceFire(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("explosions"))) != null) {
                    try {
                        townyWorld.setExpl(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("forceexplosions"))) != null) {
                    try {
                        townyWorld.setForceExpl(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("endermanprotect"))) != null) {
                    try {
                        townyWorld.setEndermanProtect(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("disableplayertrample"))) != null) {
                    try {
                        townyWorld.setDisablePlayerTrample(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("disablecreaturetrample"))) != null) {
                    try {
                        townyWorld.setDisableCreatureTrample(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("unclaimedZoneBuild"))) != null) {
                    try {
                        townyWorld.setUnclaimedZoneBuild(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("unclaimedZoneDestroy"))) != null) {
                    try {
                        townyWorld.setUnclaimedZoneDestroy(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("unclaimedZoneSwitch"))) != null) {
                    try {
                        townyWorld.setUnclaimedZoneSwitch(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("unclaimedZoneItemUse"))) != null) {
                    try {
                        townyWorld.setUnclaimedZoneItemUse(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                string = resultSet.getString("unclaimedZoneName");
                if (bl != null) {
                    try {
                        townyWorld.setUnclaimedZoneName(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = resultSet.getString("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string2 : string.split(",")) {
                            if (string2.isEmpty()) continue;
                            try {
                                object.add(Integer.parseInt(string2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setUnclaimedZoneIgnore((List<Integer>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("usingPlotManagementDelete"))) != null) {
                    try {
                        townyWorld.setUsingPlotManagementDelete(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = resultSet.getString("plotManagementDeleteIds")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string3 : string.split(",")) {
                            if (string3.isEmpty()) continue;
                            try {
                                object.add(Integer.parseInt(string3));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementDeleteIds((List<Integer>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("usingPlotManagementMayorDelete"))) != null) {
                    try {
                        townyWorld.setUsingPlotManagementMayorDelete(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = resultSet.getString("plotManagementMayorDelete")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string4 : string.split(",")) {
                            if (string4.isEmpty()) continue;
                            try {
                                object.add(string4.toUpperCase().trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementMayorDelete((List<String>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("usingPlotManagementRevert"))) != null) {
                    try {
                        townyWorld.setUsingPlotManagementRevert(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((l = Long.valueOf(resultSet.getLong("PlotManagementRevertSpeed"))) != null) {
                    try {
                        townyWorld.setPlotManagementRevertSpeed(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = resultSet.getString("plotManagementIgnoreIds")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string5 : string.split(",")) {
                            if (string5.isEmpty()) continue;
                            try {
                                object.add(Integer.parseInt(string5));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementIgnoreIds((List<Integer>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("usingPlotManagementWildRegen"))) != null) {
                    try {
                        townyWorld.setUsingPlotManagementWildRevert(bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = resultSet.getString("plotManagementWildRegenEntities")) != null) {
                    try {
                        object = new ArrayList();
                        for (String string6 : string.split(",")) {
                            if (string6.isEmpty()) continue;
                            try {
                                object.add(string6.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        townyWorld.setPlotManagementWildRevertEntities((List<String>)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((l = Long.valueOf(resultSet.getLong("plotManagementWildRegenSpeed"))) != null) {
                    try {
                        townyWorld.setPlotManagementWildRevertDelay(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bl = Boolean.valueOf(resultSet.getBoolean("usingTowny"))) == null) continue;
                try {
                    townyWorld.setUsingTowny(bl);
                }
                catch (Exception exception) {}
            }
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + townyWorld.getName() + ")" + sQLException.getMessage());
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Load world unknown error - ");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTownBlocks() {
        String string = "";
        Boolean bl = false;
        if (!this.getContext()) {
            return false;
        }
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            boolean bl2 = false;
            try {
                Statement statement = this.cntx.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNBLOCKS" + " WHERE world='" + townBlock.getWorld().getName() + "' AND x='" + townBlock.getX() + "' AND z='" + townBlock.getZ() + "'");
                while (resultSet.next()) {
                    string = resultSet.getString("permissions");
                    if (string != null) {
                        try {
                            townBlock.setPermissions(string.trim());
                            bl2 = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((bl = Boolean.valueOf(resultSet.getBoolean("changed"))) != null) {
                        try {
                            townBlock.setChanged(bl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((bl = Boolean.valueOf(resultSet.getBoolean("locked"))) != null) {
                        try {
                            townBlock.setLocked(bl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl2) continue;
                    try {
                        if (townBlock.hasResident()) {
                            townBlock.setPermissions(townBlock.getResident().getPermissions().toString());
                            continue;
                        }
                        townBlock.setPermissions(townBlock.getTown().getPermissions().toString());
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlocks ");
                sQLException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean saveResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Saving Resident");
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", resident.getName());
            hashMap.put("lastOnline", resident.getLastOnline());
            hashMap.put("registered", resident.getRegistered());
            hashMap.put("isNPC", resident.isNPC());
            hashMap.put("title", resident.getTitle());
            hashMap.put("surname", resident.getSurname());
            hashMap.put("town", resident.hasTown() ? resident.getTown().getName() : "");
            hashMap.put("town-ranks", resident.hasTown() ? StringMgmt.join(resident.getTownRanks(), ",") : "");
            hashMap.put("nation-ranks", resident.hasTown() ? StringMgmt.join(resident.getNationRanks(), ",") : "");
            String string = "";
            for (Resident resident2 : resident.getFriends()) {
                string = string + resident2.getName() + ",";
            }
            hashMap.put("friends", string);
            hashMap.put("townBlocks", this.utilSaveTownBlocks(new ArrayList<TownBlock>(resident.getTownBlocks())));
            hashMap.put("protectionStatus", resident.getPermissions().toString());
            this.UpdateDB("RESIDENTS", hashMap, Arrays.asList("name"));
            return true;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Save Resident unknown error " + exception.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveTown(Town town) {
        TownyMessaging.sendDebugMsg("Saving town " + town.getName());
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", town.getName());
            hashMap.put("residents", StringMgmt.join(town.getResidents(), ","));
            hashMap.put("mayor", town.hasMayor() ? town.getMayor().getName() : "");
            hashMap.put("nation", town.hasNation() ? town.getNation().getName() : "");
            String string = "";
            for (Resident object : town.getAssistants()) {
                string = string + object.getName() + ",";
            }
            hashMap.put("assistants", string);
            hashMap.put("townBoard", town.getTownBoard());
            hashMap.put("tag", town.getTag());
            hashMap.put("protectionStatus", town.getPermissions().toString());
            hashMap.put("bonus", town.getBonusBlocks());
            hashMap.put("purchased", town.getPurchasedBlocks());
            hashMap.put("commercialPlotPrice", town.getCommercialPlotPrice());
            hashMap.put("commercialPlotTax", town.getCommercialPlotTax());
            hashMap.put("embassyPlotPrice", town.getEmbassyPlotPrice());
            hashMap.put("embassyPlotTax", town.getEmbassyPlotTax());
            hashMap.put("plotPrice", town.getPlotPrice());
            hashMap.put("plotTax", town.getPlotTax());
            hashMap.put("taxes", town.getTaxes());
            hashMap.put("hasUpkeep", town.hasUpkeep());
            hashMap.put("taxpercent", town.isTaxPercentage());
            hashMap.put("open", town.isOpen());
            hashMap.put("public", town.isPublic());
            hashMap.put("townBlocks", this.utilSaveTownBlocks(new ArrayList<TownBlock>(town.getTownBlocks())));
            hashMap.put("homeblock", town.hasHomeBlock() ? town.getHomeBlock().getWorld().getName() + "," + Integer.toString(town.getHomeBlock().getX()) + "," + Integer.toString(town.getHomeBlock().getZ()) : "");
            hashMap.put("spawn", town.hasSpawn() ? town.getSpawn().getWorld().getName() + "," + Double.toString(town.getSpawn().getX()) + "," + Double.toString(town.getSpawn().getY()) + "," + Double.toString(town.getSpawn().getZ()) + "," + Float.toString(town.getSpawn().getPitch()) + "," + Float.toString(town.getSpawn().getYaw()) : "");
            if (town.hasOutpostSpawn()) {
                Object object = "";
                for (Location location : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                    object = (String)object + location.getWorld().getName() + "," + Double.toString(location.getX()) + "," + Double.toString(location.getY()) + "," + Double.toString(location.getZ()) + "," + Float.toString(location.getPitch()) + "," + Float.toString(location.getYaw()) + ";";
                }
                hashMap.put("outpostSpawns", object);
            }
            this.UpdateDB("TOWNS", hashMap, Arrays.asList("name"));
            return true;
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Save Town unknown error");
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public synchronized boolean saveNation(Nation nation) {
        TownyMessaging.sendDebugMsg("Saving nation " + nation.getName());
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", nation.getName());
            String string = "";
            for (Town townyEconomyObject : nation.getTowns()) {
                string = string + townyEconomyObject.getName() + ",";
            }
            hashMap.put("towns", string);
            hashMap.put("capital", nation.hasCapital() ? nation.getCapital().getName() : "");
            hashMap.put("tag", nation.hasTag() ? nation.getTag() : "");
            string = "";
            for (Resident resident : nation.getAssistants()) {
                string = string + resident.getName() + ",";
            }
            hashMap.put("assistants", string);
            string = "";
            for (Nation nation2 : nation.getAllies()) {
                string = string + nation2.getName() + ",";
            }
            hashMap.put("allies", string);
            string = "";
            for (Nation nation3 : nation.getEnemies()) {
                string = string + nation3.getName() + ",";
            }
            hashMap.put("enemies", string);
            hashMap.put("taxes", nation.getTaxes());
            hashMap.put("neutral", nation.isNeutral());
            this.UpdateDB("NATIONS", hashMap, Arrays.asList("name"));
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Save Nation unknown error");
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized boolean saveWorld(TownyWorld townyWorld) {
        TownyMessaging.sendDebugMsg("Saving world " + townyWorld.getName());
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", townyWorld.getName());
            String string = "";
            for (Town town : townyWorld.getTowns()) {
                string = string + town.getName() + ",";
            }
            hashMap.put("towns", string);
            hashMap.put("pvp", townyWorld.isPVP());
            hashMap.put("forcepvp", townyWorld.isForcePVP());
            hashMap.put("claimable", townyWorld.isClaimable());
            hashMap.put("worldmobs", townyWorld.hasWorldMobs());
            hashMap.put("forcetownmobs", townyWorld.isForceTownMobs());
            hashMap.put("firespread", townyWorld.isFire());
            hashMap.put("forcefirespread", townyWorld.isForceFire());
            hashMap.put("explosions", townyWorld.isExpl());
            hashMap.put("forceexplosions", townyWorld.isForceExpl());
            hashMap.put("endermanprotect", townyWorld.isEndermanProtect());
            hashMap.put("disableplayertrample", townyWorld.isDisablePlayerTrample());
            hashMap.put("disablecreaturetrample", townyWorld.isDisableCreatureTrample());
            hashMap.put("unclaimedZoneBuild", townyWorld.getUnclaimedZoneBuild());
            hashMap.put("unclaimedZoneDestroy", townyWorld.getUnclaimedZoneDestroy());
            hashMap.put("unclaimedZoneSwitch", townyWorld.getUnclaimedZoneSwitch());
            hashMap.put("unclaimedZoneItemUse", townyWorld.getUnclaimedZoneItemUse());
            if (townyWorld.getUnclaimedZoneName() != null) {
                hashMap.put("unclaimedZoneName", townyWorld.getUnclaimedZoneName());
            }
            if (townyWorld.getUnclaimedZoneIgnoreIds() != null) {
                hashMap.put("unclaimedZoneIgnoreIds", StringMgmt.join(townyWorld.getUnclaimedZoneIgnoreIds(), ","));
            }
            hashMap.put("usingPlotManagementDelete", townyWorld.isUsingPlotManagementDelete());
            if (townyWorld.getPlotManagementDeleteIds() != null) {
                hashMap.put("plotManagementDeleteIds", StringMgmt.join(townyWorld.getPlotManagementDeleteIds(), ","));
            }
            hashMap.put("usingPlotManagementMayorDelete", townyWorld.isUsingPlotManagementMayorDelete());
            if (townyWorld.getPlotManagementMayorDelete() != null) {
                hashMap.put("plotManagementMayorDelete", StringMgmt.join(townyWorld.getPlotManagementMayorDelete(), ","));
            }
            hashMap.put("usingPlotManagementRevert", townyWorld.isUsingPlotManagementRevert());
            hashMap.put("plotManagementRevertSpeed", townyWorld.getPlotManagementRevertSpeed());
            if (townyWorld.getPlotManagementIgnoreIds() != null) {
                hashMap.put("plotManagementIgnoreIds", StringMgmt.join(townyWorld.getPlotManagementIgnoreIds(), ","));
            }
            hashMap.put("usingPlotManagementWildRegen", townyWorld.isUsingPlotManagementWildRevert());
            if (townyWorld.getPlotManagementWildRevertEntities() != null) {
                hashMap.put("PlotManagementWildRegenEntities", StringMgmt.join(townyWorld.getPlotManagementWildRevertEntities(), ","));
            }
            hashMap.put("plotManagementWildRegenSpeed", townyWorld.getPlotManagementWildRevertDelay());
            hashMap.put("usingTowny", townyWorld.isUsingTowny());
            this.UpdateDB("WORLDS", hashMap, Arrays.asList("name"));
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Save world unknown error (" + townyWorld.getName() + ")");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean saveTownBlock(TownBlock townBlock) {
        TownyMessaging.sendDebugMsg("Saving town block " + townBlock.getWorld().getName() + ":" + townBlock.getX() + "x" + townBlock.getZ());
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("world", townBlock.getWorld().getName());
            hashMap.put("x", townBlock.getX());
            hashMap.put("z", townBlock.getZ());
            hashMap.put("permissions", townBlock.getPermissions().toString());
            hashMap.put("locked", townBlock.isLocked());
            hashMap.put("changed", townBlock.isChanged());
            this.UpdateDB("TOWNBLOCKS", hashMap, Arrays.asList("world", "x", "z"));
        }
        catch (Exception exception) {
            TownyMessaging.sendErrorMsg("SQL: Save TownBlock unknown error");
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public void deleteResident(Resident resident) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", resident.getName());
        this.DeleteDB("RESIDENTS", hashMap);
    }

    @Override
    public void deleteTown(Town town) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", town.getName());
        this.DeleteDB("TOWNS", hashMap);
    }

    @Override
    public void deleteNation(Nation nation) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", nation.getName());
        this.DeleteDB("NATIONS", hashMap);
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("world", townBlock.getWorld().getName());
        hashMap.put("x", townBlock.getX());
        hashMap.put("z", townBlock.getZ());
        this.DeleteDB("TOWNBLOCKS", hashMap);
    }

    @Override
    public synchronized void backup() throws IOException {
        TownyMessaging.sendMsg("Performing backup");
        TownyMessaging.sendMsg("***** Warning *****");
        TownyMessaging.sendMsg("***** Only Snapshots and Regen files will be backed up");
        TownyMessaging.sendMsg("***** Make sure you schedule a backup in MySQL too!!!");
        String string = TownySettings.getFlatFileBackupType();
        if (!string.equalsIgnoreCase("none")) {
            TownyLogger.shutDown();
            long l = System.currentTimeMillis();
            String string2 = this.rootFolder + FileMgmt.fileSeparator() + "backup" + FileMgmt.fileSeparator() + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(l) + " - " + Long.toString(l);
            FileMgmt.checkFolders(new String[]{this.rootFolder, this.rootFolder + FileMgmt.fileSeparator() + "backup"});
            if (string.equalsIgnoreCase("folder")) {
                FileMgmt.checkFolders(new String[]{string2});
                FileMgmt.copyDirectory(new File(this.rootFolder + this.dataFolder), new File(string2));
                FileMgmt.copyDirectory(new File(this.rootFolder + this.logFolder), new File(string2));
                FileMgmt.copyDirectory(new File(this.rootFolder + this.settingsFolder), new File(string2));
            } else if (string.equalsIgnoreCase("zip")) {
                FileMgmt.zipDirectories(new File[]{new File(this.rootFolder + this.dataFolder), new File(this.rootFolder + this.logFolder), new File(this.rootFolder + this.settingsFolder)}, new File(string2 + ".zip"));
            } else {
                this.plugin.setupLogger();
                throw new IOException("[Towny] Unsupported flatfile backup type (" + string + ")");
            }
            this.plugin.setupLogger();
        }
    }

    @Override
    public boolean saveResidentList() {
        return true;
    }

    @Override
    public boolean saveTownList() {
        return true;
    }

    @Override
    public boolean saveNationList() {
        return true;
    }

    @Override
    public boolean saveWorldList() {
        return true;
    }
}

