/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.NeedsPlaceholder;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class TownyBlockListener
implements Listener {
    private final Towny plugin;

    public TownyBlockListener(Towny towny) {
        this.plugin = towny;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent blockPhysicsEvent) {
        if (this.plugin.isError()) {
            blockPhysicsEvent.setCancelled(true);
            return;
        }
        if (TownySettings.getRegenDelay() <= 0L) {
            return;
        }
        Block block = blockPhysicsEvent.getBlock();
        if (block == null) {
            return;
        }
        BlockLocation blockLocation = new BlockLocation(block.getLocation());
        if (TownyRegenAPI.isPlaceholder(block)) {
            TownyRegenAPI.removePlaceholder(block);
            block.setTypeId(0, false);
        }
        if (TownyRegenAPI.hasProtectionRegenTask(blockLocation)) {
            blockPhysicsEvent.setCancelled(true);
        } else {
            Block block2 = block.getRelative(BlockFace.DOWN);
            blockLocation = new BlockLocation(block2.getLocation());
            if (TownyRegenAPI.hasProtectionRegenTask(blockLocation) && NeedsPlaceholder.contains(block.getType())) {
                blockPhysicsEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        Block block;
        if (this.plugin.isError()) {
            blockBreakEvent.setCancelled(true);
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        boolean bl = PlayerCacheUtil.getCachePermission(player, (block = blockBreakEvent.getBlock()).getLocation(), block.getTypeId(), block.getData(), TownyPermission.ActionType.DESTROY);
        if (bl) {
            return;
        }
        PlayerCache playerCache = this.plugin.getCache(player);
        if (playerCache.getStatus() == PlayerCache.TownBlockStatus.WARZONE) {
            if (!TownyWarConfig.isEditableMaterialInWarZone(block.getType())) {
                blockBreakEvent.setCancelled(true);
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_warzone_cannot_edit_material"), "destroy", block.getType().toString().toLowerCase()));
            }
            return;
        }
        long l = TownySettings.getRegenDelay();
        if (l > 0L) {
            if (!TownyRegenAPI.isPlaceholder(block)) {
                if (!TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) {
                    ProtectionRegenTask protectionRegenTask = new ProtectionRegenTask(this.plugin, block, true);
                    protectionRegenTask.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)protectionRegenTask, 20L * l));
                    TownyRegenAPI.addProtectionRegenTask(protectionRegenTask);
                }
            } else {
                TownyRegenAPI.removePlaceholder(block);
                block.setTypeId(0, false);
            }
        } else {
            blockBreakEvent.setCancelled(true);
        }
        if (playerCache.hasBlockErrMsg() && blockBreakEvent.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, playerCache.getBlockErrMsg());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (this.plugin.isError()) {
            blockPlaceEvent.setCancelled(true);
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        Block block = blockPlaceEvent.getBlock();
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(block.getWorld().getName());
            WorldCoord worldCoord = new WorldCoord(townyWorld.getName(), Coord.parseCoord(block));
            boolean bl = PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getTypeId(), block.getData(), TownyPermission.ActionType.BUILD);
            if (bl) {
                return;
            }
            PlayerCache playerCache = this.plugin.getCache(player);
            PlayerCache.TownBlockStatus townBlockStatus = playerCache.getStatus();
            if (townBlockStatus == PlayerCache.TownBlockStatus.ENEMY && TownyWarConfig.isAllowingAttacks() && blockPlaceEvent.getBlock().getType() == TownyWarConfig.getFlagBaseMaterial()) {
                try {
                    if (TownyWar.callAttackCellEvent(this.plugin, player, block, worldCoord)) {
                        return;
                    }
                }
                catch (TownyException townyException) {
                    TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
                }
                blockPlaceEvent.setBuild(false);
                blockPlaceEvent.setCancelled(true);
            } else {
                if (townBlockStatus == PlayerCache.TownBlockStatus.WARZONE) {
                    if (!TownyWarConfig.isEditableMaterialInWarZone(block.getType())) {
                        blockPlaceEvent.setBuild(false);
                        blockPlaceEvent.setCancelled(true);
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_warzone_cannot_edit_material"), "build", block.getType().toString().toLowerCase()));
                    }
                    return;
                }
                blockPlaceEvent.setBuild(false);
                blockPlaceEvent.setCancelled(true);
            }
            if (playerCache.hasBlockErrMsg() && blockPlaceEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, playerCache.getBlockErrMsg());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent blockBurnEvent) {
        if (this.plugin.isError()) {
            blockBurnEvent.setCancelled(true);
            return;
        }
        if (this.onBurn(blockBurnEvent.getBlock())) {
            blockBurnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockIgnite(BlockIgniteEvent blockIgniteEvent) {
        if (blockIgniteEvent.isCancelled() || this.plugin.isError()) {
            blockIgniteEvent.setCancelled(true);
            return;
        }
        if (this.onBurn(blockIgniteEvent.getBlock())) {
            blockIgniteEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        if (this.plugin.isError()) {
            blockPistonRetractEvent.setCancelled(true);
            return;
        }
        Block block = blockPistonRetractEvent.getBlock();
        if (block.getType() != Material.PISTON_STICKY_BASE) {
            return;
        }
        if ((block = block.getRelative(blockPistonRetractEvent.getDirection()).getRelative(blockPistonRetractEvent.getDirection())).getType() != Material.AIR && !block.isLiquid() && this.testBlockMove(block, blockPistonRetractEvent.getDirection().getOppositeFace())) {
            blockPistonRetractEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        if (this.plugin.isError()) {
            blockPistonExtendEvent.setCancelled(true);
            return;
        }
        List list = blockPistonExtendEvent.getBlocks();
        if (!list.isEmpty()) {
            for (Block block : list) {
                if (!this.testBlockMove(block, blockPistonExtendEvent.getDirection())) continue;
                blockPistonExtendEvent.setCancelled(true);
            }
        }
    }

    private boolean testBlockMove(Block block, BlockFace blockFace) {
        Block block2 = block.getRelative(blockFace);
        Location location = block.getLocation();
        Location location2 = block2.getLocation();
        Coord coord = Coord.parseCoord(location);
        Coord coord2 = Coord.parseCoord(location2);
        TownyWorld townyWorld = null;
        TownBlock townBlock = null;
        TownBlock townBlock2 = null;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(location.getWorld().getName());
            townBlock = townyWorld.getTownBlock(coord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            townBlock2 = townyWorld.getTownBlock(coord2);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townBlock != townBlock2) {
            if (townBlock == null && townBlock2 != null || townBlock != null && townBlock2 == null) {
                return true;
            }
            if (!townBlock.hasResident() && !townBlock2.hasResident()) {
                return false;
            }
            try {
                if (!townBlock.hasResident() && townBlock2.hasResident() || townBlock.hasResident() && !townBlock2.hasResident() || townBlock.getResident() != townBlock2.getResident() || townBlock.getPlotPrice() != -1.0 || townBlock2.getPlotPrice() != -1.0) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                return true;
            }
        }
        return false;
    }

    private boolean onBurn(Block block) {
        Location location = block.getLocation();
        Coord coord = Coord.parseCoord(location);
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(location.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return false;
            }
            try {
                if (townyWorld.isWarZone(coord)) {
                    if (TownyWarConfig.isAllowingFireInWarZone()) {
                        return false;
                    }
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getTypeId() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
                TownBlock townBlock = townyWorld.getTownBlock(coord);
                if (block.getRelative(BlockFace.DOWN).getType() != Material.OBSIDIAN && (!townBlock.getTown().isFire() && !townyWorld.isForceFire() && !townBlock.getPermissions().fire || TownyUniverse.isWarTime() && TownySettings.isAllowWarBlockGriefing() && !townBlock.getTown().hasNation())) {
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getTypeId() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
            }
            catch (TownyException townyException) {
                if (!townyWorld.isFire()) {
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getTypeId() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }
}

