/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.ArraySort;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.painting.PaintingBreakByEntityEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.plugin.Plugin;

public class TownyEntityListener
implements Listener {
    private final Towny plugin;

    public TownyEntityListener(Towny towny) {
        this.plugin = towny;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.plugin.isError()) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!TownyUniverse.isWarTime() && CombatUtil.preventDamageCall(entity, entityDamageByEntityEvent.getEntity())) {
            if (entity instanceof Projectile) {
                entity.remove();
            }
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        if (this.plugin.isError()) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity instanceof Monster) {
            Location location = livingEntity.getLocation();
            TownyWorld townyWorld = null;
            try {
                townyWorld = TownyUniverse.getDataSource().getWorld(location.getWorld().getName());
                if (townyWorld.isUsingTowny() && townyWorld.getTownBlock(Coord.parseCoord(location)).getType() == TownBlockType.ARENA) {
                    entityDeathEvent.getDrops().clear();
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent potionSplashEvent) {
        List list = (List)potionSplashEvent.getAffectedEntities();
        ThrownPotion thrownPotion = potionSplashEvent.getPotion();
        LivingEntity livingEntity = thrownPotion.getShooter();
        if (!TownyUniverse.isWarTime()) {
            for (LivingEntity livingEntity2 : list) {
                if (livingEntity == livingEntity2 || !CombatUtil.preventDamageCall((Entity)livingEntity, (Entity)livingEntity2)) continue;
                potionSplashEvent.setIntensity(livingEntity2, -1.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (this.plugin.isError()) {
            creatureSpawnEvent.setCancelled(true);
            return;
        }
        if (creatureSpawnEvent.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = creatureSpawnEvent.getEntity();
            Location location = creatureSpawnEvent.getLocation();
            Coord coord = Coord.parseCoord(location);
            TownyWorld townyWorld = null;
            try {
                townyWorld = TownyUniverse.getDataSource().getWorld(location.getWorld().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                return;
            }
            if (townyWorld.isUsingTowny() && !townyWorld.hasWorldMobs() && (MobRemovalTimerTask.isRemovingWorldEntity(livingEntity) || livingEntity instanceof Villager && !((Villager)livingEntity).isAdult() && TownySettings.isRemovingVillagerBabiesWorld())) {
                if (this.plugin.isCitizens2()) {
                    if (!CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) {
                        creatureSpawnEvent.setCancelled(true);
                    }
                } else {
                    creatureSpawnEvent.setCancelled(true);
                }
            }
            try {
                TownBlock townBlock = townyWorld.getTownBlock(coord);
                if (townyWorld.isUsingTowny() && !townyWorld.isForceTownMobs() && !townBlock.getTown().hasMobs() && !townBlock.getPermissions().mobs && (MobRemovalTimerTask.isRemovingTownEntity(livingEntity) || livingEntity instanceof Villager && !((Villager)livingEntity).isAdult() && TownySettings.isRemovingVillagerBabiesTown())) {
                    if (this.plugin.isCitizens2()) {
                        if (!CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) {
                            creatureSpawnEvent.setCancelled(true);
                        }
                    } else {
                        creatureSpawnEvent.setCancelled(true);
                    }
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent entityInteractEvent) {
        if (this.plugin.isError()) {
            entityInteractEvent.setCancelled(true);
            return;
        }
        Block block = entityInteractEvent.getBlock();
        Entity entity = entityInteractEvent.getEntity();
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(block.getLocation().getWorld().getName());
            if (townyWorld.isUsingTowny() && townyWorld.isDisableCreatureTrample() && (block.getType() == Material.SOIL || block.getType() == Material.CROPS)) {
                if (entity instanceof Creature) {
                    entityInteractEvent.setCancelled(true);
                }
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (this.plugin.isError()) {
            entityChangeBlockEvent.setCancelled(true);
            return;
        }
        switch (entityChangeBlockEvent.getEntity().getType()) {
            case ENDERMAN: {
                try {
                    TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(entityChangeBlockEvent.getBlock().getWorld().getName());
                    if (!townyWorld.isUsingTowny()) {
                        return;
                    }
                    if (!townyWorld.isEndermanProtect()) break;
                    entityChangeBlockEvent.setCancelled(true);
                }
                catch (NotRegisteredException notRegisteredException) {}
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent entityExplodeEvent) {
        TownyWorld townyWorld;
        if (this.plugin.isError()) {
            entityExplodeEvent.setCancelled(true);
            return;
        }
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(entityExplodeEvent.getLocation().getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return;
        }
        List list = entityExplodeEvent.blockList();
        Entity entity = entityExplodeEvent.getEntity();
        int n = 0;
        Collections.sort(list, ArraySort.getInstance());
        for (Block block : list) {
            Coord coord = Coord.parseCoord(block.getLocation());
            ++n;
            if (townyWorld.isWarZone(coord)) {
                if (!TownyWarConfig.isAllowingExplosionsInWarZone()) {
                    if (entityExplodeEvent.getEntity() != null) {
                        TownyMessaging.sendDebugMsg("onEntityExplode: Canceled " + entityExplodeEvent.getEntity().getEntityId() + " from exploding within " + coord.toString() + ".");
                    }
                    entityExplodeEvent.setCancelled(true);
                    return;
                }
                if (TownyWarConfig.explosionsBreakBlocksInWarZone()) {
                    if (TownyWarConfig.regenBlocksAfterExplosionInWarZone()) {
                        // empty if block
                    }
                } else {
                    entityExplodeEvent.blockList().remove(block);
                }
                return;
            }
            try {
                TownBlock townBlock = townyWorld.getTownBlock(coord);
                if (!townyWorld.isUsingTowny() || townyWorld.isForceExpl() || townBlock.getPermissions().explosion && (!TownyUniverse.isWarTime() || !TownySettings.isAllowWarBlockGriefing() || townBlock.getTown().hasNation() || townBlock.getTown().isBANG())) continue;
                if (entityExplodeEvent.getEntity() != null) {
                    TownyMessaging.sendDebugMsg("onEntityExplode: Canceled " + entityExplodeEvent.getEntity().getEntityId() + " from exploding within " + coord.toString() + ".");
                }
                entityExplodeEvent.setCancelled(true);
                return;
            }
            catch (TownyException townyException) {
                if (!townyWorld.isUsingTowny()) continue;
                if (townyWorld.isExpl()) {
                    if (!townyWorld.isUsingPlotManagementWildRevert() || entity == null || !townyWorld.isProtectingExplosionEntity(entity) || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation())) || block.getType() == Material.TNT) continue;
                    ProtectionRegenTask protectionRegenTask = new ProtectionRegenTask(this.plugin, block, false);
                    protectionRegenTask.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)protectionRegenTask, (TownySettings.getPlotManagementWildRegenDelay() + (long)n) * 20L));
                    TownyRegenAPI.addProtectionRegenTask(protectionRegenTask);
                    entityExplodeEvent.setYield(0.0f);
                    block.getDrops().clear();
                    continue;
                }
                entityExplodeEvent.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent entityCombustByEntityEvent) {
        LivingEntity livingEntity;
        if (this.plugin.isError()) {
            entityCombustByEntityEvent.setCancelled(true);
            return;
        }
        Entity entity = entityCombustByEntityEvent.getCombuster();
        Entity entity2 = entityCombustByEntityEvent.getEntity();
        if (entity instanceof Projectile && (livingEntity = ((Projectile)entity).getShooter()) != null && !TownyUniverse.isWarTime() && CombatUtil.preventDamageCall((Entity)livingEntity, entity2)) {
            entity.remove();
            entityCombustByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingBreak(PaintingBreakEvent paintingBreakEvent) {
        block12: {
            if (this.plugin.isError()) {
                paintingBreakEvent.setCancelled(true);
                return;
            }
            if (paintingBreakEvent instanceof PaintingBreakByEntityEvent) {
                PaintingBreakByEntityEvent paintingBreakByEntityEvent = (PaintingBreakByEntityEvent)paintingBreakEvent;
                Painting painting = paintingBreakByEntityEvent.getPainting();
                Entity entity = paintingBreakByEntityEvent.getRemover();
                try {
                    String string = painting.getWorld().getName();
                    TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(string);
                    if (!townyWorld.isUsingTowny()) {
                        return;
                    }
                    if (entity instanceof Player) {
                        Player player = (Player)paintingBreakByEntityEvent.getRemover();
                        boolean bl = PlayerCacheUtil.getCachePermission(player, painting.getLocation(), 321, (byte)0, TownyPermission.ActionType.DESTROY);
                        if (bl) {
                            return;
                        }
                        PlayerCache playerCache = this.plugin.getCache(player);
                        paintingBreakEvent.setCancelled(true);
                        if (playerCache.hasBlockErrMsg()) {
                            TownyMessaging.sendErrorMsg((Object)player, playerCache.getBlockErrMsg());
                        }
                        break block12;
                    }
                    if (!(entity instanceof Fireball) && !(entity instanceof LightningStrike)) break block12;
                    try {
                        TownBlock townBlock = new WorldCoord(string, Coord.parseCoord(painting.getLocation())).getTownBlock();
                        if (!townBlock.getPermissions().explosion && !townBlock.getWorld().isForceExpl()) {
                            paintingBreakEvent.setCancelled(true);
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        if (!townyWorld.isExpl() && !townyWorld.isForceExpl()) {
                            paintingBreakEvent.setCancelled(true);
                        }
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    paintingBreakEvent.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingPlace(PaintingPlaceEvent paintingPlaceEvent) {
        if (this.plugin.isError()) {
            paintingPlaceEvent.setCancelled(true);
            return;
        }
        long l = System.currentTimeMillis();
        Player player = paintingPlaceEvent.getPlayer();
        Painting painting = paintingPlaceEvent.getPainting();
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(painting.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
            boolean bl = PlayerCacheUtil.getCachePermission(player, painting.getLocation(), 321, (byte)0, TownyPermission.ActionType.BUILD);
            if (bl) {
                return;
            }
            PlayerCache playerCache = this.plugin.getCache(player);
            paintingPlaceEvent.setCancelled(true);
            if (playerCache.hasBlockErrMsg()) {
                TownyMessaging.sendErrorMsg((Object)player, playerCache.getBlockErrMsg());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            paintingPlaceEvent.setCancelled(true);
            return;
        }
        TownyMessaging.sendDebugMsg("onPaintingBreak took " + (System.currentTimeMillis() - l) + "ms (" + paintingPlaceEvent.getEventName() + ", " + paintingPlaceEvent.isCancelled() + ")");
    }
}

