/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;

public class TownyPlayerListener
implements Listener {
    private final Towny plugin;

    public TownyPlayerListener(Towny towny) {
        this.plugin = towny;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (this.plugin.isError()) {
            player.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
            return;
        }
        try {
            this.plugin.getTownyUniverse().onLogin(player);
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        if (this.plugin.isError()) {
            return;
        }
        this.plugin.getTownyUniverse().onLogout(playerQuitEvent.getPlayer());
        try {
            if (TownyTimerHandler.isTeleportWarmupRunning()) {
                this.plugin.getTownyUniverse().abortTeleportRequest(TownyUniverse.getDataSource().getResident(playerQuitEvent.getPlayer().getName().toLowerCase()));
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.plugin.deleteCache(playerQuitEvent.getPlayer());
        TownyPerms.removeAttachment(playerQuitEvent.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        if (this.plugin.isError()) {
            return;
        }
        Player player = playerRespawnEvent.getPlayer();
        TownyMessaging.sendDebugMsg("onPlayerDeath: " + player.getName());
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        try {
            Location location = this.plugin.getTownyUniverse().getTownSpawnLocation(player);
            if (TownySettings.isTownRespawningInOtherWorlds() && !player.getWorld().equals(location.getWorld())) {
                return;
            }
            playerRespawnEvent.setRespawnLocation(location);
        }
        catch (TownyException townyException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent playerBucketEmptyEvent) {
        if (this.plugin.isError()) {
            playerBucketEmptyEvent.setCancelled(true);
            return;
        }
        playerBucketEmptyEvent.setCancelled(this.onPlayerInteract(playerBucketEmptyEvent.getPlayer(), null, playerBucketEmptyEvent.getItemStack()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent playerBucketFillEvent) {
        if (this.plugin.isError()) {
            playerBucketFillEvent.setCancelled(true);
            return;
        }
        playerBucketFillEvent.setCancelled(this.onPlayerInteract(playerBucketFillEvent.getPlayer(), null, playerBucketFillEvent.getItemStack()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (this.plugin.isError()) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        Block block = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(block.getLocation().getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
            return;
        }
        if (playerInteractEvent.getAction() == Action.PHYSICAL && (block.getType() == Material.SOIL || block.getType() == Material.CROPS) && townyWorld.isDisablePlayerTrample()) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (playerInteractEvent.hasItem() && TownySettings.isItemUseId(playerInteractEvent.getItem().getTypeId())) {
            playerInteractEvent.setCancelled(this.onPlayerInteract(player, null, playerInteractEvent.getItem()));
            return;
        }
        if (playerInteractEvent.getClickedBlock() != null) {
            if (TownySettings.getRegenDelay() > 0L && playerInteractEvent.getClickedBlock().getState().getData() instanceof Attachable) {
                Attachable attachable = (Attachable)playerInteractEvent.getClickedBlock().getState().getData();
                BlockLocation blockLocation = new BlockLocation(playerInteractEvent.getClickedBlock().getRelative(attachable.getAttachedFace()).getLocation());
                if (TownyRegenAPI.hasProtectionRegenTask(blockLocation)) {
                    playerInteractEvent.setCancelled(true);
                    return;
                }
            }
            if (TownySettings.isSwitchId(playerInteractEvent.getClickedBlock().getTypeId()) || playerInteractEvent.getAction() == Action.PHYSICAL) {
                this.onPlayerSwitchEvent(playerInteractEvent, null, townyWorld);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        Location location;
        if (this.plugin.isError()) {
            playerMoveEvent.setCancelled(true);
            return;
        }
        if (playerMoveEvent.getFrom().getBlockX() == playerMoveEvent.getTo().getBlockX() && playerMoveEvent.getFrom().getBlockZ() == playerMoveEvent.getTo().getBlockZ() && playerMoveEvent.getFrom().getBlockY() == playerMoveEvent.getTo().getBlockY()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        Location location2 = playerMoveEvent.getTo();
        PlayerCache playerCache = this.plugin.getCache(player);
        try {
            location = playerCache.getLastLocation();
        }
        catch (NullPointerException nullPointerException) {
            location = playerMoveEvent.getFrom();
        }
        if (!(playerMoveEvent instanceof PlayerTeleportEvent) && TownySettings.isUsingCheatProtection() && player.getGameMode() != GameMode.CREATIVE && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.CHEAT_BYPASS.getNode())) {
            try {
                if (TownyUniverse.getDataSource().getWorld(player.getWorld().getName()).isUsingTowny() && location.getBlock().getRelative(BlockFace.DOWN).getType() == Material.AIR && player.getFallDistance() == 0.0f && player.getVelocity().getY() <= -0.6 && player.getLocation().getY() > 0.0) {
                    Location location3 = location;
                    while (location3.getBlock().getType() == Material.AIR && location3.getY() > 0.0) {
                        location3.setY(location3.getY() - 1.0);
                    }
                    location3.setY(location3.getY() + 1.0);
                    playerCache.setLastLocation(location3);
                    player.teleport(location3);
                    return;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
                return;
            }
        }
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(location.getWorld().getName());
            WorldCoord worldCoord = new WorldCoord(townyWorld.getName(), Coord.parseCoord(location));
            TownyWorld townyWorld2 = TownyUniverse.getDataSource().getWorld(location2.getWorld().getName());
            WorldCoord worldCoord2 = new WorldCoord(townyWorld2.getName(), Coord.parseCoord(location2));
            if (!worldCoord.equals(worldCoord2)) {
                this.onPlayerMoveChunk(player, worldCoord, worldCoord2, location, location2);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, notRegisteredException.getMessage());
        }
        playerCache.setLastLocation(location2);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && TownySettings.isItemUseId(Material.ENDER_PEARL.getId()) && this.onPlayerInteract(playerTeleportEvent.getPlayer(), null, new ItemStack(Material.ENDER_PEARL))) {
            playerTeleportEvent.setCancelled(true);
            TownyMessaging.sendErrorMsg((Object)playerTeleportEvent.getPlayer(), "\u00a74Ender Pearls are disabled!");
            return;
        }
        this.onPlayerMove((PlayerMoveEvent)playerTeleportEvent);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent playerChangedWorldEvent) {
        TownyPerms.assignPermissions(null, playerChangedWorldEvent.getPlayer());
    }

    public boolean onPlayerInteract(Player player, Block block, ItemStack itemStack) {
        boolean bl = false;
        try {
            String string = player.getWorld().getName();
            WorldCoord worldCoord = block != null ? new WorldCoord(string, Coord.parseCoord(block)) : new WorldCoord(string, Coord.parseCoord((Entity)player));
            boolean bl2 = block != null ? PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getTypeId(), block.getData(), TownyPermission.ActionType.ITEM_USE) : PlayerCacheUtil.getCachePermission(player, player.getLocation(), itemStack.getTypeId(), itemStack.getData().getData(), TownyPermission.ActionType.ITEM_USE);
            boolean bl3 = TownyUniverse.getPermissionSource().hasWildOverride(worldCoord.getTownyWorld(), player, itemStack.getTypeId(), itemStack.getData().getData(), TownyPermission.ActionType.ITEM_USE);
            PlayerCache playerCache = this.plugin.getCache(player);
            try {
                PlayerCache.TownBlockStatus townBlockStatus = playerCache.getStatus();
                if (townBlockStatus == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE && bl3) {
                    return bl;
                }
                if (townBlockStatus == PlayerCache.TownBlockStatus.TOWN_RESIDENT && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, itemStack.getTypeId(), itemStack.getData().getData(), TownyPermission.ActionType.ITEM_USE) || (townBlockStatus == PlayerCache.TownBlockStatus.OUTSIDER || townBlockStatus == PlayerCache.TownBlockStatus.TOWN_ALLY || townBlockStatus == PlayerCache.TownBlockStatus.ENEMY) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, itemStack.getTypeId(), itemStack.getData().getData(), TownyPermission.ActionType.ITEM_USE)) {
                    return bl;
                }
                if (townBlockStatus == PlayerCache.TownBlockStatus.WARZONE) {
                    if (!TownyWarConfig.isAllowingItemUseInWarZone()) {
                        bl = true;
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_warzone_cannot_use_item"));
                    }
                    return bl;
                }
                if (townBlockStatus == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE && !bl3 || !bl2 && townBlockStatus != PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                    bl = true;
                }
                if (playerCache.hasBlockErrMsg()) {
                    TownyMessaging.sendErrorMsg((Object)player, playerCache.getBlockErrMsg());
                }
            }
            catch (NullPointerException nullPointerException) {
                System.out.print("NPE generated!");
                System.out.print("Player: " + player.getName());
                System.out.print("Item: " + itemStack.getData().getItemType().name());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            bl = true;
            return bl;
        }
        return bl;
    }

    public void onPlayerSwitchEvent(PlayerInteractEvent playerInteractEvent, String string, TownyWorld townyWorld) {
        Player player = playerInteractEvent.getPlayer();
        Block block = playerInteractEvent.getClickedBlock();
        if (!TownySettings.isSwitchId(block.getTypeId())) {
            return;
        }
        boolean bl = PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getTypeId(), block.getData(), TownyPermission.ActionType.SWITCH);
        if (bl) {
            return;
        }
        PlayerCache playerCache = this.plugin.getCache(player);
        PlayerCache.TownBlockStatus townBlockStatus = playerCache.getStatus();
        if (townBlockStatus == PlayerCache.TownBlockStatus.WARZONE) {
            if (!TownyWarConfig.isAllowingSwitchesInWarZone()) {
                playerInteractEvent.setCancelled(true);
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_warzone_cannot_use_switches"));
            }
            return;
        }
        playerInteractEvent.setCancelled(true);
        if (playerCache.hasBlockErrMsg()) {
            TownyMessaging.sendErrorMsg((Object)player, playerCache.getBlockErrMsg());
        }
    }

    public void onPlayerMoveChunk(Player player, WorldCoord worldCoord, WorldCoord worldCoord2, Location location, Location location2) {
        this.plugin.getCache(player).setLastLocation(location2);
        this.plugin.getCache(player).updateCoord(worldCoord2);
        PlayerChangePlotEvent playerChangePlotEvent = new PlayerChangePlotEvent(player, worldCoord, worldCoord2);
        Bukkit.getServer().getPluginManager().callEvent((Event)playerChangePlotEvent);
    }
}

