/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.ResidentModes;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Resident
extends TownBlockOwner
implements ResidentModes {
    private List<Resident> friends = new ArrayList<Resident>();
    private List<Object[][][]> regenUndo = new ArrayList<Object[][][]>();
    private Town town = null;
    private long lastOnline;
    private long registered;
    private boolean isNPC = false;
    private String title;
    private String surname;
    private long teleportRequestTime;
    private Location teleportDestination;
    private double teleportCost;
    private String chatFormattedName;
    private List<String> modes = new ArrayList<String>();
    private List<String> townRanks = new ArrayList<String>();
    private List<String> nationRanks = new ArrayList<String>();

    public Resident(String string) {
        this.setChatFormattedName(string);
        this.setName(string);
        this.setTitle("");
        this.setSurname("");
        this.permissions.loadDefault(this);
        this.teleportRequestTime = -1L;
        this.teleportCost = 0.0;
    }

    public void setLastOnline(long l) {
        this.lastOnline = l;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean bl) {
        this.isNPC = bl;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    public void setTitle(String string) {
        if (string.matches(" ")) {
            string = "";
        }
        this.title = string;
        this.setChangedName(true);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String string) {
        if (string.matches(" ")) {
            string = "";
        }
        this.surname = string;
        this.setChangedName(true);
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public boolean isKing() {
        try {
            return this.getTown().getNation().isKing(this);
        }
        catch (TownyException townyException) {
            return false;
        }
    }

    public boolean isMayor() {
        return this.hasTown() ? this.town.isMayor(this) : false;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() ? this.town.hasNation() : false;
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException("Resident doesn't belong to any town");
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        if (town == null) {
            this.town = null;
            this.setTitle("");
            this.setSurname("");
            this.updatePerms();
            return;
        }
        if (this.town == town) {
            return;
        }
        if (this.hasTown()) {
            throw new AlreadyRegisteredException();
        }
        this.town = town;
        this.setTitle("");
        this.setSurname("");
        this.updatePerms();
    }

    public void setFriends(List<Resident> list) {
        this.friends = list;
    }

    public List<Resident> getFriends() {
        return this.friends;
    }

    public boolean removeFriend(Resident resident) throws NotRegisteredException {
        if (this.hasFriend(resident)) {
            return this.friends.remove(resident);
        }
        throw new NotRegisteredException();
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) throws AlreadyRegisteredException {
        if (this.hasFriend(resident)) {
            throw new AlreadyRegisteredException();
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        for (Resident resident : new ArrayList<Resident>(this.friends)) {
            try {
                this.removeFriend(resident);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
    }

    public void clear() throws EmptyTownException {
        this.removeAllFriends();
        if (this.hasTown()) {
            try {
                this.town.removeResident(this);
                this.setTitle("");
                this.setSurname("");
                this.updatePerms();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    private void updatePerms() {
        this.townRanks.clear();
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void setRegistered(long l) {
        this.registered = l;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getTreeDepth(n) + "Resident (" + this.getName() + ")");
        arrayList.add(this.getTreeDepth(n + 1) + "Registered: " + this.getRegistered());
        arrayList.add(this.getTreeDepth(n + 1) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            arrayList.add(this.getTreeDepth(n + 1) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return arrayList;
    }

    public void clearTeleportRequest() {
        this.teleportRequestTime = -1L;
    }

    public void setTeleportRequestTime() {
        this.teleportRequestTime = System.currentTimeMillis();
    }

    public long getTeleportRequestTime() {
        return this.teleportRequestTime;
    }

    public void setTeleportDestination(Location location) {
        this.teleportDestination = location;
    }

    public Location getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean hasRequestedTeleport() {
        return this.teleportRequestTime != -1L;
    }

    public void setTeleportCost(double d) {
        this.teleportCost = d;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    public String getChatFormattedName() {
        return this.chatFormattedName;
    }

    public void setChatFormattedName(String string) {
        this.chatFormattedName = string;
        this.setChangedName(false);
    }

    public void addUndo(Object[][][] objectArray) {
        if (this.regenUndo.size() == 5) {
            this.regenUndo.remove(0);
        }
        this.regenUndo.add(objectArray);
    }

    public void regenUndo() {
        if (this.regenUndo.size() > 0) {
            Object[][][] objectArray = this.regenUndo.get(this.regenUndo.size() - 1);
            this.regenUndo.remove(objectArray);
            TownyRegenAPI.regenUndo(objectArray, this);
        }
    }

    @Override
    public List<String> getModes() {
        return this.modes;
    }

    @Override
    public boolean hasMode(String string) {
        return this.modes.contains(string.toLowerCase());
    }

    @Override
    public void toggleMode(String[] stringArray, boolean bl) {
        if (stringArray.length == 0) {
            this.clearModes();
            return;
        }
        for (String string : stringArray) {
            if (this.modes.contains(string = string.toLowerCase())) {
                this.modes.remove(string);
                continue;
            }
            this.modes.add(string);
        }
        if (bl) {
            TownyMessaging.sendMsg(this, "Modes set: " + StringMgmt.join(this.getModes(), ","));
        }
    }

    @Override
    public void setModes(String[] stringArray, boolean bl) {
        if (stringArray.length == 0) {
            this.clearModes();
            return;
        }
        this.modes.clear();
        this.toggleMode(stringArray, false);
        if (bl) {
            TownyMessaging.sendMsg(this, "Modes set: " + StringMgmt.join(this.getModes(), ","));
        }
    }

    @Override
    public void clearModes() {
        this.modes.clear();
        if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.getName(), true), 1L) == -1) {
            TownyMessaging.sendErrorMsg("Could not set default modes for " + this.getName() + ".");
        }
    }

    public boolean addTownRank(String string) throws AlreadyRegisteredException {
        if (this.hasTown() && TownyPerms.getTownRanks().contains(string)) {
            if (this.townRanks.contains(string)) {
                throw new AlreadyRegisteredException();
            }
            this.townRanks.add(string);
            TownyPerms.assignPermissions(this, null);
            return true;
        }
        return false;
    }

    public void setTownRanks(List<String> list) {
        this.townRanks.addAll(list);
    }

    public boolean hasTownRank(String string) {
        return this.townRanks.contains(string.toLowerCase());
    }

    public List<String> getTownRanks() {
        return this.townRanks;
    }

    public boolean removeTownRank(String string) throws NotRegisteredException {
        if (this.townRanks.contains(string)) {
            this.townRanks.remove(string);
            TownyPerms.assignPermissions(this, null);
            return true;
        }
        throw new NotRegisteredException();
    }

    public boolean addNationRank(String string) throws AlreadyRegisteredException {
        if (this.hasNation() && TownyPerms.getNationRanks().contains(string)) {
            if (this.nationRanks.contains(string)) {
                throw new AlreadyRegisteredException();
            }
            this.nationRanks.add(string);
            TownyPerms.assignPermissions(this, null);
            return true;
        }
        return false;
    }

    public void setNationRanks(List<String> list) {
        this.nationRanks.addAll(list);
    }

    public boolean hasNationRank(String string) {
        return this.nationRanks.contains(string.toLowerCase());
    }

    public List<String> getNationRanks() {
        return this.nationRanks;
    }

    public boolean removeNationRank(String string) throws NotRegisteredException {
        if (this.nationRanks.contains(string)) {
            this.nationRanks.remove(string);
            TownyPerms.assignPermissions(this, null);
            return true;
        }
        throw new NotRegisteredException();
    }

    @Override
    protected World getBukkitWorld() {
        Player player = BukkitTools.getPlayer(this.getName());
        if (player != null) {
            return player.getWorld();
        }
        return super.getBukkitWorld();
    }
}

