/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;

public class TownBlock {
    private TownyWorld world;
    private Town town;
    private Resident resident;
    private TownBlockType type;
    private int x;
    private int z;
    private double plotPrice = -1.0;
    private boolean locked = false;
    private boolean outpost = false;
    protected TownyPermission permissions = new TownyPermission();
    protected boolean isChanged;

    public TownBlock(int n, int n2, TownyWorld townyWorld) {
        this.x = n;
        this.z = n2;
        this.setWorld(townyWorld);
        this.type = TownBlockType.RESIDENTIAL;
        this.isChanged = false;
    }

    public void setTown(Town town) {
        try {
            if (this.hasTown()) {
                this.town.removeTownBlock(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.town = town;
        try {
            town.addTownBlock(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Town getTown() throws NotRegisteredException {
        if (!this.hasTown()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", this.world.getName(), this.x, this.z));
        }
        return this.town;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public void setResident(Resident resident) {
        try {
            if (this.hasResident()) {
                this.resident.removeTownBlock(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.resident = resident;
        try {
            resident.addTownBlock(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Resident getResident() throws NotRegisteredException {
        if (!this.hasResident()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a resident.", this.world.getName(), this.x, this.z));
        }
        return this.resident;
    }

    public boolean hasResident() {
        return this.resident != null;
    }

    public boolean isOwner(TownBlockOwner townBlockOwner) {
        try {
            if (townBlockOwner == this.getTown()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            if (townBlockOwner == this.getResident()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public void setPlotPrice(double d) {
        this.plotPrice = d;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public boolean isForSale() {
        return this.getPlotPrice() != -1.0;
    }

    public void setPermissions(String string) {
        this.permissions.load(string);
    }

    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean bl) {
        this.isChanged = bl;
    }

    public boolean isOutpost() {
        return this.outpost;
    }

    public void setOutpost(boolean bl) {
        this.outpost = bl;
    }

    public TownBlockType getType() {
        return this.type;
    }

    public void setType(TownBlockType townBlockType) {
        if (townBlockType != this.type) {
            this.permissions.reset();
        }
        this.type = townBlockType;
        switch (townBlockType) {
            case RESIDENTIAL: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case COMMERCIAL: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case ARENA: {
                this.setPermissions("pvp");
                break;
            }
            case EMBASSY: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.permissions.toString());
                    break;
                }
                this.setPermissions(this.town.permissions.toString());
                break;
            }
            case WILDS: {
                this.setPermissions("denyAll");
                break;
            }
            case SPLEEF: {
                this.setPermissions("denyAll");
            }
        }
        this.setChanged(false);
    }

    public void setType(int n) {
        this.setType(TownBlockType.lookup(n));
    }

    public void setType(String string) throws TownyException {
        TownBlockType townBlockType;
        if (string.equalsIgnoreCase("reset")) {
            string = "default";
        }
        if ((townBlockType = TownBlockType.lookup(string)) == null) {
            throw new TownyException(TownySettings.getLangString("msg_err_not_block_type"));
        }
        this.setType(townBlockType);
    }

    public boolean isHomeBlock() {
        try {
            return this.getTown().isHomeBlock(this);
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getX() {
        return this.x;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public int getZ() {
        return this.z;
    }

    public Coord getCoord() {
        return new Coord(this.x, this.z);
    }

    public WorldCoord getWorldCoord() {
        return new WorldCoord(this.world.getName(), this.x, this.z);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public void setWorld(TownyWorld townyWorld) {
        this.world = townyWorld;
    }

    public TownyWorld getWorld() {
        return this.world;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TownBlock)) {
            return false;
        }
        TownBlock townBlock = (TownBlock)object;
        return this.getX() == townBlock.getX() && this.getZ() == townBlock.getZ() && this.getWorld() == townBlock.getWorld();
    }

    public void clear() {
        this.setTown(null);
        this.setResident(null);
        this.setWorld(null);
    }

    public String toString() {
        return this.getWorld().getName() + " (" + this.getCoord() + ")";
    }

    public boolean isWarZone() {
        return this.getWorld().isWarZone(this.getCoord());
    }
}

