/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.World;

public class TownyEconomyObject
extends TownyObject {
    public boolean pay(double d, String string) throws EconomyException {
        boolean bl = this._pay(d);
        if (bl) {
            TownyLogger.logMoneyTransaction(this, d, null, string);
        }
        return bl;
    }

    public boolean pay(double d) throws EconomyException {
        return this.pay(d, null);
    }

    private boolean _pay(double d) throws EconomyException {
        if (this.canPayFromHoldings(d) && TownyEconomyHandler.isActive()) {
            return TownyEconomyHandler.subtract(this.getEconomyName(), d, this.getBukkitWorld());
        }
        return false;
    }

    public void collect(double d, String string) throws EconomyException {
        TownyEconomyHandler.add(this.getEconomyName(), d, this.getBukkitWorld());
        TownyLogger.logMoneyTransaction(null, d, this, string);
    }

    public void collect(double d) throws EconomyException {
        this.collect(d, null);
    }

    public boolean payTo(double d, TownyEconomyObject townyEconomyObject, String string) throws EconomyException {
        boolean bl = this._payTo(d, townyEconomyObject);
        if (bl) {
            TownyLogger.logMoneyTransaction(this, d, townyEconomyObject, string);
        }
        return bl;
    }

    public boolean payTo(double d, TownyEconomyObject townyEconomyObject) throws EconomyException {
        return this.payTo(d, townyEconomyObject, null);
    }

    private boolean _payTo(double d, TownyEconomyObject townyEconomyObject) throws EconomyException {
        if (this._pay(d)) {
            townyEconomyObject.collect(d);
            return true;
        }
        return false;
    }

    public String getEconomyName() {
        return this.getName();
    }

    protected World getBukkitWorld() {
        return BukkitTools.getWorlds().get(0);
    }

    public void setBalance(double d, String string) {
        this.setBalance(d);
        TownyLogger.logMoneyTransaction(null, d, this, string);
    }

    public void setBalance(double d) {
        TownyEconomyHandler.setBalance(this.getEconomyName(), d, this.getBukkitWorld());
    }

    public double getHoldingBalance() throws EconomyException {
        try {
            return TownyEconomyHandler.getBalance(this.getEconomyName(), this.getBukkitWorld());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace();
            throw new EconomyException("Economy error getting holdings for " + this.getEconomyName());
        }
    }

    public boolean canPayFromHoldings(double d) throws EconomyException {
        return TownyEconomyHandler.hasEnough(this.getEconomyName(), d, this.getBukkitWorld());
    }

    public String getHoldingFormattedBalance() {
        try {
            return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
        }
        catch (EconomyException economyException) {
            return "Error Accessing Bank Account";
        }
    }

    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getEconomyName());
    }
}

