/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.db.TownyHModFlatFileSource;
import com.palmergames.bukkit.towny.db.TownySQLSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyUniverse
extends TownyObject {
    private static Towny plugin;
    protected Hashtable<String, Resident> residents = new Hashtable();
    protected Hashtable<String, Town> towns = new Hashtable();
    protected Hashtable<String, Nation> nations = new Hashtable();
    protected Hashtable<String, TownyWorld> worlds = new Hashtable();
    private static TownyDataSource dataSource;
    private static TownyPermissionSource permissionSource;
    private static War warEvent;
    private String rootFolder;

    public TownyUniverse(Towny towny) {
        this.setName("");
        plugin = towny;
    }

    public void onLogin(Player player) throws AlreadyRegisteredException, NotRegisteredException {
        if (!player.isOnline()) {
            return;
        }
        if (player.getName().trim() == null || player.getName().contains(" ")) {
            player.kickPlayer("Invalid name!");
            return;
        }
        if (BukkitTools.scheduleSyncDelayedTask(new OnPlayerLogin(plugin, player), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule OnLogin.");
        }
    }

    public void onLogout(Player player) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.setLastOnline(System.currentTimeMillis());
            TownyUniverse.getDataSource().saveResident(resident);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.setChangedNotify(TownyObservableType.PLAYER_LOGOUT);
    }

    public Location getTownSpawnLocation(Player player) throws TownyException {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            return town.getSpawn();
        }
        catch (TownyException townyException) {
            throw new TownyException("Unable to get spawn location");
        }
    }

    public static Player getPlayer(Resident resident) throws TownyException {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !player.getName().equals(resident.getName())) continue;
            return player;
        }
        throw new TownyException(String.format("%s is not online", resident.getName()));
    }

    public static List<Player> getOnlinePlayers(ResidentList residentList) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !residentList.hasResident(player.getName())) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public static List<Player> getOnlinePlayers(Town town) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !town.hasResident(player.getName())) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public static List<Player> getOnlinePlayers(Nation nation) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Town town : nation.getTowns()) {
            arrayList.addAll(TownyUniverse.getOnlinePlayers(town));
        }
        return arrayList;
    }

    public static boolean isWilderness(Block block) {
        WorldCoord worldCoord;
        try {
            worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(block.getWorld().getName()).getName(), Coord.parseCoord(block));
        }
        catch (NotRegisteredException notRegisteredException) {
            return true;
        }
        try {
            return worldCoord.getTownBlock().getTown() == null;
        }
        catch (NotRegisteredException notRegisteredException) {
            return true;
        }
    }

    public static String getTownName(Location location) {
        try {
            WorldCoord worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(location.getWorld().getName()).getName(), Coord.parseCoord(location));
            return worldCoord.getTownBlock().getTown().getName();
        }
        catch (NotRegisteredException notRegisteredException) {
            return null;
        }
    }

    public static TownBlock getTownBlock(Location location) {
        TownyMessaging.sendDebugMsg("Fetching TownBlock");
        try {
            WorldCoord worldCoord = new WorldCoord(TownyUniverse.getDataSource().getWorld(location.getWorld().getName()).getName(), Coord.parseCoord(location));
            return worldCoord.getTownBlock();
        }
        catch (NotRegisteredException notRegisteredException) {
            return null;
        }
    }

    public List<Resident> getActiveResidents() {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Resident resident : TownyUniverse.getDataSource().getResidents()) {
            if (!this.isActiveResident(resident)) continue;
            arrayList.add(resident);
        }
        return arrayList;
    }

    public boolean isActiveResident(Resident resident) {
        return System.currentTimeMillis() - resident.getLastOnline() < 20L * TownySettings.getInactiveAfter() || BukkitTools.isOnline(resident.getName());
    }

    public boolean loadSettings() {
        try {
            FileMgmt.checkFolders(new String[]{this.getRootFolder(), this.getRootFolder() + FileMgmt.fileSeparator() + "settings", this.getRootFolder() + FileMgmt.fileSeparator() + "logs"});
            TownySettings.loadConfig(this.getRootFolder() + FileMgmt.fileSeparator() + "settings" + FileMgmt.fileSeparator() + "config.yml", plugin.getVersion());
            TownySettings.loadLanguage(this.getRootFolder() + FileMgmt.fileSeparator() + "settings", "english.yml");
            TownyPerms.loadPerms(this.getRootFolder() + FileMgmt.fileSeparator() + "settings", "townyperms.yml");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        String string = TownySettings.getSaveDatabase();
        String string2 = TownySettings.getLoadDatabase();
        Coord.setCellSize(TownySettings.getTownBlockSize());
        System.out.println("[Towny] Database: [Load] " + string2 + " [Save] " + string);
        this.worlds.clear();
        this.nations.clear();
        this.towns.clear();
        this.residents.clear();
        if (!this.loadDatabase(string2)) {
            System.out.println("[Towny] Error: Failed to load!");
            return false;
        }
        try {
            TownyUniverse.getDataSource().cleanupBackups();
            this.setDataSource(string);
            TownyUniverse.getDataSource().initialize(plugin, this);
            try {
                TownyUniverse.getDataSource().backup();
                TownyUniverse.getDataSource().deleteUnusedResidentFiles();
            }
            catch (IOException iOException) {
                System.out.println("[Towny] Error: Could not create backup.");
                iOException.printStackTrace();
                return false;
            }
            if (string2.equalsIgnoreCase(string)) {
                TownyUniverse.getDataSource().saveAllWorlds();
            } else {
                TownyUniverse.getDataSource().saveAll();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            System.out.println("[Towny] Error: Unsupported save format!");
            return false;
        }
        return true;
    }

    public boolean loadDatabase(String string) {
        try {
            this.setDataSource(string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        TownyUniverse.getDataSource().initialize(plugin, this);
        return TownyUniverse.getDataSource().loadAll();
    }

    public String getRootFolder() {
        if (plugin != null) {
            return plugin.getDataFolder().getPath();
        }
        return this.rootFolder;
    }

    public void setDataSource(String string) throws UnsupportedOperationException {
        if (string.equalsIgnoreCase("flatfile")) {
            this.setDataSource(new TownyFlatFileSource());
        } else if (string.equalsIgnoreCase("flatfile-hmod")) {
            this.setDataSource(new TownyHModFlatFileSource());
        } else if (string.equalsIgnoreCase("mysql") || string.equalsIgnoreCase("sqlite") || string.equalsIgnoreCase("h2")) {
            this.setDataSource(new TownySQLSource(string));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setDataSource(TownyDataSource townyDataSource) {
        dataSource = townyDataSource;
    }

    public static TownyDataSource getDataSource() {
        return dataSource;
    }

    public void setPermissionSource(TownyPermissionSource townyPermissionSource) {
        permissionSource = townyPermissionSource;
    }

    public static TownyPermissionSource getPermissionSource() {
        return permissionSource;
    }

    public Hashtable<String, Resident> getResidentMap() {
        return this.residents;
    }

    public Hashtable<String, Town> getTownsMap() {
        return this.towns;
    }

    public Hashtable<String, Nation> getNationsMap() {
        return this.nations;
    }

    public Hashtable<String, TownyWorld> getWorldMap() {
        return this.worlds;
    }

    public static boolean isWarTime() {
        return warEvent != null ? warEvent.isWarTime() : false;
    }

    public void startWarEvent() {
        warEvent = new War(plugin, TownySettings.getWarTimeWarningDelay());
        this.setChangedNotify(TownyObservableType.WAR_START);
    }

    public void endWarEvent() {
        if (TownyUniverse.isWarTime()) {
            warEvent.toggleEnd();
        }
        this.setChangedNotify(TownyObservableType.WAR_END);
    }

    public void clearWarEvent() {
        this.getWarEvent().cancelTasks(BukkitTools.getScheduler());
        this.setWarEvent(null);
        this.setChangedNotify(TownyObservableType.WAR_CLEARED);
    }

    public War getWarEvent() {
        return warEvent;
    }

    public void setWarEvent(War war) {
        warEvent = war;
        this.setChangedNotify(TownyObservableType.WAR_SET);
    }

    public void sendUniverseTree(CommandSender commandSender) {
        for (String string : this.getTreeString(0)) {
            commandSender.sendMessage(string);
        }
    }

    @Override
    public List<String> getTreeString(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getTreeDepth(n) + "Universe (" + this.getName() + ")");
        if (plugin != null) {
            arrayList.add(this.getTreeDepth(n + 1) + "Server (" + BukkitTools.getServer().getName() + ")");
            arrayList.add(this.getTreeDepth(n + 2) + "Version: " + BukkitTools.getServer().getVersion());
            arrayList.add(this.getTreeDepth(n + 2) + "Players: " + BukkitTools.getOnlinePlayers().length + "/" + BukkitTools.getServer().getMaxPlayers());
            arrayList.add(this.getTreeDepth(n + 2) + "Worlds (" + BukkitTools.getWorlds().size() + "): " + Arrays.toString(BukkitTools.getWorlds().toArray(new World[0])));
        }
        arrayList.add(this.getTreeDepth(n + 1) + "Worlds (" + TownyUniverse.getDataSource().getWorlds().size() + "):");
        for (TownyWorld list2 : TownyUniverse.getDataSource().getWorlds()) {
            arrayList.addAll(list2.getTreeString(n + 2));
        }
        arrayList.add(this.getTreeDepth(n + 1) + "Nations (" + TownyUniverse.getDataSource().getNations().size() + "):");
        for (Nation nation : TownyUniverse.getDataSource().getNations()) {
            arrayList.addAll(nation.getTreeString(n + 2));
        }
        List<Town> list3 = TownyUniverse.getDataSource().getTownsWithoutNation();
        arrayList.add(this.getTreeDepth(n + 1) + "Towns (" + list3.size() + "):");
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            Town town = (Town)iterator.next();
            arrayList.addAll(town.getTreeString(n + 2));
        }
        List<Resident> list = TownyUniverse.getDataSource().getResidentsWithoutTown();
        arrayList.add(this.getTreeDepth(n + 1) + "Residents (" + list.size() + "):");
        for (Resident resident : list) {
            arrayList.addAll(resident.getTreeString(n + 2));
        }
        return arrayList;
    }

    public static List<Resident> getValidatedResidents(Object object, String[] stringArray) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (String string : stringArray) {
            Object object2;
            List<Player> list = BukkitTools.matchPlayer(string);
            if (list.size() > 1) {
                object2 = "Multiple players selected";
                for (Player player : list) {
                    object2 = (String)object2 + ", " + player.getName();
                }
                TownyMessaging.sendErrorMsg(object, (String)object2);
                continue;
            }
            if (list.size() == 1) {
                try {
                    object2 = TownyUniverse.getDataSource().getResident(list.get(0).getName());
                    arrayList.add((Resident)object2);
                }
                catch (TownyException townyException) {
                    TownyMessaging.sendErrorMsg(object, townyException.getMessage());
                }
                continue;
            }
            try {
                object2 = TownyUniverse.getDataSource().getResident(string);
                arrayList.add((Resident)object2);
            }
            catch (NotRegisteredException notRegisteredException) {
                TownyMessaging.sendErrorMsg(object, notRegisteredException.getMessage());
            }
        }
        return arrayList;
    }

    public static List<Resident> getOnlineResidents(Player player, String[] stringArray) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (String string : stringArray) {
            Object object;
            List<Player> list = BukkitTools.matchPlayer(string);
            if (list.size() > 1) {
                object = "Multiple players selected";
                for (Player player2 : list) {
                    object = (String)object + ", " + player2.getName();
                }
                TownyMessaging.sendErrorMsg((Object)player, (String)object);
                continue;
            }
            if (list.size() != 1) continue;
            try {
                object = TownyUniverse.getDataSource().getResident(list.get(0).getName());
                arrayList.add((Resident)object);
            }
            catch (TownyException townyException) {
                TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
            }
        }
        return arrayList;
    }

    public static List<Resident> getOnlineResidents(ResidentList residentList) {
        ArrayList<Resident> arrayList = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : residentList.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName())) continue;
                arrayList.add(resident);
            }
        }
        return arrayList;
    }

    public void requestTeleport(Player player, Location location, double d) {
        try {
            TeleportWarmupTimerTask.requestTeleport(TownyUniverse.getDataSource().getResident(player.getName().toLowerCase()), location, d);
        }
        catch (TownyException townyException) {
            TownyMessaging.sendErrorMsg((Object)player, townyException.getMessage());
        }
        this.setChangedNotify(TownyObservableType.TELEPORT_REQUEST);
    }

    public void abortTeleportRequest(Resident resident) {
        TeleportWarmupTimerTask.abortTeleportRequest(resident);
    }

    public void addWarZone(WorldCoord worldCoord) {
        try {
            worldCoord.getTownyWorld().addWarZone(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        plugin.updateCache(worldCoord);
    }

    public void removeWarZone(WorldCoord worldCoord) {
        try {
            worldCoord.getTownyWorld().removeWarZone(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        plugin.updateCache(worldCoord);
    }

    public void setChangedNotify(TownyObservableType townyObservableType) {
        this.setChanged();
        this.notifyObservers((Object)townyObservableType);
    }

    @Deprecated
    public boolean areAllAllies(List<Nation> list) {
        if (list.size() <= 1) {
            return true;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            if (list.get(i).hasAlly(list.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        try {
            return CombatUtil.isEnemy(TownyUniverse.getDataSource().getResident(player.getName()).getTown(), worldCoord.getTownBlock().getTown());
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
    }

    @Deprecated
    public boolean isAlly(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            Resident resident2 = TownyUniverse.getDataSource().getResident(string2);
            if (resident.getTown() == resident2.getTown()) {
                return true;
            }
            if (resident.getTown().getNation() == resident2.getTown().getNation()) {
                return true;
            }
            if (resident.getTown().getNation().hasAlly(resident2.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isAlly(Town town, Town town2) {
        try {
            if (town == town2) {
                return true;
            }
            if (town.getNation() == town2.getNation()) {
                return true;
            }
            if (town.getNation().hasAlly(town2.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean canAttackEnemy(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            Resident resident2 = TownyUniverse.getDataSource().getResident(string2);
            if (resident.getTown() == resident2.getTown()) {
                return false;
            }
            if (resident.getTown().getNation() == resident2.getTown().getNation()) {
                return false;
            }
            Nation nation = resident.getTown().getNation();
            Nation nation2 = resident2.getTown().getNation();
            if (nation.isNeutral() || nation2.isNeutral()) {
                return false;
            }
            if (nation.hasEnemy(nation2)) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isEnemy(String string, String string2) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(string);
            Resident resident2 = TownyUniverse.getDataSource().getResident(string2);
            if (resident.getTown() == resident2.getTown()) {
                return false;
            }
            if (resident.getTown().getNation() == resident2.getTown().getNation()) {
                return false;
            }
            if (resident.getTown().getNation().hasEnemy(resident2.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    @Deprecated
    public boolean isEnemy(Town town, Town town2) {
        try {
            if (town == town2) {
                return false;
            }
            if (town.getNation() == town2.getNation()) {
                return false;
            }
            if (town.getNation().hasEnemy(town2.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
        return false;
    }

    @Deprecated
    public void newResident(String string) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newResident(string);
    }

    @Deprecated
    public void newTown(String string) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newTown(string);
    }

    @Deprecated
    public static TownyWorld getTownWorld(String string) {
        return TownyUniverse.getDataSource().getTownWorld(string);
    }

    @Deprecated
    public void newNation(String string) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newNation(string);
    }

    @Deprecated
    public void newWorld(String string) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newWorld(string);
    }

    @Deprecated
    public boolean hasResident(String string) {
        return TownyUniverse.getDataSource().hasResident(string);
    }

    @Deprecated
    public boolean hasTown(String string) {
        return TownyUniverse.getDataSource().hasTown(string);
    }

    @Deprecated
    public boolean hasNation(String string) {
        return TownyUniverse.getDataSource().hasNation(string);
    }

    @Deprecated
    public void renameTown(Town town, String string) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().renameTown(town, string);
    }

    @Deprecated
    public void renameNation(Nation nation, String string) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().renameNation(nation, string);
    }

    @Deprecated
    public Resident getResident(String string) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getResident(string);
    }

    @Deprecated
    public List<Resident> getResidents() {
        return TownyUniverse.getDataSource().getResidents();
    }

    @Deprecated
    public Set<String> getResidentKeys() {
        return TownyUniverse.getDataSource().getResidentKeys();
    }

    @Deprecated
    public Set<String> getTownsKeys() {
        return TownyUniverse.getDataSource().getTownsKeys();
    }

    @Deprecated
    public Set<String> getNationsKeys() {
        return TownyUniverse.getDataSource().getNationsKeys();
    }

    @Deprecated
    public List<Town> getTowns() {
        return TownyUniverse.getDataSource().getTowns();
    }

    @Deprecated
    public List<Nation> getNations() {
        return TownyUniverse.getDataSource().getNations();
    }

    @Deprecated
    public List<TownyWorld> getWorlds() {
        return TownyUniverse.getDataSource().getWorlds();
    }

    @Deprecated
    public List<Town> getTownsWithoutNation() {
        return TownyUniverse.getDataSource().getTownsWithoutNation();
    }

    @Deprecated
    public List<Resident> getResidentsWithoutTown() {
        return TownyUniverse.getDataSource().getResidentsWithoutTown();
    }

    @Deprecated
    public List<Resident> getResidents(String[] stringArray) {
        return TownyUniverse.getDataSource().getResidents(stringArray);
    }

    @Deprecated
    public List<Town> getTowns(String[] stringArray) {
        return TownyUniverse.getDataSource().getTowns(stringArray);
    }

    @Deprecated
    public List<Nation> getNations(String[] stringArray) {
        return TownyUniverse.getDataSource().getNations(stringArray);
    }

    @Deprecated
    public Town getTown(String string) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getTown(string);
    }

    @Deprecated
    public Nation getNation(String string) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getNation(string);
    }

    @Deprecated
    public static TownyWorld getWorld(String string) throws NotRegisteredException {
        return TownyUniverse.getDataSource().getWorld(string);
    }

    @Deprecated
    public void removeWorld(TownyWorld townyWorld) throws UnsupportedOperationException {
        TownyUniverse.getDataSource().removeWorld(townyWorld);
    }

    @Deprecated
    public void removeNation(Nation nation) {
        TownyUniverse.getDataSource().removeNation(nation);
    }

    @Deprecated
    public void removeTown(Town town) {
        TownyUniverse.getDataSource().removeTown(town);
    }

    @Deprecated
    public void removeResident(Resident resident) {
        TownyUniverse.getDataSource().removeResident(resident);
    }

    @Deprecated
    public void removeResidentList(Resident resident) {
        TownyUniverse.getDataSource().removeResidentList(resident);
    }

    @Deprecated
    public void removeTownBlock(TownBlock townBlock) {
        TownyUniverse.getDataSource().removeTownBlock(townBlock);
    }

    @Deprecated
    public void removeTownBlocks(Town town) {
        TownyUniverse.getDataSource().removeTownBlocks(town);
    }

    @Deprecated
    public List<TownBlock> getAllTownBlocks() {
        return TownyUniverse.getDataSource().getAllTownBlocks();
    }

    @Deprecated
    public List<Resident> getResidents(Player player, String[] stringArray) {
        return TownyUniverse.getDataSource().getResidents(player, stringArray);
    }

    @Deprecated
    public void deleteTownBlockIds(TownBlock townBlock) {
        WorldCoord worldCoord = townBlock.getWorldCoord();
        TownyRegenAPI.addDeleteTownBlockIdQueue(worldCoord);
    }

    @Deprecated
    public String checkAndFilterName(String string) throws InvalidNameException {
        return NameValidation.checkAndFilterPlayerName(string);
    }

    @Deprecated
    public String[] checkAndFilterArray(String[] stringArray) {
        return NameValidation.checkAndFilterArray(stringArray);
    }
}

