/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.bukkit.entity.Entity;

public class TownyWorld
extends TownyObject {
    private List<Town> towns = new ArrayList<Town>();
    private boolean isClaimable = true;
    private boolean isPVP;
    private boolean isForcePVP;
    private boolean isExplosion;
    private boolean isForceExpl;
    private boolean isFire;
    private boolean isForceFire;
    private boolean isForceTownMobs;
    private boolean hasWorldMobs;
    private boolean isDisableCreatureTrample;
    private boolean isDisablePlayerTrample;
    private boolean isEndermanProtect;
    private boolean isUsingTowny = true;
    private boolean isUsingPlotManagementDelete = true;
    private boolean isUsingPlotManagementMayorDelete = true;
    private boolean isUsingPlotManagementRevert = true;
    private boolean isUsingPlotManagementWildRevert = true;
    private Long plotManagementRevertSpeed;
    private Long plotManagementWildRevertDelay;
    private List<Integer> unclaimedZoneIgnoreIds = null;
    private List<Integer> plotManagementDeleteIds = null;
    private List<String> plotManagementMayorDelete = null;
    private List<Integer> plotManagementIgnoreIds = null;
    private Boolean unclaimedZoneBuild = null;
    private Boolean unclaimedZoneDestroy = null;
    private Boolean unclaimedZoneSwitch = null;
    private Boolean unclaimedZoneItemUse = null;
    private String unclaimedZoneName = null;
    private Hashtable<Coord, TownBlock> townBlocks = new Hashtable();
    private List<Coord> warZones = new ArrayList<Coord>();
    private List<Class<?>> entityExplosionProtection = null;

    public TownyWorld(String string) {
        this.setName(string);
        this.isPVP = TownySettings.isPvP();
        this.isForcePVP = TownySettings.isForcingPvP();
        this.isFire = TownySettings.isFire();
        this.isForceFire = TownySettings.isForcingFire();
        this.hasWorldMobs = TownySettings.isWorldMonstersOn();
        this.isForceTownMobs = TownySettings.isForcingMonsters();
        this.isExplosion = TownySettings.isExplosions();
        this.isForceExpl = TownySettings.isForcingExplosions();
        this.isEndermanProtect = TownySettings.getEndermanProtect();
        this.isDisablePlayerTrample = TownySettings.isPlayerTramplingCropsDisabled();
        this.isDisableCreatureTrample = TownySettings.isCreatureTramplingCropsDisabled();
        this.setUsingPlotManagementDelete(TownySettings.isUsingPlotManagementDelete());
        this.setUsingPlotManagementRevert(TownySettings.isUsingPlotManagementRevert());
        this.setPlotManagementRevertSpeed(TownySettings.getPlotManagementSpeed());
        this.setUsingPlotManagementWildRevert(TownySettings.isUsingPlotManagementWildRegen());
        this.setPlotManagementWildRevertDelay(TownySettings.getPlotManagementWildRegenDelay());
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public boolean hasTowns() {
        return !this.towns.isEmpty();
    }

    public boolean hasTown(String string) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTown(Town town) {
        return this.towns.contains(town);
    }

    public void addTown(Town town) throws AlreadyRegisteredException {
        if (this.hasTown(town)) {
            throw new AlreadyRegisteredException();
        }
        this.towns.add(town);
        town.setWorld(this);
    }

    public TownBlock getTownBlock(Coord coord) throws NotRegisteredException {
        TownBlock townBlock = this.townBlocks.get(coord);
        if (townBlock == null) {
            throw new NotRegisteredException();
        }
        return townBlock;
    }

    public void newTownBlock(int n, int n2) throws AlreadyRegisteredException {
        this.newTownBlock(new Coord(n, n2));
    }

    public TownBlock newTownBlock(Coord coord) throws AlreadyRegisteredException {
        if (this.hasTownBlock(coord)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.put(new Coord(coord.getX(), coord.getZ()), new TownBlock(coord.getX(), coord.getZ(), this));
        return this.townBlocks.get(new Coord(coord.getX(), coord.getZ()));
    }

    public boolean hasTownBlock(Coord coord) {
        return this.townBlocks.containsKey(coord);
    }

    public TownBlock getTownBlock(int n, int n2) throws NotRegisteredException {
        return this.getTownBlock(new Coord(n, n2));
    }

    public List<TownBlock> getTownBlocks(Town town) {
        ArrayList<TownBlock> arrayList = new ArrayList<TownBlock>();
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.getWorld() != this) continue;
            arrayList.add(townBlock);
        }
        return arrayList;
    }

    public Collection<TownBlock> getTownBlocks() {
        return this.townBlocks.values();
    }

    public void removeTown(Town town) throws NotRegisteredException {
        if (!this.hasTown(town)) {
            throw new NotRegisteredException();
        }
        this.towns.remove(town);
    }

    public void removeTownBlock(TownBlock townBlock) {
        try {
            if (townBlock.hasResident()) {
                townBlock.getResident().removeTownBlock(townBlock);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            if (townBlock.hasTown()) {
                townBlock.getTown().removeTownBlock(townBlock);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.removeTownBlock(townBlock.getCoord());
    }

    public void removeTownBlocks(List<TownBlock> list) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(list)) {
            this.removeTownBlock(townBlock);
        }
    }

    public void removeTownBlock(Coord coord) {
        this.townBlocks.remove(coord);
    }

    @Override
    public List<String> getTreeString(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getTreeDepth(n) + "World (" + this.getName() + ")");
        arrayList.add(this.getTreeDepth(n + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        return arrayList;
    }

    public void setPVP(boolean bl) {
        this.isPVP = bl;
    }

    public boolean isPVP() {
        return this.isPVP;
    }

    public void setForcePVP(boolean bl) {
        this.isForcePVP = bl;
    }

    public boolean isForcePVP() {
        return this.isForcePVP;
    }

    public void setExpl(boolean bl) {
        this.isExplosion = bl;
    }

    public boolean isExpl() {
        return this.isExplosion;
    }

    public void setForceExpl(boolean bl) {
        this.isForceExpl = bl;
    }

    public boolean isForceExpl() {
        return this.isForceExpl;
    }

    public void setFire(boolean bl) {
        this.isFire = bl;
    }

    public boolean isFire() {
        return this.isFire;
    }

    public void setForceFire(boolean bl) {
        this.isForceFire = bl;
    }

    public boolean isForceFire() {
        return this.isForceFire;
    }

    public void setDisablePlayerTrample(boolean bl) {
        this.isDisablePlayerTrample = bl;
    }

    public boolean isDisablePlayerTrample() {
        return this.isDisablePlayerTrample;
    }

    public void setDisableCreatureTrample(boolean bl) {
        this.isDisableCreatureTrample = bl;
    }

    public boolean isDisableCreatureTrample() {
        return this.isDisableCreatureTrample;
    }

    public void setWorldMobs(boolean bl) {
        this.hasWorldMobs = bl;
    }

    public boolean hasWorldMobs() {
        return this.hasWorldMobs;
    }

    public void setForceTownMobs(boolean bl) {
        this.isForceTownMobs = bl;
    }

    public boolean isForceTownMobs() {
        return this.isForceTownMobs;
    }

    public void setEndermanProtect(boolean bl) {
        this.isEndermanProtect = bl;
    }

    public boolean isEndermanProtect() {
        return this.isEndermanProtect;
    }

    public void setClaimable(boolean bl) {
        this.isClaimable = bl;
    }

    public boolean isClaimable() {
        if (!this.isUsingTowny()) {
            return false;
        }
        return this.isClaimable;
    }

    public void setUsingDefault() {
        this.setUnclaimedZoneBuild(null);
        this.setUnclaimedZoneDestroy(null);
        this.setUnclaimedZoneSwitch(null);
        this.setUnclaimedZoneItemUse(null);
        this.setUnclaimedZoneIgnore(null);
        this.setUnclaimedZoneName(null);
    }

    public void setUsingPlotManagementDelete(boolean bl) {
        this.isUsingPlotManagementDelete = bl;
    }

    public boolean isUsingPlotManagementDelete() {
        return this.isUsingPlotManagementDelete;
    }

    public void setUsingPlotManagementMayorDelete(boolean bl) {
        this.isUsingPlotManagementMayorDelete = bl;
    }

    public boolean isUsingPlotManagementMayorDelete() {
        return this.isUsingPlotManagementMayorDelete;
    }

    public void setUsingPlotManagementRevert(boolean bl) {
        this.isUsingPlotManagementRevert = bl;
    }

    public boolean isUsingPlotManagementRevert() {
        return this.isUsingPlotManagementRevert;
    }

    public List<Integer> getPlotManagementDeleteIds() {
        if (this.plotManagementDeleteIds == null) {
            return TownySettings.getPlotManagementDeleteIds();
        }
        return this.plotManagementDeleteIds;
    }

    public boolean isPlotManagementDeleteIds(int n) {
        return this.getPlotManagementDeleteIds().contains(n);
    }

    public void setPlotManagementDeleteIds(List<Integer> list) {
        this.plotManagementDeleteIds = list;
    }

    public List<String> getPlotManagementMayorDelete() {
        if (this.plotManagementMayorDelete == null) {
            return TownySettings.getPlotManagementMayorDelete();
        }
        return this.plotManagementMayorDelete;
    }

    public boolean isPlotManagementMayorDelete(String string) {
        return this.getPlotManagementMayorDelete().contains(string.toUpperCase());
    }

    public void setPlotManagementMayorDelete(List<String> list) {
        this.plotManagementMayorDelete = list;
    }

    public List<Integer> getPlotManagementIgnoreIds() {
        if (this.plotManagementIgnoreIds == null) {
            return TownySettings.getPlotManagementIgnoreIds();
        }
        return this.plotManagementIgnoreIds;
    }

    public boolean isPlotManagementIgnoreIds(int n) {
        return this.getPlotManagementIgnoreIds().contains(n);
    }

    public void setPlotManagementIgnoreIds(List<Integer> list) {
        this.plotManagementIgnoreIds = list;
    }

    public boolean isUsingPlotManagementWildRevert() {
        return this.isUsingPlotManagementWildRevert;
    }

    public void setUsingPlotManagementWildRevert(boolean bl) {
        this.isUsingPlotManagementWildRevert = bl;
    }

    public long getPlotManagementRevertSpeed() {
        return this.plotManagementRevertSpeed;
    }

    public void setPlotManagementRevertSpeed(long l) {
        this.plotManagementRevertSpeed = l;
    }

    public long getPlotManagementWildRevertDelay() {
        return this.plotManagementWildRevertDelay;
    }

    public void setPlotManagementWildRevertDelay(long l) {
        this.plotManagementWildRevertDelay = l;
    }

    public void setPlotManagementWildRevertEntities(List<String> list) {
        this.entityExplosionProtection = new ArrayList();
        for (String string : list) {
            if (string.equals("")) continue;
            try {
                Class<?> clazz = Class.forName("org.bukkit.entity." + string);
                if (JavaUtil.isSubInterface(Entity.class, clazz)) {
                    this.entityExplosionProtection.add(clazz);
                    continue;
                }
                throw new Exception();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TownyMessaging.sendErrorMsg("Explosion Regen: " + string + " is not an acceptable class.");
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg("Explosion Regen: " + string + " is not an acceptable entity.");
            }
        }
    }

    public List<String> getPlotManagementWildRevertEntities() {
        if (this.entityExplosionProtection == null) {
            this.setPlotManagementWildRevertEntities(TownySettings.getWildExplosionProtectionEntities());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Class<?> clazz : this.entityExplosionProtection) {
            arrayList.add(clazz.getSimpleName());
        }
        return arrayList;
    }

    public boolean isProtectingExplosionEntity(Entity entity) {
        if (this.entityExplosionProtection == null) {
            this.setPlotManagementWildRevertEntities(TownySettings.getWildExplosionProtectionEntities());
        }
        for (Class<?> clazz : this.entityExplosionProtection) {
            if (clazz.isInstance(entity)) {
                return true;
            }
            if (!clazz.getName().contains(entity.toString())) continue;
            System.out.print(entity.toString());
        }
        return false;
    }

    public List<Integer> getUnclaimedZoneIgnoreIds() {
        if (this.unclaimedZoneIgnoreIds == null) {
            return TownySettings.getUnclaimedZoneIgnoreIds();
        }
        return this.unclaimedZoneIgnoreIds;
    }

    public boolean isUnclaimedZoneIgnoreId(int n) {
        return this.getUnclaimedZoneIgnoreIds().contains(n);
    }

    public void setUnclaimedZoneIgnore(List<Integer> list) {
        this.unclaimedZoneIgnoreIds = list;
    }

    public boolean getUnclaimedZonePerm(TownyPermission.ActionType actionType) {
        switch (actionType) {
            case BUILD: {
                return this.getUnclaimedZoneBuild();
            }
            case DESTROY: {
                return this.getUnclaimedZoneDestroy();
            }
            case SWITCH: {
                return this.getUnclaimedZoneSwitch();
            }
            case ITEM_USE: {
                return this.getUnclaimedZoneItemUse();
            }
        }
        throw new UnsupportedOperationException();
    }

    public Boolean getUnclaimedZoneBuild() {
        if (this.unclaimedZoneBuild == null) {
            return TownySettings.getUnclaimedZoneBuildRights();
        }
        return this.unclaimedZoneBuild;
    }

    public void setUnclaimedZoneBuild(Boolean bl) {
        this.unclaimedZoneBuild = bl;
    }

    public Boolean getUnclaimedZoneDestroy() {
        if (this.unclaimedZoneDestroy == null) {
            return TownySettings.getUnclaimedZoneDestroyRights();
        }
        return this.unclaimedZoneDestroy;
    }

    public void setUnclaimedZoneDestroy(Boolean bl) {
        this.unclaimedZoneDestroy = bl;
    }

    public Boolean getUnclaimedZoneSwitch() {
        if (this.unclaimedZoneSwitch == null) {
            return TownySettings.getUnclaimedZoneSwitchRights();
        }
        return this.unclaimedZoneSwitch;
    }

    public void setUnclaimedZoneSwitch(Boolean bl) {
        this.unclaimedZoneSwitch = bl;
    }

    public String getUnclaimedZoneName() {
        if (this.unclaimedZoneName == null) {
            return TownySettings.getUnclaimedZoneName();
        }
        return this.unclaimedZoneName;
    }

    public void setUnclaimedZoneName(String string) {
        this.unclaimedZoneName = string;
    }

    public void setUsingTowny(boolean bl) {
        this.isUsingTowny = bl;
    }

    public boolean isUsingTowny() {
        return this.isUsingTowny;
    }

    public void setUnclaimedZoneItemUse(Boolean bl) {
        this.unclaimedZoneItemUse = bl;
    }

    public Boolean getUnclaimedZoneItemUse() {
        if (this.unclaimedZoneItemUse == null) {
            return TownySettings.getUnclaimedZoneItemUseRights();
        }
        return this.unclaimedZoneItemUse;
    }

    public int getMinDistanceFromOtherTowns(Coord coord) {
        return this.getMinDistanceFromOtherTowns(coord, null);
    }

    public int getMinDistanceFromOtherTowns(Coord coord, Town town) {
        double d = 2.147483647E9;
        for (Town town2 : this.getTowns()) {
            try {
                double d2;
                Coord coord2 = town2.getHomeBlock().getCoord();
                if (town != null && town.getHomeBlock().equals(town2.getHomeBlock()) || !((d2 = Math.sqrt(Math.pow(coord2.getX() - coord.getX(), 2.0) + Math.pow(coord2.getZ() - coord.getZ(), 2.0))) < d)) continue;
                d = d2;
            }
            catch (TownyException townyException) {}
        }
        return (int)Math.ceil(d);
    }

    public void addWarZone(Coord coord) {
        if (!this.isWarZone(coord)) {
            this.warZones.add(coord);
        }
    }

    public void removeWarZone(Coord coord) {
        this.warZones.remove(coord);
    }

    public boolean isWarZone(Coord coord) {
        return this.warZones.contains(coord);
    }
}

