/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionEventEnums;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.events.GMGroupEvent;
import org.anjocaido.groupmanager.events.GMSystemEvent;
import org.anjocaido.groupmanager.events.GMUserEvent;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

public class GroupManagerSource
extends TownyPermissionSource {
    public GroupManagerSource(Towny towny, Plugin plugin) {
        this.groupManager = (GroupManager)plugin;
        this.plugin = towny;
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new GMCustomEventListener(), (Plugin)this.plugin);
        }
        catch (IllegalPluginAccessException illegalPluginAccessException) {
            System.out.print("Your Version of GroupManager is out of date. Please update.");
        }
    }

    @Override
    public String getPrefixSuffix(Resident resident, String string) {
        String string2 = "";
        String string3 = "";
        Player player = this.plugin.getServer().getPlayer(resident.getName());
        AnjoPermissionsHandler anjoPermissionsHandler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        if (string == "prefix") {
            string2 = anjoPermissionsHandler.getGroupPrefix(anjoPermissionsHandler.getPrimaryGroup(player.getName()));
            string3 = anjoPermissionsHandler.getUserPrefix(player.getName());
        } else if (string == "suffix") {
            string2 = anjoPermissionsHandler.getGroupSuffix(anjoPermissionsHandler.getPrimaryGroup(player.getName()));
            string3 = anjoPermissionsHandler.getUserSuffix(player.getName());
        }
        if (!string2.equals(string3)) {
            string3 = string2 + string3;
        }
        string3 = TownySettings.parseSingleLineString(string3);
        return string3;
    }

    @Override
    public int getGroupPermissionIntNode(String string, String string2) {
        Player player = this.plugin.getServer().getPlayer(string);
        AnjoPermissionsHandler anjoPermissionsHandler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return anjoPermissionsHandler.getPermissionInteger(string, string2);
    }

    @Override
    public String getPlayerPermissionStringNode(String string, String string2) {
        Player player = this.plugin.getServer().getPlayer(string);
        AnjoPermissionsHandler anjoPermissionsHandler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return anjoPermissionsHandler.getPermissionString(string, string2);
    }

    @Override
    public String getPlayerGroup(Player player) {
        AnjoPermissionsHandler anjoPermissionsHandler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return anjoPermissionsHandler.getGroup(player.getName());
    }

    protected class GMCustomEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGH)
        public void onGMUserEvent(GMUserEvent gMUserEvent) {
            block5: {
                Resident resident = null;
                Player player = null;
                try {
                    if (PermissionEventEnums.GMUser_Action.valueOf(gMUserEvent.getAction().name()) == null) break block5;
                    try {
                        resident = TownyUniverse.getDataSource().getResident(gMUserEvent.getUserName());
                        player = GroupManagerSource.this.plugin.getServer().getPlayerExact(resident.getName());
                        if (player != null) {
                            String[] stringArray = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            GroupManagerSource.this.plugin.setPlayerMode(player, stringArray, false);
                            GroupManagerSource.this.plugin.resetCache(player);
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMGroupEvent(GMGroupEvent gMGroupEvent) {
            try {
                if (PermissionEventEnums.GMGroup_Action.valueOf(gMGroupEvent.getAction().name()) != null) {
                    Group group = gMGroupEvent.getGroup();
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null || !group.equals((Object)GroupManagerSource.this.getPlayerGroup(player))) continue;
                        String[] stringArray = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        GroupManagerSource.this.plugin.setPlayerMode(player, stringArray, false);
                        GroupManagerSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMSystemEvent(GMSystemEvent gMSystemEvent) {
            try {
                if (PermissionEventEnums.GMSystem_Action.valueOf(gMSystemEvent.getAction().name()) != null) {
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null) continue;
                        String[] stringArray = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        GroupManagerSource.this.plugin.setPlayerMode(player, stringArray, false);
                        GroupManagerSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

