/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionEventEnums;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;

public class PEXSource
extends TownyPermissionSource {
    public PEXSource(Towny towny, Plugin plugin) {
        this.pex = (PermissionsEx)plugin;
        this.plugin = towny;
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new PEXCustomEventListener(), (Plugin)this.plugin);
        }
        catch (IllegalPluginAccessException illegalPluginAccessException) {
            System.out.print("Your Version of PEX is out of date. Please update.");
        }
    }

    @Override
    public String getPrefixSuffix(Resident resident, String string) {
        String string2 = "";
        String string3 = "";
        Player player = this.plugin.getServer().getPlayer(resident.getName());
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        if (string == "prefix") {
            string2 = permissionManager.getUser(player).getPrefix(player.getWorld().getName());
            string3 = permissionManager.getUser(player).getOwnPrefix();
        } else if (string == "suffix") {
            string2 = permissionManager.getUser(player).getSuffix(player.getWorld().getName());
            string3 = permissionManager.getUser(player).getOwnSuffix();
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (!string2.equals(string3)) {
            string3 = string2 + string3;
        }
        string3 = TownySettings.parseSingleLineString(string3);
        return string3;
    }

    @Override
    public int getGroupPermissionIntNode(String string, String string2) {
        Player player = this.plugin.getServer().getPlayer(string);
        String string3 = player.getWorld().getName();
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        String string4 = permissionManager.getUser(player).getOption(string2, string3);
        try {
            return Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public String getPlayerPermissionStringNode(String string, String string2) {
        Player player = this.plugin.getServer().getPlayer(string);
        String string3 = player.getWorld().getName();
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        String string4 = permissionManager.getUser(player).getOption(string2, string3);
        if (string4 != null) {
            return string4;
        }
        return "";
    }

    @Override
    public String getPlayerGroup(Player player) {
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        return permissionManager.getUser(player).getGroupsNames()[0];
    }

    public PermissionGroup[] getPlayerGroups(Player player) {
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        return permissionManager.getUser(player).getGroups();
    }

    protected class PEXCustomEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGH)
        public void onPermissionEntityEvent(PermissionEntityEvent permissionEntityEvent) {
            block7: {
                Resident resident = null;
                Player player = null;
                try {
                    if (PermissionEventEnums.PEXEntity_Action.valueOf(permissionEntityEvent.getEventName()) == null) break block7;
                    PermissionEntityEvent permissionEntityEvent2 = permissionEntityEvent;
                    PermissionEntity permissionEntity = permissionEntityEvent2.getEntity();
                    if (permissionEntity instanceof PermissionGroup) {
                        PermissionGroup permissionGroup = (PermissionGroup)permissionEntity;
                        for (Player player2 : BukkitTools.getOnlinePlayers()) {
                            if (player2 == null || !Arrays.asList(PEXSource.this.getPlayerGroups(player2)).contains(permissionGroup)) continue;
                            String[] stringArray = PEXSource.this.getPlayerPermissionStringNode(player2.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            PEXSource.this.plugin.setPlayerMode(player2, stringArray, false);
                            PEXSource.this.plugin.resetCache(player2);
                        }
                        break block7;
                    }
                    if (!(permissionEntity instanceof PermissionUser)) break block7;
                    try {
                        resident = TownyUniverse.getDataSource().getResident(((PermissionUser)permissionEntity).getName());
                        player = PEXSource.this.plugin.getServer().getPlayerExact(resident.getName());
                        if (player != null) {
                            String[] stringArray = PEXSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            PEXSource.this.plugin.setPlayerMode(player, stringArray, false);
                            PEXSource.this.plugin.resetCache(player);
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onPermissionSystemEvent(PermissionSystemEvent permissionSystemEvent) {
            try {
                if (PermissionEventEnums.PEXSystem_Action.valueOf(permissionSystemEvent.getEventName()) != null) {
                    for (Player player : BukkitTools.getOnlinePlayers()) {
                        if (player == null) continue;
                        String[] stringArray = PEXSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                        PEXSource.this.plugin.setPlayerMode(player, stringArray, false);
                        PEXSource.this.plugin.resetCache(player);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

