/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class TownyPerms {
    protected static LinkedHashMap<String, Permission> registeredPermissions = new LinkedHashMap();
    protected static HashMap<String, PermissionAttachment> attachments = new HashMap();
    private static CommentedConfiguration perms;
    private static Towny plugin;
    private static Field permissions;

    public static void initialize(Towny towny) {
        plugin = towny;
    }

    public static void loadPerms(String string, String string2) throws IOException {
        String string3 = string + FileMgmt.fileSeparator() + string2;
        File file = FileMgmt.unpackResourceFile(string3, string2, string2);
        if (file != null) {
            perms = new CommentedConfiguration(file);
            perms.load();
        }
        TownyPerms.collectPermissions();
    }

    public static void assignPermissions(Resident resident, Player player) {
        PermissionAttachment permissionAttachment = null;
        if (resident == null) {
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
                return;
            }
        } else {
            player = BukkitTools.getPlayer(resident.getName());
        }
        if (player == null || !player.isOnline()) {
            attachments.remove(resident.getName());
            return;
        }
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            notRegisteredException.printStackTrace();
            return;
        }
        permissionAttachment = attachments.containsKey(resident.getName()) ? attachments.get(resident.getName()) : BukkitTools.getPlayer(resident.getName()).addAttachment((Plugin)plugin);
        try {
            Map map = (Map)permissions.get(permissionAttachment);
            map.clear();
            if (townyWorld.isUsingTowny()) {
                map.putAll(TownyPerms.getResidentPerms(resident));
            }
            permissionAttachment.getPermissible().recalculatePermissions();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        attachments.put(resident.getName(), permissionAttachment);
    }

    public static void removeAttachment(String string) {
        if (attachments.containsKey(string)) {
            attachments.remove(string);
        }
    }

    public static void updateTownPerms(Town town) {
        for (Resident resident : town.getResidents()) {
            TownyPerms.assignPermissions(resident, null);
        }
    }

    public static void updateNationPerms(Nation nation) {
        for (Town town : nation.getTowns()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static List<String> getList(String string) {
        if (perms.contains(string)) {
            return perms.getStringList(string);
        }
        return null;
    }

    public static LinkedHashMap<String, Boolean> getResidentPerms(Resident resident) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(TownyPerms.getDefault());
        if (resident.hasTown()) {
            hashSet.addAll(TownyPerms.getTownDefault());
            if (resident.isMayor()) {
                hashSet.addAll(TownyPerms.getTownMayor());
            }
            for (String object2 : resident.getTownRanks()) {
                hashSet.addAll(TownyPerms.getTownRank(object2));
            }
            if (resident.hasNation()) {
                hashSet.addAll(TownyPerms.getNationDefault());
                if (resident.isKing()) {
                    hashSet.addAll(TownyPerms.getNationKing());
                }
                for (String string : resident.getNationRanks()) {
                    hashSet.addAll(TownyPerms.getNationRank(string));
                }
            }
        }
        Iterator<String> iterator = TownyPerms.sort(new ArrayList<String>(hashSet));
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        Boolean bl = false;
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            bl = !string.startsWith("-");
            linkedHashMap.put(bl != false ? string : string.substring(1), bl);
        }
        return linkedHashMap;
    }

    public static void registerPermissionNodes() {
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                Permission permission;
                for (String string : TownyPerms.getTownRanks()) {
                    permission = new Permission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(string), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                    permission.addParent(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(), true);
                }
                for (String string : TownyPerms.getNationRanks()) {
                    permission = new Permission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(string), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                    permission.addParent(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(), true);
                }
            }
        }, 1L);
    }

    public static List<String> getDefault() {
        ArrayList arrayList = TownyPerms.getList("nomad");
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static List<String> getTownRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("towns.ranks")).getKeys(false));
    }

    public static List<String> getTownDefault() {
        ArrayList arrayList = TownyPerms.getList("towns.default");
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static List<String> getTownMayor() {
        ArrayList arrayList = TownyPerms.getList("towns.mayor");
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static List<String> getTownRank(String string) {
        ArrayList arrayList = TownyPerms.getList("towns.ranks." + string.toLowerCase());
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static List<String> getNationRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("nations.ranks")).getKeys(false));
    }

    public static List<String> getNationDefault() {
        ArrayList arrayList = TownyPerms.getList("nations.default");
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static List<String> getNationKing() {
        ArrayList arrayList = TownyPerms.getList("nations.king");
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static List<String> getNationRank(String string) {
        ArrayList arrayList = TownyPerms.getList("nations.ranks." + string.toLowerCase());
        return arrayList == null ? new ArrayList() : arrayList;
    }

    public static void collectPermissions() {
        registeredPermissions.clear();
        for (Permission permission : BukkitTools.getPluginManager().getPermissions()) {
            registeredPermissions.put(permission.getName().toLowerCase(), permission);
        }
    }

    private static List<String> sort(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = string.charAt(0) == '-' ? string.substring(1) : string;
            Map<String, Boolean> map = TownyPerms.getAllChildren(string2, new HashSet<String>());
            if (map != null) {
                ListIterator<String> listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    String string3 = (String)listIterator.next();
                    String string4 = string3.charAt(0) == '-' ? string3.substring(1) : string3;
                    if (!map.containsKey(string4)) continue;
                    listIterator.set(string);
                    listIterator.add(string3);
                    break;
                }
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getAllRegisteredPermissions(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : registeredPermissions.keySet()) {
            Map<String, Boolean> map;
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
            if (!bl || (map = TownyPerms.getAllChildren(string, new HashSet<String>())) == null) continue;
            for (String string2 : map.keySet()) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static Map<String, Boolean> getAllChildren(String string, Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        linkedList.push(string);
        hashMap.put(string, true);
        while (!linkedList.isEmpty()) {
            String string2 = (String)linkedList.pop();
            Map<String, Boolean> map = TownyPerms.getChildren(string2);
            if (map == null || set.contains("-" + string2)) continue;
            for (String string3 : map.keySet()) {
                if (hashMap.containsKey(string3)) continue;
                linkedList.push(string3);
                hashMap.put(string3, map.get(string3));
            }
        }
        hashMap.remove(string);
        if (!hashMap.isEmpty()) {
            return hashMap;
        }
        return null;
    }

    public static Map<String, Boolean> getChildren(String string) {
        Permission permission = registeredPermissions.get(string.toLowerCase());
        if (permission == null) {
            return null;
        }
        return permission.getChildren();
    }

    static {
        try {
            permissions = PermissionAttachment.class.getDeclaredField("permissions");
            permissions.setAccessible(true);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
    }
}

