/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.regen.block.BlockObject;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;

public class PlotBlockData {
    private int defaultVersion = 1;
    private String worldName;
    private TownBlock townBlock;
    private int x;
    private int z;
    private int size;
    private int height;
    private int version;
    private List<Integer> blockList = new ArrayList<Integer>();
    private int blockListRestored;

    public PlotBlockData(TownBlock townBlock) {
        this.townBlock = townBlock;
        this.setX(townBlock.getX());
        this.setZ(townBlock.getZ());
        this.setSize(TownySettings.getTownBlockSize());
        this.worldName = townBlock.getWorld().getName();
        this.setVersion(this.defaultVersion);
        this.setHeight(townBlock.getWorldCoord().getBukkitWorld().getMaxHeight() - 1);
        this.blockListRestored = 0;
    }

    public void initialize() {
        List<Integer> list = this.getBlockArr();
        if (list != null) {
            this.setBlockList(list);
            this.resetBlockListRestored();
        }
    }

    private List<Integer> getBlockArr() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Block block = null;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                block5: for (int k = this.height; k > 0; --k) {
                    block = world.getBlockAt(this.getX() * this.size + j, k, this.getZ() * this.size + i);
                    switch (this.defaultVersion) {
                        case 1: {
                            arrayList.add(block.getTypeId());
                            arrayList.add(Integer.valueOf(block.getData()));
                            continue block5;
                        }
                        default: {
                            arrayList.add(block.getTypeId());
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean restoreNextBlock() {
        int n;
        Block block = null;
        int n2 = this.getX() * this.size;
        int n3 = this.getZ() * this.size;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        if (!world.isChunkLoaded(BukkitTools.calcChunk(this.getX()), BukkitTools.calcChunk(this.getZ()))) {
            return true;
        }
        switch (this.version) {
            case 1: {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        int n4 = (this.blockList.size() - this.blockListRestored) / n;
        while (n4 > 0) {
            int n5 = this.height - --n4 % this.height;
            int n6 = n4 / this.height % this.size;
            int n7 = n4 / this.height / this.size % this.size;
            block = world.getBlockAt(n2 + n6, n5, n3 + n7);
            int n8 = block.getTypeId();
            BlockObject blockObject = this.getStoredBlockData(this.blockList.size() - 1 - this.blockListRestored);
            this.blockListRestored += n;
            if (n8 == blockObject.getTypeId()) continue;
            if (!this.townBlock.getWorld().isPlotManagementIgnoreIds(blockObject.getTypeId())) {
                switch (this.version) {
                    case 1: {
                        block.setTypeIdAndData(blockObject.getTypeId(), blockObject.getData(), false);
                        break;
                    }
                    default: {
                        block.setTypeId(blockObject.getTypeId());
                        break;
                    }
                }
            } else {
                block.setTypeId(0);
            }
            return true;
        }
        this.resetBlockListRestored();
        return false;
    }

    private BlockObject getStoredBlockData(int n) {
        switch (this.version) {
            case 1: {
                return new BlockObject((int)this.blockList.get(n - 1), (byte)(this.blockList.get(n) & 0xFF));
            }
        }
        return new BlockObject((int)this.blockList.get(n), 0);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public List<Integer> getBlockList() {
        return this.blockList;
    }

    public void setBlockList(List<Integer> list) {
        this.blockList = list;
    }

    public void resetBlockListRestored() {
        this.blockListRestored = 0;
    }
}

