/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.block.BlockInventoryHolder;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.regen.block.BlockMobSpawner;
import com.palmergames.bukkit.towny.regen.block.BlockObject;
import com.palmergames.bukkit.towny.regen.block.BlockSign;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class TownyRegenAPI {
    private static Hashtable<String, PlotBlockData> PlotChunks = new Hashtable();
    private static List<WorldCoord> deleteTownBlockIdQueue = new ArrayList<WorldCoord>();
    private static List<WorldCoord> worldCoords = new ArrayList<WorldCoord>();
    private static Hashtable<BlockLocation, ProtectionRegenTask> protectionRegenTasks = new Hashtable();
    private static Set<Block> protectionPlaceholders = new HashSet<Block>();

    public static void initialize(Towny towny) {
    }

    public static void addWorldCoord(WorldCoord worldCoord) {
        if (!worldCoords.contains(worldCoord)) {
            worldCoords.add(worldCoord);
        }
    }

    public static boolean hasWorldCoords() {
        return worldCoords.size() != 0;
    }

    public static boolean hasWorldCoord(WorldCoord worldCoord) {
        return worldCoords.contains(worldCoord);
    }

    public static WorldCoord getWorldCoord() {
        if (!worldCoords.isEmpty()) {
            WorldCoord worldCoord = worldCoords.get(0);
            worldCoords.remove(0);
            return worldCoord;
        }
        return null;
    }

    public static Hashtable<String, PlotBlockData> getPlotChunks() {
        return PlotChunks;
    }

    public static boolean hasPlotChunks() {
        return !PlotChunks.isEmpty();
    }

    public static void setPlotChunks(Hashtable<String, PlotBlockData> hashtable) {
        PlotChunks = hashtable;
    }

    public static void deletePlotChunk(PlotBlockData plotBlockData) {
        if (PlotChunks.containsKey(TownyRegenAPI.getPlotKey(plotBlockData))) {
            PlotChunks.remove(TownyRegenAPI.getPlotKey(plotBlockData));
            TownyUniverse.getDataSource().saveRegenList();
        }
    }

    public static void addPlotChunk(PlotBlockData plotBlockData, boolean bl) {
        if (!PlotChunks.containsKey(TownyRegenAPI.getPlotKey(plotBlockData))) {
            PlotChunks.put(TownyRegenAPI.getPlotKey(plotBlockData), plotBlockData);
            if (bl) {
                TownyUniverse.getDataSource().saveRegenList();
            }
        }
    }

    public static void addPlotChunkSnapshot(PlotBlockData plotBlockData) {
        if (TownyUniverse.getDataSource().loadPlotData(plotBlockData.getWorldName(), plotBlockData.getX(), plotBlockData.getZ()) == null) {
            TownyUniverse.getDataSource().savePlotData(plotBlockData);
        }
    }

    public static void deletePlotChunkSnapshot(PlotBlockData plotBlockData) {
        TownyUniverse.getDataSource().deletePlotData(plotBlockData);
    }

    public static PlotBlockData getPlotChunkSnapshot(TownBlock townBlock) {
        return TownyUniverse.getDataSource().loadPlotData(townBlock);
    }

    public static PlotBlockData getPlotChunk(TownBlock townBlock) {
        if (PlotChunks.containsKey(TownyRegenAPI.getPlotKey(townBlock))) {
            return PlotChunks.get(TownyRegenAPI.getPlotKey(townBlock));
        }
        return null;
    }

    private static String getPlotKey(PlotBlockData plotBlockData) {
        return "[" + plotBlockData.getWorldName() + "|" + plotBlockData.getX() + "|" + plotBlockData.getZ() + "]";
    }

    public static String getPlotKey(TownBlock townBlock) {
        return "[" + townBlock.getWorld().getName() + "|" + townBlock.getX() + "|" + townBlock.getZ() + "]";
    }

    public static void regenChunk(Player player) {
        try {
            Coord coord = Coord.parseCoord((Entity)player);
            World world = player.getWorld();
            Chunk chunk = world.getChunkAt(player.getLocation());
            int n = world.getMaxHeight();
            Object[][][] objectArray = new Object[16][n][16];
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < n; ++k) {
                        BlockObject blockObject;
                        BlockState blockState = chunk.getBlock(i, k, j).getState();
                        if (blockState instanceof Sign) {
                            blockObject = new BlockSign(blockState.getTypeId(), blockState.getData().getData(), ((Sign)blockState).getLines());
                            blockObject.setLocation(blockState.getLocation());
                            objectArray[i][k][j] = blockObject;
                            continue;
                        }
                        if (blockState instanceof CreatureSpawner) {
                            blockObject = new BlockMobSpawner(((CreatureSpawner)blockState).getSpawnedType());
                            blockObject.setLocation(blockState.getLocation());
                            ((BlockMobSpawner)blockObject).setDelay(((CreatureSpawner)blockState).getDelay());
                            objectArray[i][k][j] = blockObject;
                            continue;
                        }
                        if (blockState instanceof InventoryHolder && !(blockState instanceof Player)) {
                            blockObject = new BlockInventoryHolder(blockState.getTypeId(), blockState.getData().getData(), ((InventoryHolder)blockState).getInventory().getContents());
                            blockObject.setLocation(blockState.getLocation());
                            objectArray[i][k][j] = blockObject;
                            continue;
                        }
                        objectArray[i][k][j] = new BlockObject(blockState.getTypeId(), blockState.getData().getData(), blockState.getLocation());
                    }
                }
            }
            TownyUniverse.getDataSource().getResident(player.getName()).addUndo(objectArray);
            Bukkit.getWorld((String)player.getWorld().getName()).regenerateChunk(coord.getX(), coord.getZ());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public static void regenUndo(Object[][][] objectArray, Resident resident) {
        BlockObject blockObject = (BlockObject)objectArray[0][0][0];
        World world = blockObject.getLocation().getWorld();
        Chunk chunk = blockObject.getLocation().getChunk();
        int n = world.getMaxHeight();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < n; ++k) {
                    Sign sign;
                    BlockObject blockObject2;
                    Object object = objectArray[i][k][j];
                    Block block = chunk.getBlock(i, k, j);
                    if (object instanceof BlockSign) {
                        blockObject2 = (BlockSign)object;
                        block.setTypeIdAndData(blockObject2.getTypeId(), blockObject2.getData(), false);
                        sign = (Sign)block.getState();
                        int n2 = 0;
                        for (String string : ((BlockSign)blockObject2).getLines()) {
                            sign.setLine(n2++, string);
                        }
                        sign.update(true);
                        continue;
                    }
                    if (object instanceof BlockMobSpawner) {
                        blockObject2 = (BlockMobSpawner)object;
                        block.setTypeIdAndData(blockObject2.getTypeId(), blockObject2.getData(), false);
                        ((CreatureSpawner)block.getState()).setSpawnedType(((BlockMobSpawner)blockObject2).getSpawnedType());
                        ((CreatureSpawner)block.getState()).setDelay(((BlockMobSpawner)blockObject2).getDelay());
                        continue;
                    }
                    if (object instanceof BlockInventoryHolder && !(object instanceof Player)) {
                        blockObject2 = (BlockInventoryHolder)object;
                        block.setTypeIdAndData(blockObject2.getTypeId(), blockObject2.getData(), false);
                        sign = (InventoryHolder)block.getState();
                        if (((BlockInventoryHolder)blockObject2).getItems().length <= 0) continue;
                        sign.getInventory().setContents(((BlockInventoryHolder)blockObject2).getItems());
                        continue;
                    }
                    blockObject2 = (BlockObject)object;
                    block.setTypeIdAndData(blockObject2.getTypeId(), blockObject2.getData(), false);
                }
            }
        }
        TownyMessaging.sendMessage((Object)BukkitTools.getServer().getPlayerExact(resident.getName()), TownySettings.getLangString("msg_undo_complete"));
    }

    public static boolean hasDeleteTownBlockIdQueue() {
        return !deleteTownBlockIdQueue.isEmpty();
    }

    public static boolean isDeleteTownBlockIdQueue(WorldCoord worldCoord) {
        return deleteTownBlockIdQueue.contains(worldCoord);
    }

    public static void addDeleteTownBlockIdQueue(WorldCoord worldCoord) {
        if (!deleteTownBlockIdQueue.contains(worldCoord)) {
            deleteTownBlockIdQueue.add(worldCoord);
        }
    }

    public static WorldCoord getDeleteTownBlockIdQueue() {
        if (!deleteTownBlockIdQueue.isEmpty()) {
            WorldCoord worldCoord = deleteTownBlockIdQueue.get(0);
            deleteTownBlockIdQueue.remove(0);
            return worldCoord;
        }
        return null;
    }

    public static void doDeleteTownBlockIds(WorldCoord worldCoord) {
        World world = null;
        int n = TownySettings.getTownBlockSize();
        TownyMessaging.sendDebugMsg("Processing deleteTownBlockIds");
        world = worldCoord.getBukkitWorld();
        if (world != null) {
            int n2 = world.getMaxHeight() - 1;
            int n3 = worldCoord.getX() * n;
            int n4 = worldCoord.getZ() * n;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = n2; k > 0; --k) {
                        Block block = world.getBlockAt(n3 + j, k, n4 + i);
                        try {
                            if (worldCoord.getTownyWorld().isPlotManagementDeleteIds(block.getTypeId())) {
                                block.setType(Material.AIR);
                            }
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                        block = null;
                    }
                }
            }
        }
    }

    public static void deleteTownBlockMaterial(TownBlock townBlock, int n) {
        int n2 = TownySettings.getTownBlockSize();
        TownyMessaging.sendDebugMsg("Processing deleteTownBlockMaterial");
        World world = BukkitTools.getServer().getWorld(townBlock.getWorld().getName());
        if (world != null) {
            int n3 = world.getMaxHeight() - 1;
            int n4 = townBlock.getX() * n2;
            int n5 = townBlock.getZ() * n2;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = n3; k > 0; --k) {
                        Block block = world.getBlockAt(n4 + j, k, n5 + i);
                        if (block.getTypeId() == n) {
                            block.setType(Material.AIR);
                        }
                        block = null;
                    }
                }
            }
        }
    }

    public static boolean hasProtectionRegenTask(BlockLocation blockLocation) {
        for (BlockLocation blockLocation2 : protectionRegenTasks.keySet()) {
            if (!blockLocation2.isLocation(blockLocation)) continue;
            return true;
        }
        return false;
    }

    public static ProtectionRegenTask GetProtectionRegenTask(BlockLocation blockLocation) {
        for (BlockLocation blockLocation2 : protectionRegenTasks.keySet()) {
            if (!blockLocation2.isLocation(blockLocation)) continue;
            return protectionRegenTasks.get(blockLocation2);
        }
        return null;
    }

    public static void addProtectionRegenTask(ProtectionRegenTask protectionRegenTask) {
        protectionRegenTasks.put(protectionRegenTask.getBlockLocation(), protectionRegenTask);
    }

    public static void removeProtectionRegenTask(ProtectionRegenTask protectionRegenTask) {
        protectionRegenTasks.remove(protectionRegenTask.getBlockLocation());
        if (protectionRegenTasks.isEmpty()) {
            protectionPlaceholders.clear();
        }
    }

    public static void cancelProtectionRegenTasks() {
        for (ProtectionRegenTask protectionRegenTask : protectionRegenTasks.values()) {
            BukkitTools.getServer().getScheduler().cancelTask(protectionRegenTask.getTaskId());
            protectionRegenTask.replaceProtections();
        }
        protectionRegenTasks.clear();
        protectionPlaceholders.clear();
    }

    public static boolean isPlaceholder(Block block) {
        return protectionPlaceholders.contains(block);
    }

    public static void addPlaceholder(Block block) {
        protectionPlaceholders.add(block);
    }

    public static void removePlaceholder(Block block) {
        protectionPlaceholders.remove(block);
    }
}

