/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealthRegenTimerTask
extends TownyTimerTask {
    private Server server;

    public HealthRegenTimerTask(Towny towny, Server server) {
        super(towny);
        this.server = server;
    }

    @Override
    public void run() {
        if (TownyUniverse.isWarTime()) {
            return;
        }
        for (Player player : this.server.getOnlinePlayers()) {
            if (player.getHealth() <= 0) continue;
            Coord coord = Coord.parseCoord((Entity)player);
            try {
                TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                TownBlock townBlock = townyWorld.getTownBlock(coord);
                if (!CombatUtil.isAlly(townBlock.getTown(), TownyUniverse.getDataSource().getResident(player.getName()).getTown()) || townBlock.getType().equals((Object)TownBlockType.ARENA)) continue;
                this.incHealth(player);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public void incHealth(Player player) {
        int n = player.getHealth();
        if (n < 20) {
            player.setHealth(++n);
            EntityRegainHealthEvent entityRegainHealthEvent = new EntityRegainHealthEvent((Entity)player, n, EntityRegainHealthEvent.RegainReason.REGEN);
            Bukkit.getServer().getPluginManager().callEvent((Event)entityRegainHealthEvent);
        }
    }
}

