/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MobRemovalTimerTask
extends TownyTimerTask {
    private Server server;
    public static List<Class<?>> classesOfWorldMobsToRemove = new ArrayList();
    public static List<Class<?>> classesOfTownMobsToRemove = new ArrayList();

    public MobRemovalTimerTask(Towny towny, Server server) {
        super(towny);
        this.server = server;
        classesOfWorldMobsToRemove = MobRemovalTimerTask.parseLivingEntityClassNames(TownySettings.getWorldMobRemovalEntities(), "WorldMob: ");
        classesOfTownMobsToRemove = MobRemovalTimerTask.parseLivingEntityClassNames(TownySettings.getTownMobRemovalEntities(), "TownMob: ");
    }

    public static List<Class<?>> parseLivingEntityClassNames(List<String> list, String string) {
        ArrayList arrayList = new ArrayList();
        for (String string2 : list) {
            if (string2.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName("org.bukkit.entity." + string2);
                if (JavaUtil.isSubInterface(LivingEntity.class, clazz)) {
                    arrayList.add(clazz);
                    continue;
                }
                throw new Exception();
            }
            catch (ClassNotFoundException classNotFoundException) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable class.", string, string2));
            }
            catch (Exception exception) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable living entity.", string, string2));
            }
        }
        return arrayList;
    }

    public static boolean isRemovingWorldEntity(LivingEntity livingEntity) {
        return MobRemovalTimerTask.isInstanceOfAny(classesOfWorldMobsToRemove, livingEntity);
    }

    public static boolean isRemovingTownEntity(LivingEntity livingEntity) {
        return MobRemovalTimerTask.isInstanceOfAny(classesOfTownMobsToRemove, livingEntity);
    }

    public static boolean isInstanceOfAny(List<Class<?>> list, Object object) {
        for (Class<?> clazz : list) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        ArrayList<LivingEntity> arrayList = new ArrayList<LivingEntity>();
        for (World world : this.server.getWorlds()) {
            TownyWorld townyWorld;
            try {
                townyWorld = TownyUniverse.getDataSource().getWorld(world.getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                continue;
            }
            if (!townyWorld.isUsingTowny() || townyWorld.isForceTownMobs() && townyWorld.hasWorldMobs()) continue;
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                block8: {
                    Location location = livingEntity.getLocation();
                    if (!location.getChunk().isLoaded()) continue;
                    Coord coord = Coord.parseCoord(location);
                    try {
                        Town town;
                        TownBlock townBlock = townyWorld.getTownBlock(coord);
                        if (townyWorld.isForceTownMobs() || townBlock.getPermissions().mobs || (town = townBlock.getTown()).hasMobs()) continue;
                        if (!MobRemovalTimerTask.isRemovingTownEntity(livingEntity)) {
                        }
                        break block8;
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        if (townyWorld.hasWorldMobs()) continue;
                        if (MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) break block8;
                    }
                    continue;
                }
                if (this.plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) continue;
                arrayList.add(livingEntity);
            }
        }
        for (LivingEntity livingEntity : arrayList) {
            TownyMessaging.sendDebugMsg("MobRemoval Removed: " + livingEntity.toString());
            livingEntity.remove();
        }
    }
}

