/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.regen.NeedsPlaceholder;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;
import org.bukkit.material.Door;
import org.bukkit.material.PistonExtensionMaterial;

public class ProtectionRegenTask
extends TownyTimerTask {
    private BlockState state;
    private BlockState altState;
    private BlockLocation blockLocation;
    private int TaskId;
    private List<ItemStack> contents = new ArrayList<ItemStack>();
    private static final Material placeholder = Material.DIRT;

    public ProtectionRegenTask(Towny towny, Block block, boolean bl) {
        super(towny);
        Inventory inventory;
        this.state = block.getState();
        this.altState = null;
        this.setBlockLocation(new BlockLocation(block.getLocation()));
        if (this.state instanceof InventoryHolder) {
            inventory = ((InventoryHolder)this.state).getInventory();
            for (Block block2 : inventory.getContents()) {
                this.contents.add(block2 != null ? block2.clone() : null);
            }
            inventory.clear();
        }
        if (bl) {
            Block block3;
            if (this.state.getData() instanceof Door) {
                Block block4;
                inventory = (Door)this.state.getData();
                if (inventory.isTopHalf()) {
                    block3 = block;
                    block4 = block.getRelative(BlockFace.DOWN);
                } else {
                    block4 = block;
                    block3 = block.getRelative(BlockFace.UP);
                }
                block4.setTypeId(0);
                block3.setTypeId(0);
            } else if (this.state.getData() instanceof PistonExtensionMaterial) {
                inventory = (PistonExtensionMaterial)this.state.getData();
                block3 = block.getRelative(inventory.getAttachedFace());
                if (block3.getTypeId() != 0) {
                    this.altState = block3.getState();
                    block3.setTypeId(0, false);
                }
                block.setTypeId(0, false);
            } else {
                block.setTypeId(0, false);
            }
        }
    }

    @Override
    public void run() {
        this.replaceProtections();
        TownyRegenAPI.removeProtectionRegenTask(this);
    }

    public void replaceProtections() {
        try {
            Block block = this.state.getBlock();
            if (this.state.getData() instanceof Door) {
                Block block2;
                Block block3;
                Door door = (Door)this.state.getData();
                if (door.isTopHalf()) {
                    block3 = block;
                    block2 = block.getRelative(BlockFace.DOWN);
                } else {
                    block2 = block;
                    block3 = block.getRelative(BlockFace.UP);
                }
                door.setTopHalf(true);
                block3.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
                door.setTopHalf(false);
                block2.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
            } else if (this.state instanceof Sign) {
                block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
                Sign sign = (Sign)block.getState();
                int n = 0;
                for (String string : ((Sign)this.state).getLines()) {
                    sign.setLine(n++, string);
                }
                sign.update(true);
            } else if (this.state instanceof CreatureSpawner) {
                block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
                ((CreatureSpawner)block.getState()).setSpawnedType(((CreatureSpawner)this.state).getSpawnedType());
            } else if (this.state instanceof InventoryHolder) {
                block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
                Inventory inventory = ((InventoryHolder)block.getState()).getInventory();
                inventory.setContents(this.contents.toArray(new ItemStack[0]));
            } else if (this.state.getData() instanceof PistonExtensionMaterial) {
                PistonExtensionMaterial pistonExtensionMaterial = (PistonExtensionMaterial)this.state.getData();
                Block block4 = block.getRelative(pistonExtensionMaterial.getAttachedFace());
                block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
                if (this.altState != null) {
                    block4.setTypeIdAndData(this.altState.getTypeId(), this.altState.getData().getData(), false);
                }
            } else if (this.state.getData() instanceof Attachable) {
                Block block5 = block.getRelative(((Attachable)this.state.getData()).getAttachedFace());
                if (block5.getTypeId() == 0) {
                    block5.setTypeId(placeholder.getId(), false);
                    TownyRegenAPI.addPlaceholder(block5);
                }
                block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
            } else {
                Block block6;
                if (NeedsPlaceholder.contains(this.state.getType()) && (block6 = block.getRelative(BlockFace.DOWN)).getTypeId() == 0) {
                    if (this.state.getType().equals((Object)Material.CROPS)) {
                        block6.setTypeId(Material.SOIL.getId(), true);
                    } else {
                        block6.setTypeId(placeholder.getId(), true);
                    }
                    TownyRegenAPI.addPlaceholder(block6);
                }
                block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), !NeedsPlaceholder.contains(this.state.getType()));
            }
            TownyRegenAPI.removePlaceholder(block);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BlockLocation getBlockLocation() {
        return this.blockLocation;
    }

    private void setBlockLocation(BlockLocation blockLocation) {
        this.blockLocation = blockLocation;
    }

    public BlockState getState() {
        return this.state;
    }

    public int getTaskId() {
        return this.TaskId;
    }

    public void setTaskId(int n) {
        this.TaskId = n;
    }
}

