/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public class ResidentPurge
extends Thread {
    Towny plugin;
    private CommandSender sender = null;
    long deleteTime;

    public ResidentPurge(Towny towny, CommandSender commandSender, long l) {
        this.plugin = towny;
        this.deleteTime = l;
        this.setPriority(5);
    }

    @Override
    public void run() {
        int n = 0;
        this.message("Scanning for old residents...");
        for (Resident resident : new ArrayList<Resident>(TownyUniverse.getDataSource().getResidents())) {
            if (resident.isNPC() || System.currentTimeMillis() - resident.getLastOnline() <= this.deleteTime || BukkitTools.isOnline(resident.getName())) continue;
            ++n;
            this.message("Deleting resident: " + resident.getName());
            TownyUniverse.getDataSource().removeResident(resident);
            TownyUniverse.getDataSource().removeResidentList(resident);
        }
        this.message("Resident purge complete: " + n + " deleted.");
    }

    private void message(String string) {
        if (this.sender != null) {
            TownyMessaging.sendMessage((Object)this.sender, string);
        } else {
            TownyMessaging.sendMsg(string);
        }
    }
}

