/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownClaim
extends Thread {
    Towny plugin;
    volatile Player player;
    protected Location outpostLocation;
    volatile Town town;
    List<WorldCoord> selection;
    boolean outpost;
    boolean claim;
    boolean forced;

    public TownClaim(Towny towny, Player player, Town town, List<WorldCoord> list, boolean bl, boolean bl2, boolean bl3) {
        this.plugin = towny;
        this.player = player;
        if (this.player != null) {
            this.outpostLocation = player.getLocation();
        }
        this.town = town;
        this.selection = list;
        this.outpost = bl;
        this.claim = bl2;
        this.forced = bl3;
        this.setPriority(1);
    }

    @Override
    public void run() {
        ArrayList<TownyWorld> arrayList = new ArrayList<TownyWorld>();
        ArrayList<Town> arrayList2 = new ArrayList<Town>();
        if (this.player != null) {
            TownyMessaging.sendMsg((Object)this.player, "Processing " + (this.claim ? "Town Claim..." : "Town unclaim..."));
        }
        if (this.selection != null) {
            for (WorldCoord object : this.selection) {
                try {
                    TownyWorld townyWorld = object.getTownyWorld();
                    if (!arrayList.contains(townyWorld)) {
                        arrayList.add(townyWorld);
                    }
                    if (this.claim) {
                        this.townClaim(this.town, object, this.outpost);
                        this.outpost = false;
                    } else {
                        this.town = object.getTownBlock().getTown();
                        this.townUnclaim(this.town, object, this.forced);
                    }
                    if (arrayList2.contains(this.town)) continue;
                    arrayList2.add(this.town);
                }
                catch (NotRegisteredException notRegisteredException) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_err_not_configured"));
                }
                catch (TownyException townyException) {
                    TownyMessaging.sendErrorMsg((Object)this.player, townyException.getMessage());
                }
            }
        } else if (!this.claim) {
            this.townUnclaimAll(this.town);
        }
        if (!arrayList2.isEmpty()) {
            for (Town town : arrayList2) {
                TownyUniverse.getDataSource().saveTown(town);
            }
        }
        if (!arrayList.isEmpty()) {
            for (TownyWorld townyWorld : arrayList) {
                TownyUniverse.getDataSource().saveWorld(townyWorld);
            }
        }
        this.plugin.resetCache();
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((Object)this.player, String.format(TownySettings.getLangString("msg_annexed_area"), this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                if (this.town.getWorld().isUsingPlotManagementRevert()) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_wait_locked"));
                }
            } else if (this.forced) {
                TownyMessaging.sendMsg((Object)this.player, String.format(TownySettings.getLangString("msg_admin_unclaim_area"), this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                if (this.town.getWorld().isUsingPlotManagementRevert()) {
                    TownyMessaging.sendMsg((Object)this.player, TownySettings.getLangString("msg_wait_locked"));
                }
            }
        }
    }

    private void townClaim(Town town, WorldCoord worldCoord, boolean bl) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            try {
                throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_already_claimed"), townBlock.getTown().getName()));
            }
            catch (NotRegisteredException notRegisteredException) {
                throw new AlreadyRegisteredException(TownySettings.getLangString("msg_already_claimed_2"));
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            TownBlock townBlock = worldCoord.getTownyWorld().newTownBlock(worldCoord);
            townBlock.setTown(town);
            if (!town.hasHomeBlock()) {
                town.setHomeBlock(townBlock);
            }
            townBlock.setType(townBlock.getType());
            if (bl) {
                townBlock.setOutpost(bl);
                town.addOutpostSpawn(this.outpostLocation);
            }
            if (town.getWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
                PlotBlockData plotBlockData = TownyRegenAPI.getPlotChunk(townBlock);
                if (plotBlockData != null) {
                    TownyRegenAPI.deletePlotChunk(plotBlockData);
                    townBlock.setLocked(false);
                } else {
                    TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
                    townBlock.setLocked(true);
                }
                plotBlockData = null;
            }
            TownyUniverse.getDataSource().saveTownBlock(townBlock);
            return;
        }
    }

    private void townUnclaim(Town town, WorldCoord worldCoord, boolean bl) throws TownyException {
        try {
            final TownBlock townBlock = worldCoord.getTownBlock();
            if (town != townBlock.getTown() && !bl) {
                throw new TownyException(TownySettings.getLangString("msg_area_not_own"));
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    TownyUniverse.getDataSource().removeTownBlock(townBlock);
                }
            }, 1L);
        }
        catch (NotRegisteredException notRegisteredException) {
            throw new TownyException(TownySettings.getLangString("msg_not_claimed_1"));
        }
    }

    private void townUnclaimAll(final Town town) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                TownyUniverse.getDataSource().removeTownBlocks(town);
                TownyMessaging.sendTownMessage(town, TownySettings.getLangString("msg_abandoned_area_1"));
            }
        }, 1L);
    }
}

