/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;

public class AreaSelectionUtil {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<WorldCoord> selectWorldCoordArea(TownBlockOwner townBlockOwner, WorldCoord worldCoord, String[] stringArray) throws TownyException {
        void var3_8;
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        if (stringArray.length == 0) {
            if (!worldCoord.getTownyWorld().isClaimable()) throw new TownyException(TownySettings.getLangString("msg_not_claimable"));
            arrayList.add(worldCoord);
            return var3_8;
        }
        if (stringArray.length > 1) {
            if (stringArray[0].equalsIgnoreCase("rect")) {
                List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaRect(townBlockOwner, worldCoord, StringMgmt.remFirstArg(stringArray));
                return var3_8;
            } else {
                if (!stringArray[0].equalsIgnoreCase("circle")) throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), StringMgmt.join(stringArray, " ")));
                List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaCircle(townBlockOwner, worldCoord, StringMgmt.remFirstArg(stringArray));
            }
            return var3_8;
        }
        if (stringArray[0].equalsIgnoreCase("auto")) {
            List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaRect(townBlockOwner, worldCoord, stringArray);
            return var3_8;
        }
        try {
            Integer.parseInt(stringArray[0]);
            List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaRect(townBlockOwner, worldCoord, stringArray);
            return var3_8;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), stringArray[0]));
        }
    }

    public static List<WorldCoord> selectWorldCoordAreaRect(TownBlockOwner townBlockOwner, WorldCoord worldCoord, String[] stringArray) throws TownyException {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        if (worldCoord.getTownyWorld().isClaimable()) {
            if (stringArray.length > 0) {
                int n = 0;
                int n2 = 0;
                if (townBlockOwner instanceof Town) {
                    Town town = (Town)townBlockOwner;
                    n2 = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
                } else if (townBlockOwner instanceof Resident) {
                    n2 = TownySettings.getMaxResidentPlots((Resident)townBlockOwner);
                }
                if (stringArray[0].equalsIgnoreCase("auto")) {
                    while ((double)n2 - Math.pow((n + 1) * 2 - 1, 2.0) >= 0.0) {
                        ++n;
                    }
                } else {
                    try {
                        n = Integer.parseInt(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
                    }
                }
                if (n > 1000) {
                    n = 1000;
                }
                for (int i = -n; i <= n; ++i) {
                    for (int j = -n; j <= n; ++j) {
                        if (arrayList.size() >= n2) continue;
                        arrayList.add(new WorldCoord(worldCoord.getWorldName(), worldCoord.getX() + j, worldCoord.getZ() + i));
                    }
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
            }
        }
        return arrayList;
    }

    public static List<WorldCoord> selectWorldCoordAreaCircle(TownBlockOwner townBlockOwner, WorldCoord worldCoord, String[] stringArray) throws TownyException {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        if (worldCoord.getTownyWorld().isClaimable()) {
            if (stringArray.length > 0) {
                int n = 0;
                int n2 = 0;
                if (townBlockOwner instanceof Town) {
                    Town town = (Town)townBlockOwner;
                    n2 = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
                } else if (townBlockOwner instanceof Resident) {
                    n2 = TownySettings.getMaxResidentPlots((Resident)townBlockOwner);
                }
                if (stringArray[0].equalsIgnoreCase("auto")) {
                    if (n2 > 0) {
                        while ((double)n2 - Math.ceil(Math.PI * (double)n * (double)n) >= 0.0) {
                            ++n;
                        }
                    }
                } else {
                    try {
                        n = Integer.parseInt(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
                    }
                }
                if (n > 1000) {
                    n = 1000;
                }
                for (int i = -n; i <= n; ++i) {
                    for (int j = -n; j <= n; ++j) {
                        if (j * j + i * i > n * n || arrayList.size() >= n2) continue;
                        arrayList.add(new WorldCoord(worldCoord.getWorldName(), worldCoord.getX() + j, worldCoord.getZ() + i));
                    }
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
            }
        }
        return arrayList;
    }

    public static List<WorldCoord> filterTownOwnedBlocks(List<WorldCoord> list) {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : list) {
            try {
                if (worldCoord.getTownBlock().hasTown()) continue;
                arrayList.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {
                arrayList.add(worldCoord);
            }
        }
        return arrayList;
    }

    public static List<WorldCoord> filterOwnedBlocks(TownBlockOwner townBlockOwner, List<WorldCoord> list) {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : list) {
            try {
                if (!worldCoord.getTownBlock().isOwner(townBlockOwner)) continue;
                arrayList.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return arrayList;
    }

    public static List<WorldCoord> filterPlotsForSale(List<WorldCoord> list) {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : list) {
            try {
                if (!worldCoord.getTownBlock().isForSale()) continue;
                arrayList.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return arrayList;
    }

    public static List<WorldCoord> filterPlotsNotForSale(List<WorldCoord> list) {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : list) {
            try {
                if (!worldCoord.getTownBlock().isForSale()) continue;
                arrayList.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return arrayList;
    }

    public static List<WorldCoord> filterUnownedPlots(List<WorldCoord> list) {
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : list) {
            try {
                if (!(worldCoord.getTownBlock().getPlotPrice() > -1.0)) continue;
                arrayList.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return arrayList;
    }

    public static int getAreaSelectPivot(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("within")) continue;
            return i;
        }
        return -1;
    }

    public static boolean isOnEdgeOfOwnership(TownBlockOwner townBlockOwner, WorldCoord worldCoord) {
        int[][] nArrayArray = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        for (int i = 0; i < 4; ++i) {
            try {
                TownBlock townBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + nArrayArray[i][0], worldCoord.getZ() + nArrayArray[i][1]));
                if (townBlock.isOwner(townBlockOwner)) continue;
                return true;
            }
            catch (NotRegisteredException notRegisteredException) {
                return true;
            }
        }
        return false;
    }
}

