/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayerCacheUtil {
    static Towny plugin = null;

    public static void initialize(Towny towny) {
        plugin = towny;
    }

    @Deprecated
    public static boolean getCachePermission(Player player, Location location, Integer n, TownyPermission.ActionType actionType) {
        return PlayerCacheUtil.getCachePermission(player, location, n, (byte)0, actionType);
    }

    public static boolean getCachePermission(Player player, Location location, Integer n, byte by, TownyPermission.ActionType actionType) {
        try {
            WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache playerCache = plugin.getCache(player);
            playerCache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("Cache permissions for " + actionType.toString() + " : " + playerCache.getCachePermission(n, by, actionType));
            return playerCache.getCachePermission(n, by, actionType);
        }
        catch (NullPointerException nullPointerException) {
            WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache.TownBlockStatus townBlockStatus = PlayerCacheUtil.cacheStatus(player, worldCoord, PlayerCacheUtil.getTownBlockStatus(player, worldCoord));
            PlayerCacheUtil.triggerCacheCreate(player, location, worldCoord, townBlockStatus, n, by, actionType);
            PlayerCache playerCache = plugin.getCache(player);
            playerCache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("New Cache Created and updated!");
            TownyMessaging.sendDebugMsg("New Cache permissions for " + n + ":" + actionType.toString() + " = " + playerCache.getCachePermission(n, by, actionType));
            return playerCache.getCachePermission(n, by, actionType);
        }
    }

    private static void triggerCacheCreate(Player player, Location location, WorldCoord worldCoord, PlayerCache.TownBlockStatus townBlockStatus, Integer n, byte by, TownyPermission.ActionType actionType) {
        switch (actionType) {
            case BUILD: {
                PlayerCacheUtil.cacheBuild(player, worldCoord, n, by, PlayerCacheUtil.getPermission(player, townBlockStatus, worldCoord, n, by, actionType));
                return;
            }
            case DESTROY: {
                PlayerCacheUtil.cacheDestroy(player, worldCoord, n, by, PlayerCacheUtil.getPermission(player, townBlockStatus, worldCoord, n, by, actionType));
                return;
            }
            case SWITCH: {
                PlayerCacheUtil.cacheSwitch(player, worldCoord, n, by, PlayerCacheUtil.getPermission(player, townBlockStatus, worldCoord, n, by, actionType));
                return;
            }
            case ITEM_USE: {
                PlayerCacheUtil.cacheItemUse(player, worldCoord, n, by, PlayerCacheUtil.getPermission(player, townBlockStatus, worldCoord, n, by, actionType));
                return;
            }
        }
    }

    public static PlayerCache.TownBlockStatus cacheStatus(Player player, WorldCoord worldCoord, PlayerCache.TownBlockStatus townBlockStatus) {
        PlayerCache playerCache = plugin.getCache(player);
        playerCache.updateCoord(worldCoord);
        playerCache.setStatus(townBlockStatus);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Status: " + (Object)((Object)townBlockStatus));
        return townBlockStatus;
    }

    private static void cacheBuild(Player player, WorldCoord worldCoord, Integer n, byte by, Boolean bl) {
        PlayerCache playerCache = plugin.getCache(player);
        playerCache.updateCoord(worldCoord);
        playerCache.setBuildPermission(n, by, bl);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Build: " + bl);
    }

    private static void cacheDestroy(Player player, WorldCoord worldCoord, Integer n, byte by, Boolean bl) {
        PlayerCache playerCache = plugin.getCache(player);
        playerCache.updateCoord(worldCoord);
        playerCache.setDestroyPermission(n, by, bl);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Destroy: " + bl);
    }

    private static void cacheSwitch(Player player, WorldCoord worldCoord, Integer n, byte by, Boolean bl) {
        PlayerCache playerCache = plugin.getCache(player);
        playerCache.updateCoord(worldCoord);
        playerCache.setSwitchPermission(n, by, bl);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Switch: " + bl);
    }

    private static void cacheItemUse(Player player, WorldCoord worldCoord, Integer n, byte by, Boolean bl) {
        PlayerCache playerCache = plugin.getCache(player);
        playerCache.updateCoord(worldCoord);
        playerCache.setItemUsePermission(n, by, bl);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Item Use: " + bl);
    }

    public static void cacheBlockErrMsg(Player player, String string) {
        PlayerCache playerCache = plugin.getCache(player);
        playerCache.setBlockErrMsg(string);
    }

    public static PlayerCache.TownBlockStatus getTownBlockStatus(Player player, WorldCoord worldCoord) {
        Resident resident;
        Town town;
        TownBlock townBlock;
        try {
            if (!worldCoord.getTownyWorld().isUsingTowny()) {
                return PlayerCache.TownBlockStatus.OFF_WORLD;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return PlayerCache.TownBlockStatus.NOT_REGISTERED;
        }
        try {
            townBlock = worldCoord.getTownBlock();
            town = townBlock.getTown();
            if (townBlock.isLocked()) {
                if (town.getWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
                    TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
                    return PlayerCache.TownBlockStatus.LOCKED;
                }
                townBlock.setLocked(false);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (TownyException townyException) {
            System.out.print("Failed to fetch resident: " + player.getName());
            return PlayerCache.TownBlockStatus.NOT_REGISTERED;
        }
        try {
            if (TownyUniverse.isWarTime()) {
                if (TownySettings.isAllowWarBlockGriefing()) {
                    try {
                        if (!resident.getTown().getNation().isNeutral() && !town.getNation().isNeutral()) {
                            return PlayerCache.TownBlockStatus.WARZONE;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                if (!TownySettings.isWarTimeTownsNeutral() && !town.hasNation()) {
                    return PlayerCache.TownBlockStatus.WARZONE;
                }
            }
            try {
                if (townBlock.getTown().isMayor(resident) || townBlock.getTown().hasAssistant(resident)) {
                    return PlayerCache.TownBlockStatus.TOWN_OWNER;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                Resident resident2 = townBlock.getResident();
                if (resident == resident2) {
                    return PlayerCache.TownBlockStatus.PLOT_OWNER;
                }
                if (resident2.hasFriend(resident)) {
                    return PlayerCache.TownBlockStatus.PLOT_FRIEND;
                }
                if (resident.hasTown() && CombatUtil.isAlly(resident2.getTown(), resident.getTown())) {
                    return PlayerCache.TownBlockStatus.PLOT_ALLY;
                }
                throw new TownyException();
            }
            catch (NotRegisteredException notRegisteredException) {
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            if (!resident.hasTown()) {
                if (townBlock.isWarZone()) {
                    if (!TownySettings.isWarTimeTownsNeutral()) {
                        return PlayerCache.TownBlockStatus.WARZONE;
                    }
                    return PlayerCache.TownBlockStatus.OUTSIDER;
                }
                throw new TownyException();
            }
            if (resident.getTown() != town) {
                if (CombatUtil.isAlly(town, resident.getTown())) {
                    return PlayerCache.TownBlockStatus.TOWN_ALLY;
                }
                if (CombatUtil.isEnemy(resident.getTown(), town)) {
                    if (townBlock.isWarZone()) {
                        return PlayerCache.TownBlockStatus.WARZONE;
                    }
                    return PlayerCache.TownBlockStatus.ENEMY;
                }
                return PlayerCache.TownBlockStatus.OUTSIDER;
            }
            if (resident.isMayor() || resident.getTown().hasAssistant(resident)) {
                return PlayerCache.TownBlockStatus.TOWN_OWNER;
            }
            return PlayerCache.TownBlockStatus.TOWN_RESIDENT;
        }
        catch (TownyException townyException) {
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
    }

    private static boolean getPermission(Player player, PlayerCache.TownBlockStatus townBlockStatus, WorldCoord worldCoord, Integer n, byte by, TownyPermission.ActionType actionType) {
        if (townBlockStatus == PlayerCache.TownBlockStatus.OFF_WORLD || townBlockStatus == PlayerCache.TownBlockStatus.WARZONE || townBlockStatus == PlayerCache.TownBlockStatus.PLOT_OWNER || townBlockStatus == PlayerCache.TownBlockStatus.TOWN_OWNER) {
            return true;
        }
        if (townBlockStatus == PlayerCache.TownBlockStatus.NOT_REGISTERED) {
            PlayerCacheUtil.cacheBlockErrMsg(player, TownySettings.getLangString("msg_cache_block_error"));
            return false;
        }
        if (townBlockStatus == PlayerCache.TownBlockStatus.LOCKED) {
            PlayerCacheUtil.cacheBlockErrMsg(player, TownySettings.getLangString("msg_cache_block_error_locked"));
            return false;
        }
        TownBlock townBlock = null;
        Town town = null;
        Town town2 = null;
        try {
            town = TownyUniverse.getDataSource().getResident(player.getName()).getTown();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            townBlock = worldCoord.getTownBlock();
            town2 = townBlock.getTown();
        }
        catch (NotRegisteredException notRegisteredException) {
            try {
                if (townBlockStatus == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                    if (TownyUniverse.getPermissionSource().hasWildOverride(worldCoord.getTownyWorld(), player, n, by, actionType)) {
                        return true;
                    }
                    PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_wild"), actionType.toString()));
                    return false;
                }
            }
            catch (NotRegisteredException notRegisteredException2) {
                TownyMessaging.sendErrorMsg((Object)player, "Error updating " + actionType.toString() + " permission.");
                return false;
            }
        }
        if (TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
            return true;
        }
        try {
            if (townBlock.getType() == TownBlockType.WILDS && TownyUniverse.getPermissionSource().hasWildOverride(worldCoord.getTownyWorld(), player, n, by, actionType)) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townBlock.hasResident()) {
            if (town2.equals(town) && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (!town2.equals(town) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (townBlockStatus == PlayerCache.TownBlockStatus.PLOT_FRIEND) {
                if (townBlock.getPermissions().getResidentPerm(actionType)) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_plot"), "friends", actionType.toString()));
                return false;
            }
            if (townBlockStatus == PlayerCache.TownBlockStatus.PLOT_ALLY) {
                if (townBlock.getPermissions().getAllyPerm(actionType)) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_plot"), "allies", actionType.toString()));
                return false;
            }
            if (townBlock.getPermissions().getOutsiderPerm(actionType)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_plot"), "outsiders", actionType.toString()));
            return false;
        }
        if (townBlockStatus == PlayerCache.TownBlockStatus.TOWN_RESIDENT) {
            if (town2.equals(town) && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (!town2.equals(town) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (townBlock.getPermissions().getResidentPerm(actionType)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_town_resident"), actionType.toString()));
            return false;
        }
        if (townBlockStatus == PlayerCache.TownBlockStatus.TOWN_ALLY) {
            if (town2.equals(town) && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (!town2.equals(town) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (townBlock.getPermissions().getAllyPerm(actionType)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_town_allies"), actionType.toString()));
            return false;
        }
        if (townBlockStatus == PlayerCache.TownBlockStatus.OUTSIDER || townBlockStatus == PlayerCache.TownBlockStatus.ENEMY) {
            if (TownyUniverse.getPermissionSource().hasAllTownOverride(player, n, by, actionType)) {
                return true;
            }
            if (townBlock.getPermissions().getOutsiderPerm(actionType)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_town_outsider"), actionType.toString()));
            return false;
        }
        TownyMessaging.sendErrorMsg((Object)player, "Error updating " + actionType.toString() + " permission.");
        return false;
    }
}

