/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.war.flagwar.CellUnderAttack;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import org.bukkit.Location;

public class Cell {
    private String worldName;
    private int x;
    private int z;

    public Cell(String string, int n, int n2) {
        this.worldName = string;
        this.x = n;
        this.z = n2;
    }

    public Cell(Cell cell) {
        this.worldName = cell.getWorldName();
        this.x = cell.getX();
        this.z = cell.getZ();
    }

    public Cell(Location location) {
        this(Cell.parse(location));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String string) {
        this.worldName = string;
    }

    public static Cell parse(String string, int n, int n2) {
        int n3 = Coord.getCellSize();
        int n4 = n / n3;
        int n5 = n2 / n3;
        boolean bl = n % n3 != 0;
        boolean bl2 = n2 % n3 != 0;
        return new Cell(string, n4 - (n < 0 && bl ? 1 : 0), n5 - (n2 < 0 && bl2 ? 1 : 0));
    }

    public static Cell parse(Location location) {
        return Cell.parse(location.getWorld().getName(), location.getBlockX(), location.getBlockZ());
    }

    public int hashCode() {
        int n = 17;
        n = n * 27 + (this.worldName == null ? 0 : this.worldName.hashCode());
        n = n * 27 + this.x;
        n = n * 27 + this.z;
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cell)) {
            return false;
        }
        Cell cell = (Cell)object;
        return this.x == cell.x && this.z == cell.z && (this.worldName == null ? cell.worldName == null : this.worldName.equals(cell.worldName));
    }

    public boolean isUnderAttack() {
        return TownyWar.isUnderAttack(this);
    }

    public CellUnderAttack getAttackData() {
        return TownyWar.getAttackData(this);
    }
}

