/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.war.flagwar.Cell;
import com.palmergames.bukkit.towny.war.flagwar.CellUnderAttack;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackCanceledEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellDefendedEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellWonEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class TownyWar {
    private static Map<Cell, CellUnderAttack> cellsUnderAttack;
    private static Map<String, List<CellUnderAttack>> cellsUnderAttackByPlayer;

    public static void onEnable() {
        cellsUnderAttack = new HashMap<Cell, CellUnderAttack>();
        cellsUnderAttackByPlayer = new HashMap<String, List<CellUnderAttack>>();
    }

    public static void onDisable() {
        for (CellUnderAttack cellUnderAttack : new ArrayList<CellUnderAttack>(cellsUnderAttack.values())) {
            TownyWar.attackCanceled(cellUnderAttack);
        }
    }

    public static void registerAttack(CellUnderAttack cellUnderAttack) throws Exception {
        CellUnderAttack cellUnderAttack2 = cellsUnderAttack.get(cellUnderAttack);
        if (cellUnderAttack2 != null) {
            throw new Exception(String.format(TownySettings.getLangString("msg_err_enemy_war_cell_already_under_attack"), cellUnderAttack2.getNameOfFlagOwner()));
        }
        String string = cellUnderAttack.getNameOfFlagOwner();
        int n = TownyWar.getNumActiveFlags(string) + 1;
        if (n > TownyWarConfig.getMaxActiveFlagsPerPerson()) {
            throw new Exception(String.format(TownySettings.getLangString("msg_err_enemy_war_reached_max_active_flags"), TownyWarConfig.getMaxActiveFlagsPerPerson()));
        }
        TownyWar.addFlagToPlayerCount(string, cellUnderAttack);
        cellsUnderAttack.put(cellUnderAttack, cellUnderAttack);
        cellUnderAttack.begin();
    }

    public static int getNumActiveFlags(String string) {
        List<CellUnderAttack> list = cellsUnderAttackByPlayer.get(string);
        return list == null ? 0 : list.size();
    }

    public static boolean isUnderAttack(Cell cell) {
        return cellsUnderAttack.containsKey(cell);
    }

    public static CellUnderAttack getAttackData(Cell cell) {
        return cellsUnderAttack.get(cell);
    }

    public static void removeCellUnderAttack(CellUnderAttack cellUnderAttack) {
        TownyWar.removeFlagFromPlayerCount(cellUnderAttack.getNameOfFlagOwner(), cellUnderAttack);
        cellsUnderAttack.remove(cellUnderAttack);
    }

    public static void attackWon(CellUnderAttack cellUnderAttack) {
        CellWonEvent cellWonEvent = new CellWonEvent(cellUnderAttack);
        Bukkit.getServer().getPluginManager().callEvent((Event)cellWonEvent);
        cellUnderAttack.cancel();
        TownyWar.removeCellUnderAttack(cellUnderAttack);
    }

    public static void attackDefended(Player player, CellUnderAttack cellUnderAttack) {
        CellDefendedEvent cellDefendedEvent = new CellDefendedEvent(player, cellUnderAttack);
        Bukkit.getServer().getPluginManager().callEvent((Event)cellDefendedEvent);
        cellUnderAttack.cancel();
        TownyWar.removeCellUnderAttack(cellUnderAttack);
    }

    public static void attackCanceled(CellUnderAttack cellUnderAttack) {
        CellAttackCanceledEvent cellAttackCanceledEvent = new CellAttackCanceledEvent(cellUnderAttack);
        Bukkit.getServer().getPluginManager().callEvent((Event)cellAttackCanceledEvent);
        cellUnderAttack.cancel();
        TownyWar.removeCellUnderAttack(cellUnderAttack);
    }

    public static void removeAttackerFlags(String string) {
        List<CellUnderAttack> list = cellsUnderAttackByPlayer.get(string);
        if (list != null) {
            for (CellUnderAttack cellUnderAttack : list) {
                TownyWar.attackCanceled(cellUnderAttack);
            }
        }
    }

    public static List<CellUnderAttack> getCellsUnderAttackByPlayer(String string) {
        List<CellUnderAttack> list = cellsUnderAttackByPlayer.get(string);
        if (list == null) {
            return null;
        }
        return new ArrayList<CellUnderAttack>(list);
    }

    private static void addFlagToPlayerCount(String string, CellUnderAttack cellUnderAttack) {
        List<CellUnderAttack> list = TownyWar.getCellsUnderAttackByPlayer(string);
        if (list == null) {
            list = new ArrayList<CellUnderAttack>();
        }
        list.add(cellUnderAttack);
        cellsUnderAttackByPlayer.put(string, list);
    }

    private static void removeFlagFromPlayerCount(String string, Cell cell) {
        List<CellUnderAttack> list = cellsUnderAttackByPlayer.get(string);
        if (list != null) {
            if (list.size() <= 1) {
                cellsUnderAttackByPlayer.remove(string);
            } else {
                list.remove(cell);
                cellsUnderAttackByPlayer.put(string, list);
            }
        }
    }

    public static void checkBlock(Player player, Block block, Cancellable cancellable) {
        Cell cell;
        if (TownyWarConfig.isAffectedMaterial(block.getType()) && (cell = Cell.parse(block.getLocation())).isUnderAttack()) {
            CellUnderAttack cellUnderAttack = cell.getAttackData();
            if (cellUnderAttack.isFlag(block)) {
                TownyWar.attackDefended(player, cellUnderAttack);
                cancellable.setCancelled(true);
            } else if (cellUnderAttack.isUneditableBlock(block)) {
                cancellable.setCancelled(true);
            }
        }
    }

    public static boolean callAttackCellEvent(Towny towny, Player player, Block block, WorldCoord worldCoord) throws TownyException {
        Nation nation;
        TownBlock townBlock;
        Town town;
        Nation nation2;
        Town town2;
        Resident resident;
        int n = block.getWorld().getHighestBlockYAt(block.getX(), block.getZ()) - 1;
        if (block.getY() < n) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_must_be_placed_above_ground"));
        }
        TownyUniverse townyUniverse = towny.getTownyUniverse();
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town2 = resident.getTown();
            nation2 = town2.getNation();
        }
        catch (NotRegisteredException notRegisteredException) {
            throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_nation"));
        }
        try {
            town = worldCoord.getTownBlock().getTown();
            townBlock = worldCoord.getTownBlock();
            nation = town.getNation();
        }
        catch (NotRegisteredException notRegisteredException) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_not_part_of_nation"));
        }
        if (nation.isNeutral()) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_is_neutral"), nation.getFormattedName()));
        }
        if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && nation2.isNeutral()) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_is_neutral"), nation2.getFormattedName()));
        }
        TownyWar.checkIfTownHasMinOnlineForWar(town);
        TownyWar.checkIfNationHasMinOnlineForWar(nation);
        TownyWar.checkIfTownHasMinOnlineForWar(town2);
        TownyWar.checkIfNationHasMinOnlineForWar(nation2);
        if (TownyWarConfig.isAttackingBordersOnly() && !AreaSelectionUtil.isOnEdgeOfOwnership(town, worldCoord)) {
            throw new TownyException(TownySettings.getLangString("msg_err_enemy_war_not_on_edge_of_town"));
        }
        double d = TownyWarConfig.getCostToPlaceWarFlag();
        if (TownySettings.isUsingEconomy()) {
            try {
                double d2 = d;
                double d3 = resident.getHoldingBalance();
                if (d3 < d) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_insuficient_funds_warflag"), TownyEconomyHandler.getFormattedBalance(d)));
                }
                int n2 = TownyWar.getNumActiveFlags(resident.getName());
                double d4 = TownyWarConfig.getDefendedAttackReward() * (double)(n2 + 1);
                double d5 = 0.0;
                double d6 = TownyWarConfig.getWonHomeblockReward();
                double d7 = d6 < 0.0 ? -d6 : 0.0;
                d6 = TownyWarConfig.getWonTownblockReward();
                double d8 = d6 < 0.0 ? -d6 : 0.0;
                d5 = townBlock.isHomeBlock() ? d7 + (double)n2 * d8 : (double)(n2 + 1) * d8;
                if (d4 > 0.0 && d5 > 0.0) {
                    String string;
                    double d9;
                    if (d4 > d5) {
                        d2 += d4;
                        d9 = d4;
                        string = TownySettings.getLangString("name_defended_attack");
                    } else {
                        d2 += d5;
                        d9 = d5;
                        string = TownySettings.getLangString("name_rebuilding");
                    }
                    if (d3 < d2) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_insuficient_funds_future"), TownyEconomyHandler.getFormattedBalance(d9), String.format("%d %s", n2 + 1, string + "(s)")));
                    }
                }
            }
            catch (EconomyException economyException) {
                throw new TownyException(economyException.getError());
            }
        }
        CellAttackEvent cellAttackEvent = new CellAttackEvent(towny, player, block);
        towny.getServer().getPluginManager().callEvent((Event)cellAttackEvent);
        if (cellAttackEvent.isCancelled()) {
            if (cellAttackEvent.hasReason()) {
                throw new TownyException(cellAttackEvent.getReason());
            }
            return false;
        }
        if (TownySettings.isUsingEconomy() && d > 0.0) {
            try {
                resident.pay(d, "War - WarFlag Cost");
                TownyMessaging.sendResidentMessage(resident, String.format(TownySettings.getLangString("msg_enemy_war_purchased_warflag"), TownyEconomyHandler.getFormattedBalance(d)));
            }
            catch (EconomyException economyException) {
                economyException.printStackTrace();
            }
        }
        if (!nation.hasEnemy(nation2)) {
            nation.addEnemy(nation2);
            towny.getTownyUniverse();
            TownyUniverse.getDataSource().saveNation(nation);
        }
        townyUniverse.addWarZone(worldCoord);
        towny.updateCache(worldCoord);
        TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_under_attack"), town.getFormattedName(), worldCoord.toString(), resident.getFormattedName()));
        return true;
    }

    public static void checkIfTownHasMinOnlineForWar(Town town) throws TownyException {
        int n = TownyWarConfig.getMinPlayersOnlineInTownForWar();
        int n2 = TownyUniverse.getOnlinePlayers(town).size();
        if (n2 < n) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_require_online"), n, town.getFormattedName()));
        }
    }

    public static void checkIfNationHasMinOnlineForWar(Nation nation) throws TownyException {
        int n = TownyWarConfig.getMinPlayersOnlineInNationForWar();
        int n2 = TownyUniverse.getOnlinePlayers(nation).size();
        if (n2 < n) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_enemy_war_require_online"), n, nation.getFormattedName()));
        }
    }

    public static WorldCoord cellToWorldCoord(Cell cell) throws NotRegisteredException {
        return new WorldCoord(cell.getWorldName(), cell.getX(), cell.getZ());
    }
}

