/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.war.flagwar.CellUnderAttack;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackCanceledEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellAttackEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellDefendedEvent;
import com.palmergames.bukkit.towny.war.flagwar.events.CellWonEvent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class TownyWarCustomListener
implements Listener {
    private final Towny plugin;

    public TownyWarCustomListener(Towny towny) {
        this.plugin = towny;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellAttackEvent(CellAttackEvent cellAttackEvent) {
        try {
            CellUnderAttack cellUnderAttack = cellAttackEvent.getData();
            TownyWar.registerAttack(cellUnderAttack);
        }
        catch (Exception exception) {
            cellAttackEvent.setCancelled(true);
            cellAttackEvent.setReason(exception.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellDefendedEvent(CellDefendedEvent cellDefendedEvent) {
        block19: {
            String string;
            Player player = cellDefendedEvent.getPlayer();
            CellUnderAttack cellUnderAttack = cellDefendedEvent.getCell().getAttackData();
            TownyUniverse townyUniverse = this.plugin.getTownyUniverse();
            WorldCoord worldCoord = new WorldCoord(cellUnderAttack.getWorldName(), cellUnderAttack.getX(), cellUnderAttack.getZ());
            townyUniverse.removeWarZone(worldCoord);
            this.plugin.updateCache(worldCoord);
            if (player == null) {
                string = "Greater Forces";
            } else {
                string = player.getName();
                try {
                    string = TownyUniverse.getDataSource().getResident(player.getName()).getFormattedName();
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
            }
            this.plugin.getServer().broadcastMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_defended"), string, cellUnderAttack.getCellString()));
            if (TownySettings.isUsingEconomy()) {
                try {
                    Resident resident = null;
                    Resident resident2 = TownyUniverse.getDataSource().getResident(cellUnderAttack.getNameOfFlagOwner());
                    if (player != null) {
                        try {
                            resident = TownyUniverse.getDataSource().getResident(player.getName());
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                    }
                    String string2 = TownyEconomyHandler.getFormattedBalance(TownyWarConfig.getDefendedAttackReward());
                    if (resident == null) {
                        if (resident2.pay(TownyWarConfig.getDefendedAttackReward(), "War - Attack Was Defended (Greater Forces)")) {
                            try {
                                TownyMessaging.sendResidentMessage(resident2, String.format(TownySettings.getLangString("msg_enemy_war_area_defended_greater_forces"), string2));
                            }
                            catch (TownyException townyException) {}
                        }
                        break block19;
                    }
                    if (!resident2.payTo(TownyWarConfig.getDefendedAttackReward(), resident, "War - Attack Was Defended")) break block19;
                    try {
                        TownyMessaging.sendResidentMessage(resident2, String.format(TownySettings.getLangString("msg_enemy_war_area_defended_attacker"), resident.getFormattedName(), string2));
                    }
                    catch (TownyException townyException) {
                        // empty catch block
                    }
                    try {
                        TownyMessaging.sendResidentMessage(resident, String.format(TownySettings.getLangString("msg_enemy_war_area_defended_defender"), resident2.getFormattedName(), string2));
                    }
                    catch (TownyException townyException) {}
                }
                catch (EconomyException economyException) {
                    economyException.printStackTrace();
                }
                catch (NotRegisteredException notRegisteredException) {
                    notRegisteredException.printStackTrace();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellWonEvent(CellWonEvent cellWonEvent) {
        block15: {
            CellUnderAttack cellUnderAttack = cellWonEvent.getCellAttackData();
            TownyUniverse townyUniverse = this.plugin.getTownyUniverse();
            try {
                Object object;
                Resident resident = TownyUniverse.getDataSource().getResident(cellUnderAttack.getNameOfFlagOwner());
                Town town = resident.getTown();
                Nation nation = town.getNation();
                WorldCoord worldCoord = TownyWar.cellToWorldCoord(cellUnderAttack);
                townyUniverse.removeWarZone(worldCoord);
                TownBlock townBlock = worldCoord.getTownBlock();
                Town town2 = townBlock.getTown();
                double d = 0.0;
                String string = null;
                if (TownySettings.isUsingEconomy()) {
                    try {
                        if (townBlock.isHomeBlock()) {
                            d = TownyWarConfig.getWonHomeblockReward();
                            object = "Homeblock";
                        } else {
                            d = TownyWarConfig.getWonTownblockReward();
                            object = "Townblock";
                        }
                        if (d > 0.0) {
                            String string2 = String.format("War - Won Enemy %s (Pillage)", object);
                            d = Math.min(d, town2.getHoldingBalance());
                            town2.payTo(d, resident, string2);
                            string = String.format(TownySettings.getLangString("msg_enemy_war_area_won_pillage"), resident.getFormattedName(), TownyEconomyHandler.getFormattedBalance(d), town2.getFormattedName());
                        } else if (d < 0.0) {
                            String string3 = String.format("War - Won Enemy %s (Rebuild Cost)", object);
                            if (!resident.payTo(d = -d, town2, string3)) {
                                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_won"), resident.getFormattedName(), nation.hasTag() ? nation.getTag() : nation.getFormattedName(), cellUnderAttack.getCellString()));
                            }
                            string = String.format(TownySettings.getLangString("msg_enemy_war_area_won_rebuilding"), resident.getFormattedName(), TownyEconomyHandler.getFormattedBalance(d), town2.getFormattedName());
                        }
                    }
                    catch (EconomyException economyException) {
                        economyException.printStackTrace();
                    }
                }
                TownyUniverse.getDataSource().removeTownBlock(townBlock);
                try {
                    object = new ArrayList();
                    object.add(worldCoord);
                    TownCommand.checkIfSelectionIsValid(town, (List<WorldCoord>)object, false, 0.0, false);
                    new TownClaim(this.plugin, null, town, (List<WorldCoord>)object, false, true, false).start();
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
                this.plugin.updateCache(worldCoord);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_enemy_war_area_won"), resident.getFormattedName(), nation.hasTag() ? nation.getTag() : nation.getFormattedName(), cellUnderAttack.getCellString()));
                if (!TownySettings.isUsingEconomy() || d == 0.0 || string == null) break block15;
                try {
                    TownyMessaging.sendResidentMessage(resident, string);
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
                TownyMessaging.sendTownMessage(town2, string);
            }
            catch (NotRegisteredException notRegisteredException) {
                notRegisteredException.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCellAttackCanceledEvent(CellAttackCanceledEvent cellAttackCanceledEvent) {
        CellUnderAttack cellUnderAttack = cellAttackCanceledEvent.getCell();
        TownyUniverse townyUniverse = this.plugin.getTownyUniverse();
        WorldCoord worldCoord = new WorldCoord(cellUnderAttack.getWorldName(), cellUnderAttack.getX(), cellUnderAttack.getZ());
        townyUniverse.removeWarZone(worldCoord);
        this.plugin.updateCache(worldCoord);
        System.out.println(cellUnderAttack.getCellString());
    }
}

