/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.api.util.MapCalculable;
import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.api.util.RecursiveGroupException;
import de.bananaco.bpermissions.imp.Debugger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiLayer {
    private static WorldManager wm = WorldManager.getInstance();

    public static String[] getGroups(String world, CalculableType type, String name) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null) {
            return new String[0];
        }
        Calculable c = w.get(name, type);
        List<String> g = c.serialiseGroups();
        String[] groups = g.toArray(new String[g.size()]);
        return groups;
    }

    public static Permission[] getPermissions(String world, CalculableType type, String name) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null) {
            return new Permission[0];
        }
        Calculable c = w.get(name, type);
        Set<Permission> p = c.getPermissions();
        Permission[] permissions = p.toArray(new Permission[p.size()]);
        return permissions;
    }

    public static synchronized Map<String, Boolean> getEffectivePermissions(String world, CalculableType type, String name) {
        World w;
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        World global = wm.getUseGlobalFiles() ? wm.getDefaultWorld() : null;
        World world2 = w = world == null ? null : wm.getWorld(world);
        if (global != null) {
            try {
                global.get(name, type).calculateEffectivePermissions();
            }
            catch (RecursiveGroupException e) {
                e.printStackTrace();
            }
            permissions.putAll(((MapCalculable)global.get(name, type)).getMappedPermissions());
        }
        if (w != null) {
            try {
                w.get(name, type).calculateEffectivePermissions();
            }
            catch (RecursiveGroupException e) {
                e.printStackTrace();
            }
            permissions.putAll(((MapCalculable)w.get(name, type)).getMappedPermissions());
        }
        return permissions;
    }

    public static boolean update() {
        return wm.update();
    }

    public static String getValue(String world, CalculableType type, String name, String key) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || key == null) {
            return "";
        }
        Calculable c = w.get(name, type);
        String v = c.getEffectiveValue(key);
        if (v.equals("") && wm.getUseGlobalFiles()) {
            w = wm.getDefaultWorld();
            if (w == null) {
                return v;
            }
            c = w.get(name, type);
            v = c.getEffectiveValue(key);
        }
        return v;
    }

    public static void addGroup(String world, CalculableType type, String name, String groupToAdd) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || groupToAdd == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.addGroup(groupToAdd);
    }

    public static void setGroup(String world, CalculableType type, String name, String groupToAdd) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || groupToAdd == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.getGroupsAsString().clear();
        c.addGroup(groupToAdd);
    }

    public static void removeGroup(String world, CalculableType type, String name, String groupToRemove) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || groupToRemove == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.removeGroup(groupToRemove);
    }

    public static boolean hasGroup(String world, CalculableType type, String name, String group) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || group == null) {
            return false;
        }
        Calculable c = w.get(name, type);
        return c.hasGroup(group);
    }

    public static boolean hasGroupRecursive(String world, CalculableType type, String name, String group) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || group == null) {
            return false;
        }
        Calculable c = w.get(name, type);
        return c.hasGroupRecursive(group);
    }

    public static void addPermission(String world, CalculableType type, String name, Permission permissionToAdd) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || permissionToAdd == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.addPermission(permissionToAdd.name(), permissionToAdd.isTrue());
    }

    public static void removePermission(String world, CalculableType type, String name, String permissionToRemove) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || permissionToRemove == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.removePermission(permissionToRemove);
    }

    public static boolean hasPermission(String world, CalculableType type, String name, String node) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || node == null) {
            return false;
        }
        Calculable c = w.get(name, type);
        Debugger.log(String.valueOf(w.getName()) + ":" + type.name() + ":" + name + ":" + node);
        return c.hasPermission(node);
    }

    public static void setValue(String world, CalculableType type, String name, String key, String value) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || key == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.setValue(key, value);
    }
}

