/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.api.util.MapCalculable;
import de.bananaco.bpermissions.api.util.Permission;
import java.util.Map;
import java.util.Set;

public abstract class CalculableWrapper
extends MapCalculable {
    private WorldManager wm = WorldManager.getInstance();

    public CalculableWrapper(String name, Set<String> groups, Set<Permission> permissions, String world) {
        super(name, groups, permissions, world);
    }

    @Override
    public boolean hasPermission(String node) {
        node = node.toLowerCase();
        boolean allowed = this.internalHasPermission(node);
        return allowed;
    }

    private boolean internalHasPermission(String node) {
        Map<String, Boolean> perms = this.getMappedPermissions();
        if (perms.containsKey(node)) {
            return perms.get(node);
        }
        String permission = node;
        int index = permission.lastIndexOf(46);
        while (index >= 0) {
            String wildcard = String.valueOf(permission = permission.substring(0, index)) + ".*";
            if (perms.containsKey(wildcard)) {
                return perms.get(wildcard);
            }
            index = permission.lastIndexOf(46);
        }
        if (perms.containsKey("*")) {
            return perms.get("*");
        }
        return false;
    }

    @Override
    public void addGroup(String group) {
        super.addGroup(group);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void removeGroup(String group) {
        super.removeGroup(group);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void addPermission(String permission, boolean isTrue) {
        super.addPermission(permission, isTrue);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void removePermission(String permission) {
        super.removePermission(permission);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void setValue(String key, String value) {
        super.setValue(key, value);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    public void setCalculablesWithGroupDirty() {
        for (Calculable user : this.getWorldObject().getAll(CalculableType.USER)) {
            if (!user.hasGroupRecursive(this.getName())) continue;
            ((User)user).setDirty(true);
        }
        for (Calculable group : this.getWorldObject().getAll(CalculableType.GROUP)) {
            if (!group.hasGroupRecursive(this.getName())) continue;
            ((Group)group).setDirty(true);
        }
    }
}

