/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;

public abstract class World {
    private final Map<String, Group> groups;
    private final Map<String, User> users;
    private final String world;

    public World(String world) {
        this.world = world;
        this.users = new HashMap<String, User>();
        this.groups = new HashMap<String, Group>();
    }

    public abstract boolean load();

    public abstract boolean save();

    public boolean contains(String name, CalculableType type) {
        name = ChatColor.stripColor((String)name);
        name = name.toLowerCase();
        if (type == CalculableType.USER) {
            return this.users.containsKey(name);
        }
        if (type == CalculableType.GROUP) {
            return this.groups.containsKey(name);
        }
        return false;
    }

    public Group getGroup(String name) {
        name = ChatColor.stripColor((String)name);
        return (Group)this.get(name, CalculableType.GROUP);
    }

    public User getUser(String name) {
        name = ChatColor.stripColor((String)name);
        return (User)this.get(name, CalculableType.USER);
    }

    public Calculable get(String name, CalculableType type) {
        name = ChatColor.stripColor((String)name);
        name = name.toLowerCase();
        if (type == CalculableType.USER) {
            if (!this.users.containsKey(name)) {
                this.add(new User(name, null, null, this.getName(), this));
                this.users.get(name).addGroup(this.getDefaultGroup());
            }
            return this.users.get(name);
        }
        if (type == CalculableType.GROUP) {
            if (!this.groups.containsKey(name)) {
                this.add(new Group(name, null, null, this.getName(), this));
            }
            return this.groups.get(name);
        }
        return null;
    }

    public Set<Calculable> getAll(CalculableType type) {
        HashSet<Calculable> entries = new HashSet<Calculable>();
        if (type == CalculableType.USER) {
            for (String key : this.users.keySet()) {
                entries.add(this.users.get(key));
            }
            return entries;
        }
        if (type == CalculableType.GROUP) {
            for (String key : this.groups.keySet()) {
                entries.add(this.groups.get(key));
            }
            return entries;
        }
        return entries;
    }

    public void add(Calculable calculable) {
        if (calculable.getType() == CalculableType.USER) {
            this.users.put(calculable.getNameLowerCase(), (User)calculable);
        } else if (calculable.getType() == CalculableType.GROUP) {
            this.groups.put(calculable.getNameLowerCase(), (Group)calculable);
        } else {
            System.err.println("Calculable not instance of User or Group!");
        }
    }

    public String getName() {
        return this.world;
    }

    public void clear() {
        this.groups.clear();
        this.users.clear();
    }

    public boolean equalsWorld(String world) {
        return world.equalsIgnoreCase(this.world);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    protected void cleanup() {
        ArrayList<String> removal = new ArrayList<String>();
        for (String user : this.users.keySet()) {
            User u = this.users.get(user);
            if (u.getMeta().size() != 0 || u.getPermissions().size() != 0 || u.getGroupsAsString().size() != 0 && (u.getGroupsAsString().size() != 1 || !u.getGroupsAsString().iterator().next().equals(this.getDefaultGroup()))) continue;
            removal.add(user);
        }
        for (String user : removal) {
            this.users.remove(user);
        }
        removal.clear();
        for (String group : this.groups.keySet()) {
            Group g = this.groups.get(group);
            if (g.getMeta().size() != 0 || g.getPermissions().size() != 0 || g.getGroupsAsString().size() != 0) continue;
            removal.add(group);
        }
        for (String group : removal) {
            this.groups.remove(group);
        }
        this.save();
    }

    public abstract void setDefaultGroup(String var1);

    public abstract String getDefaultGroup();

    public abstract boolean setupPlayer(String var1);

    public boolean setupAll() {
        return false;
    }

    public boolean isOnline(User user) {
        return false;
    }
}

