/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api.util;

import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.util.CalculableMeta;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.api.util.RecursiveGroupException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class Calculable
extends CalculableMeta {
    Set<Permission> effectivePermissions;
    String name;

    public Calculable(String name, Set<String> groups, Set<Permission> permissions, String world) {
        super(groups, permissions, world);
        this.name = name;
        this.effectivePermissions = new HashSet<Permission>();
    }

    protected void print() {
        Object[] perms = new String[this.effectivePermissions.size()];
        int i = 0;
        for (Permission perm : this.effectivePermissions) {
            if (perm == null) {
                System.err.println("PERM IS NULL?");
            } else {
                perms[i] = perm.isTrue() ? perm.name() : "^" + perm.name();
            }
            ++i;
        }
        System.out.println(String.valueOf(this.getName()) + ": " + Arrays.toString(perms));
    }

    public void calculateEffectivePermissions() throws RecursiveGroupException {
        if (!this.isDirty()) {
            return;
        }
        try {
            HashMap<String, Integer> priorities = new HashMap<String, Integer>();
            this.effectivePermissions.clear();
            for (String gr : this.serialiseGroups()) {
                Group group = this.getWorldObject().getGroup(gr);
                group.calculateEffectivePermissions();
                for (Permission perm : group.getEffectivePermissions()) {
                    if (priorities.containsKey(perm.nameLowerCase()) && (Integer)priorities.get(perm.nameLowerCase()) >= group.getPriority()) continue;
                    priorities.put(perm.nameLowerCase(), group.getPriority());
                    if (this.effectivePermissions.contains(perm)) {
                        this.effectivePermissions.remove(perm);
                    }
                    this.effectivePermissions.add(perm);
                }
            }
            priorities.clear();
            for (Permission perm : this.getPermissions()) {
                if (this.effectivePermissions.contains(perm)) {
                    this.effectivePermissions.remove(perm);
                }
                this.effectivePermissions.add(perm);
            }
        }
        catch (StackOverflowError e) {
            throw new RecursiveGroupException(this);
        }
    }

    public Set<Permission> getEffectivePermissions() {
        return this.effectivePermissions;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLowerCase() {
        return this.name.toLowerCase();
    }

    public int hashCode() {
        return this.getNameLowerCase().hashCode();
    }

    public String toString() {
        return this.name.toLowerCase();
    }

    public abstract CalculableType getType();

    protected abstract boolean isDirty();

    public abstract boolean hasPermission(String var1);

    protected abstract World getWorldObject();

    @Override
    public void clear() {
        this.effectivePermissions.clear();
        super.clear();
    }
}

