/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api.util;

import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.GroupCarrier;
import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.api.util.RecursiveGroupException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CalculableMeta
extends GroupCarrier {
    Map<String, String> effectiveMeta = new HashMap<String, String>();

    protected CalculableMeta(Set<String> groups, Set<Permission> permissions, String world) {
        super(groups, permissions, world);
    }

    @Override
    public void calculateEffectiveMeta() throws RecursiveGroupException {
        try {
            this.effectiveMeta.clear();
            HashMap<String, Integer> pr = new HashMap<String, Integer>();
            for (String gr : this.serialiseGroups()) {
                Group group = WorldManager.getInstance().getWorld(this.getWorld()).getGroup(gr);
                group.calculateEffectiveMeta();
                Map<String, String> meta = group.getEffectiveMeta();
                for (String key : meta.keySet()) {
                    if (pr.containsKey(key) && group.getPriority() <= (Integer)pr.get(key)) continue;
                    this.effectiveMeta.put(key, meta.get(key));
                    pr.put(key, group.getPriority());
                }
            }
            pr.clear();
            Map<String, String> meta = this.getMeta();
            for (String key : meta.keySet()) {
                this.effectiveMeta.put(key, meta.get(key));
            }
        }
        catch (StackOverflowError e) {
            throw new RecursiveGroupException(this);
        }
    }

    public Map<String, String> getEffectiveMeta() {
        return this.effectiveMeta;
    }

    public String getEffectiveValue(String key) {
        if (this.containsEffectiveValue(key)) {
            return this.effectiveMeta.get(key);
        }
        return "";
    }

    public boolean containsEffectiveValue(String key) {
        return this.effectiveMeta.containsKey(key);
    }

    @Override
    public void clear() {
        this.effectiveMeta.clear();
        super.clear();
    }
}

