/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api.util;

import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.api.util.RecursiveGroupException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MapCalculable
extends Calculable {
    boolean dirty = true;
    private final Map<String, Boolean> permissions = new HashMap<String, Boolean>();

    public MapCalculable(String name, Set<String> groups, Set<Permission> permissions, String world) {
        super(name, groups, permissions, world);
    }

    public Map<String, Boolean> getMappedPermissions() {
        if (this.isDirty()) {
            try {
                this.calculateEffectivePermissions();
            }
            catch (RecursiveGroupException e) {
                e.printStackTrace();
            }
        } else if (this.permissions.size() == 0) {
            try {
                this.dirty = true;
                this.calculateEffectivePermissions();
            }
            catch (RecursiveGroupException e) {
                e.printStackTrace();
            }
        }
        return this.permissions;
    }

    @Override
    public void calculateEffectivePermissions() throws RecursiveGroupException {
        if (!this.dirty) {
            return;
        }
        super.calculateEffectivePermissions();
        this.permissions.clear();
        for (Permission perm : this.getEffectivePermissions()) {
            this.permissions.put(perm.nameLowerCase(), perm.isTrue());
        }
        this.calculateEffectiveMeta();
        this.dirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void clear() {
        this.permissions.clear();
        super.clear();
        this.setDirty(true);
    }
}

