/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api.util;

import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.RecursiveGroupException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MetaData {
    private final Map<String, String> values = new HashMap<String, String>();
    private static final Comparator<Object> comparObj = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Calculable && o2 instanceof Calculable) {
                return comparGrp.compare((Calculable)o1, (Calculable)o2);
            }
            String f1 = o1.toString();
            String f2 = o2.toString();
            if (!(!f1.startsWith("^") && !f2.startsWith("^") || f1.startsWith("^") && f2.startsWith("^"))) {
                if (f1.startsWith("^")) {
                    return 1;
                }
                return -1;
            }
            int i = f1.length() > f2.length() ? f2.length() : f1.length();
            int n = 0;
            while (n < i - 1) {
                String b;
                String a = f1.substring(n, n + 1);
                if (a.compareTo(b = f2.substring(n, n + 1)) != 0) {
                    return a.compareTo(b);
                }
                ++n;
            }
            return f1.compareTo(f2);
        }
    };
    private static final Comparator<Calculable> comparGrp = new Comparator<Calculable>(){

        @Override
        public int compare(Calculable o1, Calculable o2) {
            if (o1.getPriority() > o2.getPriority()) {
                return -1;
            }
            if (o1.getPriority() < o2.getPriority()) {
                return 1;
            }
            return comparObj.compare(o1.toString(), o2.toString());
        }
    };
    private static boolean sort = true;

    public String getValue(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        return "";
    }

    public boolean contains(String key) {
        return this.values.containsKey(key);
    }

    public void setValue(String key, String value) {
        this.values.put(key, value);
        try {
            this.calculateEffectiveMeta();
        }
        catch (RecursiveGroupException e) {
            e.printStackTrace();
        }
    }

    public abstract void calculateEffectiveMeta() throws RecursiveGroupException;

    public Map<String, String> getMeta() {
        return this.values;
    }

    public void clearValues() {
        this.values.clear();
    }

    public static void sort(List<?> data) {
        if (data == null) {
            return;
        }
        if (data.size() == 0) {
            return;
        }
        if (!sort) {
            return;
        }
        List<?> d = data;
        Collections.sort(d, comparObj);
    }

    public static void sortGroups(List<Group> groups) {
        Collections.sort(groups, comparGrp);
    }

    public static void setSorting(boolean sorting) {
        sort = sorting;
    }

    public boolean getSorting() {
        return sort;
    }

    public int getPriority() {
        int priority = 0;
        try {
            if (this.getValue("priority") != null) {
                int p;
                priority = p = Integer.parseInt(this.getValue("priority"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return priority;
    }

    public void clear() {
        this.clearValues();
    }
}

