/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Permission {
    private final boolean isTrue;
    private final String name;

    public static Set<Permission> loadFromString(List<String> listPerms) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        if (listPerms != null) {
            for (String perm : listPerms) {
                permissions.add(Permission.loadFromString(perm));
            }
        }
        return permissions;
    }

    public static Permission loadFromString(String perm) {
        if (perm.startsWith("^")) {
            return new Permission(perm.replace("^", ""), false);
        }
        if (perm.startsWith("-")) {
            return new Permission(perm.replace("-", ""), false);
        }
        return new Permission(perm, true);
    }

    Permission(String name, boolean isTrue) {
        this.name = name;
        this.isTrue = isTrue;
    }

    public boolean isTrue() {
        return this.isTrue;
    }

    public String name() {
        return this.name;
    }

    public String nameLowerCase() {
        return this.name.toLowerCase();
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.isTrue;
    }

    public int hashCode() {
        return this.nameLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        return object.hashCode() == this.hashCode();
    }
}

