/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.fake;

import de.bananaco.bpermissions.fake.FakeMethods;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FakeYaml
extends FakeMethods {
    public static final String SPACER = "  ";

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("users:").append("\n");
        sb.append(SPACER).append("codename_B:").append("\n");
        sb.append(SPACER).append(SPACER).append("groups:").append("\n");
        sb.append(SPACER).append(SPACER).append("- awesome").append("\n");
        sb.append(SPACER).append(SPACER).append("- admin").append("\n");
        sb.append(SPACER).append(SPACER).append("permissions: [test, ib]").append("\n");
        sb.append(SPACER).append(SPACER).append("extra: []").append("\n");
        char[] ch = sb.toString().toCharArray();
        byte[] bt = new byte[ch.length];
        int i = 0;
        while (i < ch.length) {
            bt[i] = (byte)ch[i];
            ++i;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bt);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FakeYaml fml = new FakeYaml();
            fml.load(is);
            fml.save(os);
            bt = os.toByteArray();
            is = new ByteArrayInputStream(bt);
            fml.load(is);
            System.out.println(fml.data.toString());
            System.out.println(fml.getStringList("users.codename_B.permissions"));
            fml.set("users.codename_B.meta.prefix", "test");
            System.out.println(fml.getString("users.codename_B.meta.prefix"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void debug(FakeYaml fml) {
        System.out.println(fml.data.toString());
    }

    public void load(InputStream is) throws Exception {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        LinkedHashMap<String, Object> buffer = new LinkedHashMap<String, Object>();
        LinkedHashMap<Integer, String> nesting = new LinkedHashMap<Integer, String>();
        int i = 0;
        while (i < lines.size()) {
            String next;
            String line2 = (String)lines.get(i);
            Type type = this.getType(line2, next = i == lines.size() - 1 ? "" : (String)lines.get(i + 1));
            if (type == Type.PATH) {
                int n = this.getNesting(line2);
                if (n > 0) {
                    Map<String, Object> data = buffer;
                    int m = 0;
                    while (m < n) {
                        data = (Map)data.get(nesting.get(m));
                        ++m;
                    }
                    data.put(this.getKey(line2), new LinkedHashMap());
                } else {
                    buffer.put(this.getKey(line2), new LinkedHashMap());
                }
                nesting.put(n, this.getKey(line2));
            } else if (type == Type.EMPTYARRAY) {
                ArrayList array = new ArrayList();
                int n = this.getNesting(line2);
                if (n > 0) {
                    Map<String, Object> data = buffer;
                    int m = 0;
                    while (m < n) {
                        data = (Map)data.get(nesting.get(m));
                        ++m;
                    }
                    data.put(this.getKey(line2), array);
                } else {
                    buffer.put(this.getKey(line2), array);
                }
            } else if (type == Type.LINEARRAY) {
                int j = 1;
                ArrayList<String> array = new ArrayList<String>();
                while (j + i < lines.size()) {
                    String l = this.getLineFromArray((String)lines.get(i + j));
                    ++j;
                    if (l.isEmpty()) break;
                    array.add(l);
                }
                int n = this.getNesting(line2);
                if (n > 0) {
                    Map<String, Object> data = buffer;
                    int m = 0;
                    while (m < n) {
                        String nest = (String)nesting.get(m);
                        data = (Map)data.get(nest);
                        ++m;
                    }
                    data.put(this.getKey(line2), array);
                } else {
                    buffer.put(this.getKey(line2), array);
                }
            } else if (type == Type.ARRAY) {
                String partA = line2.substring(0, line2.indexOf(":"));
                String partB = line2.substring(line2.indexOf(":") + 2, line2.length());
                String arr = partB.substring(1, partB.length() - 1);
                ArrayList<String> array = new ArrayList<String>();
                String[] ar = arr.split(", ");
                int j = 0;
                while (j < ar.length) {
                    String a = ar[j];
                    if (!a.isEmpty()) {
                        array.add(a);
                    }
                    ++j;
                }
                int n = this.getNesting(partA);
                if (n > 0) {
                    Map<String, Object> data = buffer;
                    int m = 0;
                    while (m < n) {
                        data = (Map)data.get(nesting.get(m));
                        ++m;
                    }
                    data.put(this.getKey(partA), array);
                } else {
                    buffer.put(this.getKey(partA), array);
                }
            } else if (type == Type.KEY) {
                String[] parts = this.split(line2);
                int n = this.getNesting(line2);
                if (n > 0) {
                    Map<String, Object> data = buffer;
                    int m = 0;
                    while (m < n) {
                        data = (Map)data.get(nesting.get(m));
                        ++m;
                    }
                    data.put(this.getKey(parts[0]), parts[1]);
                } else {
                    buffer.put(this.getKey(parts[0]), parts[1]);
                }
            }
            ++i;
        }
        this.data.putAll(buffer);
    }

    public void save(OutputStream os) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String key : this.data.keySet()) {
            Object o = this.data.get(key);
            this.toArray(key, o, lines, 0);
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        int i = 0;
        while (i < lines.size()) {
            pw.println((String)lines.get(i));
            ++i;
        }
        pw.close();
    }

    private void toArray(String key, Object o, List<String> lines, int n) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            sb.append(SPACER);
            ++i;
        }
        String start = sb.toString();
        Type type = this.getType(o);
        if (type == Type.PATH) {
            lines.add(String.valueOf(start) + key + ":");
            Map data = (Map)o;
            for (String k : data.keySet()) {
                this.toArray(k, data.get(k), lines, n + 1);
            }
        } else if (type == Type.EMPTYARRAY) {
            lines.add(String.valueOf(start) + key + ": []");
        } else if (type == Type.LINEARRAY) {
            lines.add(String.valueOf(start) + key + ":");
            List li = (List)o;
            int i2 = 0;
            while (i2 < li.size()) {
                lines.add(String.valueOf(start) + "- " + li.get(i2).toString());
                ++i2;
            }
        } else if (type == Type.KEY) {
            lines.add(String.valueOf(start) + key + ": '" + o.toString() + "'");
        }
    }

    private Type getType(Object o) {
        if (o instanceof Map) {
            return Type.PATH;
        }
        if (o instanceof List) {
            if (((List)o).size() == 0) {
                return Type.EMPTYARRAY;
            }
            return Type.LINEARRAY;
        }
        return Type.KEY;
    }

    private Type getType(String line, String next) {
        String spl;
        if (line.isEmpty()) {
            return Type.BLANK;
        }
        String eline = line.replaceAll(" ", "");
        if (line.toCharArray()[0] == " ".toCharArray()[0] && eline.isEmpty()) {
            return Type.BLANK;
        }
        if (eline.startsWith("-")) {
            return Type.BLANK;
        }
        if (line.toCharArray()[0] == "#".toCharArray()[0]) {
            return Type.BLANK;
        }
        if (line.endsWith(":") && !next.endsWith(":") && next.replaceAll(" ", "").startsWith("-")) {
            return Type.LINEARRAY;
        }
        if (eline.endsWith(":[]")) {
            return Type.EMPTYARRAY;
        }
        if (line.contains(": ") && eline.endsWith("]") && (spl = eline.substring(eline.indexOf(":") + 1, eline.length())).startsWith("[")) {
            return Type.ARRAY;
        }
        if (eline.toCharArray()[eline.length() - 1] == ":".toCharArray()[0]) {
            return Type.PATH;
        }
        if (line.contains(": ")) {
            return Type.KEY;
        }
        return Type.BLANK;
    }

    private String getKey(String line) {
        while (line.startsWith(SPACER)) {
            line = line.substring(SPACER.length(), line.length());
        }
        if (line.endsWith("[]")) {
            line = line.substring(0, line.length() - 2);
        }
        if (line.endsWith(": ")) {
            line = line.substring(0, line.length() - 2);
        }
        if (line.endsWith(":")) {
            line = line.substring(0, line.length() - 1);
        }
        while (line.endsWith(" ")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    private int getNesting(String line) {
        line = line.split(":")[0];
        int nesting = 0;
        while (line.startsWith(SPACER)) {
            line = line.substring(SPACER.length(), line.length());
            ++nesting;
        }
        return nesting;
    }

    private String getLineFromArray(String line) {
        while (line.startsWith(SPACER)) {
            line = line.substring(SPACER.length(), line.length());
        }
        if (!line.startsWith("-")) {
            return "";
        }
        line = line.substring(2, line.length());
        return line;
    }

    private String[] split(String path) {
        while (path.startsWith(SPACER)) {
            path = path.substring(SPACER.length(), path.length());
        }
        String[] parts = new String[]{path.substring(0, path.indexOf(": ")), path.substring(path.indexOf(": ") + 2, path.length())};
        if (parts[1].startsWith("'")) {
            parts[1] = parts[1].substring(1, parts[1].length());
        }
        if (parts[1].endsWith("'")) {
            parts[1] = parts[1].substring(0, parts[1].length() - 1);
        }
        return parts;
    }

    static enum Type {
        BLANK,
        PATH,
        KEY,
        EMPTYARRAY,
        LINEARRAY,
        ARRAY;

    }
}

