/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.Permissions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class BukkitCompat {
    private static Field permissions;
    private static Field base;
    private static Field basePermissions;
    private static Field attachments;

    static {
        try {
            permissions = PermissionAttachment.class.getDeclaredField("permissions");
            permissions.setAccessible(true);
            base = CraftHumanEntity.class.getDeclaredField("perm");
            base.setAccessible(true);
            basePermissions = PermissibleBase.class.getDeclaredField("permissions");
            basePermissions.setAccessible(true);
            attachments = PermissibleBase.class.getDeclaredField("attachments");
            attachments.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static PermissionAttachment setPermissions(Permissible p, Plugin plugin, Map<String, Boolean> perm) {
        try {
            return BukkitCompat.doBukkitPermissions(p, plugin, perm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PermissionAttachment doBukkitPermissions(Permissible p, Plugin plugin, Map<String, Boolean> permissions) {
        Player player = (Player)p;
        Permission positive = plugin.getServer().getPluginManager().getPermission(player.getName());
        Permission negative = plugin.getServer().getPluginManager().getPermission("^" + player.getName());
        if (positive != null) {
            plugin.getServer().getPluginManager().removePermission(positive);
        }
        if (negative != null) {
            plugin.getServer().getPluginManager().removePermission(negative);
        }
        HashMap<String, Boolean> po = new HashMap<String, Boolean>();
        HashMap<String, Boolean> ne = new HashMap<String, Boolean>();
        for (String key : permissions.keySet()) {
            if (permissions.get(key).booleanValue()) {
                po.put(key, true);
                continue;
            }
            ne.put(key, false);
        }
        positive = new Permission(player.getName(), PermissionDefault.FALSE, po);
        negative = new Permission("^" + player.getName(), PermissionDefault.FALSE, ne);
        plugin.getServer().getPluginManager().addPermission(positive);
        plugin.getServer().getPluginManager().addPermission(negative);
        PermissionAttachment att = null;
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getAttachment() == null || pai.getAttachment().getPlugin() == null || !(pai.getAttachment().getPlugin() instanceof Permissions)) continue;
            att = pai.getAttachment();
            break;
        }
        if (att == null) {
            att = player.addAttachment(plugin);
            att.setPermission(player.getName(), true);
            att.setPermission("^" + player.getName(), true);
        }
        player.recalculatePermissions();
        return att;
    }

    public static PermissionAttachment doSlowBukkitPermissions(Permissible p, Plugin plugin, Map<String, Boolean> permissions) {
        PermissionAttachment att = p.addAttachment(plugin);
        HashMap<String, Boolean> po = new HashMap<String, Boolean>();
        HashMap<String, Boolean> ne = new HashMap<String, Boolean>();
        for (String key : permissions.keySet()) {
            if (permissions.get(key).booleanValue()) {
                po.put(key, true);
                continue;
            }
            ne.put(key, false);
        }
        for (String key : po.keySet()) {
            att.setPermission(key, true);
        }
        for (String key : ne.keySet()) {
            att.setPermission(key, false);
        }
        return att;
    }

    public static PermissionAttachment doSetPermissions(Permissible p, Plugin plugin, Map<String, Boolean> perm) throws Exception {
        PermissionAttachment att2;
        PermissibleBase pb = BukkitCompat.getBase(p);
        Map<String, PermissionAttachmentInfo> info = BukkitCompat.getInfo(pb);
        info.clear();
        ArrayList<PermissionAttachment> delete = new ArrayList<PermissionAttachment>();
        List<PermissionAttachment> attach = BukkitCompat.getAttachments(pb);
        for (PermissionAttachment att2 : attach) {
            if (!att2.getPlugin().getName().equalsIgnoreCase("bpermissions")) continue;
            Debugger.log("Removing " + att2.toString());
            delete.add(att2);
        }
        for (PermissionAttachment att2 : delete) {
            attach.remove(att2);
        }
        delete.clear();
        att2 = pb.addAttachment(plugin);
        permissions.set(att2, perm);
        pb.recalculatePermissions();
        return att2;
    }

    public static PermissibleBase getBase(Permissible p) {
        try {
            return (PermissibleBase)base.get(p);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, PermissionAttachmentInfo> getInfo(PermissibleBase pb) {
        try {
            return (Map)basePermissions.get(pb);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<PermissionAttachment> getAttachments(PermissibleBase pb) {
        try {
            return (List)attachments.get(pb);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void runTest(Player player, Plugin plugin) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        HashSet keys = new HashSet(permissions.keySet());
        int i = 0;
        while (i < 10000) {
            permissions.put("example." + String.valueOf(i), true);
            ++i;
        }
        long start = System.currentTimeMillis();
        PermissionAttachment att = player.addAttachment(plugin);
        for (String key : permissions.keySet()) {
            att.setPermission(key, ((Boolean)permissions.get(key)).booleanValue());
        }
        long finish = System.currentTimeMillis();
        long time = finish - start;
        System.out.println("SuperPermissions default took: " + time + "ms.");
        if (!player.hasPermission("example.1")) {
            System.err.println("permissions not registered!");
        }
        for (String key : keys) {
            att.unsetPermission(key);
        }
        att.remove();
        if (player.hasPermission("example.1")) {
            System.err.println("permissions not unregistered!");
        }
        start = System.currentTimeMillis();
        att = BukkitCompat.doBukkitPermissions((Permissible)player, plugin, permissions);
        finish = System.currentTimeMillis();
        time = finish - start;
        if (!player.hasPermission("example.1")) {
            System.err.println("permissions not registered!");
        }
        att.unsetPermission(player.getName());
        att.remove();
        System.out.println("SuperPermissions hack took: " + time + "ms.");
        if (player.hasPermission("example.1")) {
            System.err.println("permissions not unregistered!");
        }
        start = System.currentTimeMillis();
        att = BukkitCompat.setPermissions((Permissible)player, plugin, permissions);
        finish = System.currentTimeMillis();
        time = finish - start;
        if (!player.hasPermission("example.1")) {
            System.err.println("permissions not registered!");
        }
        System.out.println("bPermissions default took: " + time + "ms.");
        for (String key : keys) {
            att.unsetPermission(key);
        }
        att.remove();
        if (player.hasPermission("example.1")) {
            System.err.println("permissions not unregistered!");
        }
    }
}

