/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.LumpGroupPromotion;
import de.bananaco.bpermissions.imp.MultiGroupPromotion;
import de.bananaco.bpermissions.imp.SingleGroupPromotion;
import de.bananaco.permissions.interfaces.PromotionTrack;
import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final File file = new File("plugins/bPermissions/config.yml");
    private YamlConfiguration config = new YamlConfiguration();
    private String trackType = "multi";
    private PromotionTrack track = null;
    private boolean useGlobalFiles = false;
    private boolean autoSave = true;
    private boolean offlineMode = false;
    private boolean trackLimit = false;

    public void load() {
        try {
            this.loadUnsafe();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUnsafe() throws Exception {
        if (!this.file.exists()) {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
        }
        this.config.load(this.file);
        this.config.set("auto-save", this.config.get("auto-save", (Object)this.autoSave));
        this.config.set("track-type", this.config.get("track-type", (Object)this.trackType));
        this.config.set("debug-mode", (Object)Debugger.setDebug(this.config.getBoolean("debug-mode", Debugger.getDebug())));
        this.config.set("allow-offline-mode", this.config.get("allow-offline-mode", (Object)this.offlineMode));
        this.config.set("use-global-files", this.config.get("use-global-files", (Object)this.useGlobalFiles));
        this.config.set("track-limit", this.config.get("track-limit", (Object)this.trackLimit));
        this.useGlobalFiles = this.config.getBoolean("use-global-files");
        this.autoSave = this.config.getBoolean("auto-save");
        this.trackType = this.config.getString("track-type");
        this.offlineMode = this.config.getBoolean("allow-offline-mode");
        this.trackLimit = this.config.getBoolean("track-limit");
        this.track = this.trackType.equalsIgnoreCase("multi") ? new MultiGroupPromotion() : (this.trackType.equalsIgnoreCase("lump") ? new LumpGroupPromotion() : new SingleGroupPromotion());
        WorldManager.getInstance().setAutoSave(this.autoSave);
        this.track.load();
        this.config.save(this.file);
    }

    public boolean trackLimit() {
        return this.trackLimit;
    }

    public boolean getUseGlobalFiles() {
        return this.useGlobalFiles;
    }

    public PromotionTrack getPromotionTrack() {
        return this.track;
    }

    public boolean getAllowOfflineMode() {
        return this.offlineMode;
    }
}

