/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.imp.YamlConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.permissions.PermissionDefault;

public class CustomNodes {
    private final File file = new File("plugins/bPermissions/custom_nodes.yml");
    private YamlConfiguration config;

    public void load() {
        try {
            List<org.bukkit.permissions.Permission> permissions = this.doLoad();
            int i = 0;
            while (i < permissions.size()) {
                if (Bukkit.getServer().getPluginManager().getPermission(permissions.get(i).getName()) == null) {
                    Bukkit.getServer().getPluginManager().addPermission(permissions.get(i));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<org.bukkit.permissions.Permission> doLoad() throws Exception {
        this.config = new YamlConfiguration();
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        this.config.load(this.file);
        ArrayList<org.bukkit.permissions.Permission> permissions = new ArrayList<org.bukkit.permissions.Permission>();
        Set keys = this.config.getKeys(false);
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                String permission = key;
                List childList = this.config.getStringList(String.valueOf(permission) + ".children");
                if (childList == null || childList.size() <= 0) continue;
                HashMap<String, Boolean> children = new HashMap<String, Boolean>();
                Set<Permission> perms = Permission.loadFromString(childList);
                for (Permission perm : perms) {
                    children.put(perm.nameLowerCase(), perm.isTrue());
                }
                String pd = this.config.getString(String.valueOf(permission) + ".default", "op");
                PermissionDefault pdo = PermissionDefault.OP;
                if (pd.equalsIgnoreCase("not-op")) {
                    pdo = PermissionDefault.NOT_OP;
                } else if (pd.equalsIgnoreCase("true")) {
                    pdo = PermissionDefault.TRUE;
                } else if (pd.equalsIgnoreCase("false")) {
                    pdo = PermissionDefault.FALSE;
                }
                org.bukkit.permissions.Permission perm = new org.bukkit.permissions.Permission(permission.toLowerCase(), pdo, children);
                permissions.add(perm);
            }
        }
        return permissions;
    }
}

