/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.WorldManager;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public class Mirrors {
    private final Map<String, String> mirrors;
    private final File file = new File("plugins/bPermissions/mirrors.yml");
    private final YamlConfiguration config = new YamlConfiguration();

    protected Mirrors(Map<String, String> mirrors) {
        this.mirrors = mirrors;
    }

    public void load() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            this.config.load(this.file);
            Set keys = this.config.getKeys(false);
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    this.mirrors.put(key.toLowerCase(), this.config.getString(key).toLowerCase());
                }
            } else {
                this.config.set("example_world_nether", (Object)"example_world");
                this.config.set("example_world_end", (Object)"example_world");
                this.config.save(this.file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WorldManager.getInstance().setMirrors(this.mirrors);
    }

    public void save() {
        try {
            Set<String> keys = this.mirrors.keySet();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    this.config.set(key, (Object)this.mirrors.get(key));
                }
                this.config.save(this.file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

