/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.imp.BukkitCompat;
import de.bananaco.bpermissions.imp.Commands;
import de.bananaco.bpermissions.imp.Config;
import de.bananaco.bpermissions.imp.CustomNodes;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.DefaultWorld;
import de.bananaco.bpermissions.imp.ExtraCommands;
import de.bananaco.bpermissions.imp.Mirrors;
import de.bananaco.bpermissions.imp.SuperPermissionHandler;
import de.bananaco.bpermissions.imp.ValidityCheck;
import de.bananaco.bpermissions.imp.WorldLoader;
import de.bananaco.bpermissions.imp.YamlTask;
import de.bananaco.bpermissions.unit.PermissionsTest;
import de.bananaco.permissions.ImportManager;
import de.bananaco.permissions.fornoobs.BackupPermissionsCommand;
import de.bananaco.permissions.fornoobs.ForNoobs;
import de.bananaco.permissions.interfaces.PromotionTrack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Permissions
extends JavaPlugin {
    private final Map<String, String> mirrors = new HashMap<String, String>();
    private final Mirrors mrs = new Mirrors(this.mirrors);
    public SuperPermissionHandler handler;
    private Listener loader;
    public Map<String, Commands> commands;
    private WorldManager wm;
    private DefaultWorld world;
    private Config config;
    protected static JavaPlugin instance = null;

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.wm != null) {
            for (World world : this.wm.getAllWorlds()) {
                world.save();
            }
        }
        System.out.println(Permissions.blankFormat("Disabled"));
    }

    public void onLoad() {
        this.mrs.load();
    }

    public void onEnable() {
        instance = this;
        this.config = new Config();
        this.config.load();
        boolean onlineMode = this.getServer().getOnlineMode();
        if (!this.config.getAllowOfflineMode() && !onlineMode) {
            System.err.println(Permissions.blankFormat("Please check config.yml to enable offline-mode use"));
            this.setEnabled(false);
            return;
        }
        this.wm = WorldManager.getInstance();
        this.wm.setUseGlobalFiles(this.config.getUseGlobalFiles());
        this.handler = new SuperPermissionHandler(this);
        this.loader = new WorldLoader(this, this.mirrors);
        this.world = new DefaultWorld(this);
        this.wm.setDefaultWorld(this.world);
        this.world.load();
        this.commands = new HashMap<String, Commands>();
        this.getServer().getPluginManager().registerEvents(this.loader, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.handler, (Plugin)this);
        new CustomNodes().load();
        new YamlTask(this);
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new SuperPermissionHandler.SuperPermissionReloader(this.handler), 5L, 5L);
        Debugger.log(Permissions.blankFormat("Enabled"));
    }

    public static void printDinosaurs() {
        String dino = "            __ \n           / _)\n    .-^^^-/ /  \n __/       /\n<__.|_|-|_|\n==DINOSAUR==";
        System.out.println("\n" + dino);
    }

    public static String blankFormat(String message) {
        return "[bPermissions] " + message;
    }

    public static String format(String message) {
        ChatColor vary = ChatColor.GREEN;
        if (message.contains("!")) {
            vary = ChatColor.RED;
        } else if (message.contains(":")) {
            vary = ChatColor.AQUA;
        }
        return ChatColor.BLUE + "[bPermissions] " + vary + message;
    }

    public static boolean hasPermission(Player player, String node) {
        return WorldManager.getInstance().getWorld(player.getWorld().getName()).getUser(player.getName()).hasPermission(node);
    }

    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(Permissions.format(message));
    }

    public boolean has(CommandSender sender, String perm) {
        if (sender instanceof Player) {
            return sender.hasPermission(perm);
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean allowed = true;
        if (sender instanceof Player) {
            boolean bl = allowed = Permissions.hasPermission((Player)sender, "bPermissions.admin") || sender.isOp();
        }
        if (args.length > 0 && (command.getName().equalsIgnoreCase("promote") || command.getName().equalsIgnoreCase("demote"))) {
            String player = args[0];
            String name = "default";
            String world = null;
            if (args.length > 1) {
                name = args[1];
            }
            if (args.length > 2) {
                world = args[2];
            }
            if (!this.has(sender, "tracks." + name)) {
                this.sendMessage(sender, "You don't have permission to use promotion tracks!");
                return true;
            }
            if (command.getName().equalsIgnoreCase("promote")) {
                PromotionTrack track = this.config.getPromotionTrack();
                if (track.containsTrack(name)) {
                    if (this.config.trackLimit()) {
                        Player s;
                        boolean isValid = true;
                        Player player2 = s = sender instanceof Player ? (Player)sender : null;
                        if (world == null) {
                            for (org.bukkit.World w : Bukkit.getWorlds()) {
                                boolean v = new ValidityCheck(s, track, name, player, w.getName()).isValid();
                                if (v) continue;
                                isValid = false;
                            }
                        } else {
                            isValid = new ValidityCheck(s, track, name, player, world).isValid();
                        }
                        if (!isValid) {
                            sender.sendMessage(ChatColor.RED + "Invalid promotion!");
                            return true;
                        }
                    }
                    track.promote(player, name, world);
                    this.sendMessage(sender, "Promoted along the track: " + name + " in " + (world == null ? "all worlds" : "world: " + world));
                    this.showPromoteOutput(sender, player);
                } else {
                    this.sendMessage(sender, "That track (" + name + ") does not exist");
                }
            } else if (command.getName().equalsIgnoreCase("demote")) {
                PromotionTrack track = this.config.getPromotionTrack();
                if (track.containsTrack(name)) {
                    if (this.config.trackLimit()) {
                        Player s;
                        boolean isValid = true;
                        Player player3 = s = sender instanceof Player ? (Player)sender : null;
                        if (world == null) {
                            for (org.bukkit.World w : Bukkit.getWorlds()) {
                                boolean v = new ValidityCheck(s, track, name, player, w.getName()).isValid();
                                if (v) continue;
                                isValid = false;
                            }
                        } else {
                            isValid = new ValidityCheck(s, track, name, player, world).isValid();
                        }
                        if (!isValid) {
                            sender.sendMessage(ChatColor.RED + "Invalid promotion!");
                            return true;
                        }
                    }
                    track.demote(player, name, world);
                    this.sendMessage(sender, "Demoted along the track: " + name + " in " + (world == null ? "all worlds" : "world: " + world));
                    this.showPromoteOutput(sender, player);
                } else {
                    this.sendMessage(sender, "That track (" + name + ") does not exist");
                }
            }
            return true;
        }
        if (!allowed) {
            this.sendMessage(sender, "You're not allowed to do that!");
            return true;
        }
        if (!this.commands.containsKey(this.getName(sender))) {
            this.commands.put(this.getName(sender), new Commands());
        }
        Commands cmd = this.commands.get(this.getName(sender));
        if (command.getName().equalsIgnoreCase("world")) {
            World world = cmd.getWorld();
            if (args.length == 0) {
                if (world == null) {
                    this.sendMessage(sender, "No world selected.");
                } else {
                    this.sendMessage(sender, "Currently selected world: " + world.getName());
                }
            } else if (args.length == 1) {
                cmd.setWorld(args[0], sender);
            } else if (args.length == 3 && args[0].equalsIgnoreCase("mirror")) {
                String worldFrom = args[1];
                String worldTo = args[2];
                this.mirrors.put(worldFrom, worldTo);
                this.mrs.save();
                sender.sendMessage(String.valueOf(worldFrom) + " mirrored to " + worldTo);
            } else {
                this.sendMessage(sender, "Too many arguments.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("user") || command.getName().equalsIgnoreCase("group")) {
            CalculableType opposite;
            Calculable calc = cmd.getCalculable();
            CalculableType type = command.getName().equalsIgnoreCase("user") ? CalculableType.USER : CalculableType.GROUP;
            CalculableType calculableType = opposite = !command.getName().equalsIgnoreCase("user") ? CalculableType.USER : CalculableType.GROUP;
            if (args.length == 0) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else {
                    this.sendMessage(sender, "Currently selected " + calc.getType().getName() + ": " + calc.getName());
                }
            } else if (args.length == 1) {
                cmd.setCalculable(type, args[0], sender);
            } else if (args.length == 2) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else if (calc.getType() != type) {
                    this.sendMessage(sender, "Please select a " + type.getName() + ", you currently have a " + opposite.getName() + " selected.");
                } else {
                    String action = args[0];
                    String value = args[1];
                    if (action.equalsIgnoreCase("addgroup")) {
                        cmd.addGroup(value, sender);
                    } else if (action.equalsIgnoreCase("rmgroup")) {
                        cmd.removeGroup(value, sender);
                    } else if (action.equalsIgnoreCase("setgroup")) {
                        cmd.setGroup(value, sender);
                    } else if (action.equalsIgnoreCase("list")) {
                        if ((value = value.toLowerCase()).equalsIgnoreCase("groups") || value.equalsIgnoreCase("group") || value.equalsIgnoreCase("g")) {
                            cmd.listGroups(sender);
                        } else if (value.startsWith("perm") || value.equalsIgnoreCase("p")) {
                            cmd.listPermissions(sender);
                        }
                    } else if (action.equalsIgnoreCase("meta")) {
                        cmd.showValue(value, sender);
                    } else if (action.equalsIgnoreCase("cmeta")) {
                        cmd.clearMeta(value, sender);
                    } else if (action.equalsIgnoreCase("addperm")) {
                        cmd.addPermission(value, sender);
                    } else if (action.equalsIgnoreCase("rmperm")) {
                        cmd.removePermission(value, sender);
                    } else if (action.equals("has")) {
                        cmd.hasPermission(value, sender);
                    } else {
                        this.sendMessage(sender, "Please consult the command documentation!");
                    }
                }
            } else if (args.length == 3 && args[0].equalsIgnoreCase("meta")) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else if (calc.getType() != type) {
                    this.sendMessage(sender, "Please select a " + type.getName() + ", you currently have a " + opposite.getName() + " selected.");
                } else {
                    cmd.setValue(args[1], args[2], sender);
                }
            } else {
                this.sendMessage(sender, "Too many arguments.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("exec")) {
            String name = "null";
            Object type = CalculableType.USER;
            String action = "null";
            String value = "null";
            String world = null;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                if (c.startsWith("u:") || c.startsWith("g:")) {
                    type = c.startsWith("u:") ? CalculableType.USER : CalculableType.GROUP;
                    name = c.split(":")[1];
                } else if (c.startsWith("a:")) {
                    action = c.split(":")[1];
                } else if (c.startsWith("v:")) {
                    value = c.split(":")[1];
                } else if (c.startsWith("w:")) {
                    world = c.split(":")[1];
                }
                ++n2;
            }
            String message = ChatColor.GOLD + "Executing action: " + ChatColor.GREEN + action + " " + value + ChatColor.GOLD + " in " + ChatColor.GREEN + (world == null ? "all worlds" : "world: " + world);
            String message2 = ChatColor.GOLD + "Action applied to " + ChatColor.GREEN + type.getName() + " " + name;
            sender.sendMessage(message);
            sender.sendMessage(message2);
            ExtraCommands.execute(name, type, action, value, world);
        }
        if (command.getName().equalsIgnoreCase("permissions")) {
            if (args.length == 2 && args[0].equalsIgnoreCase("import")) {
                sender.sendMessage("Importing from " + args[1]);
                try {
                    if (args[1].equalsIgnoreCase("yml")) {
                        new ImportManager(this).importYML();
                    }
                    if (args[1].equalsIgnoreCase("pex")) {
                        new ImportManager(this).importPEX();
                    }
                    if (args[1].equalsIgnoreCase("p3")) {
                        new ImportManager(this).importPermissions3();
                    }
                    if (args[1].equalsIgnoreCase("gm")) {
                        new ImportManager(this).importGroupManager();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (args.length == 1) {
                String action;
                if (sender instanceof ConsoleCommandSender) {
                    Player player;
                    Player[] players;
                    if (args[0].equalsIgnoreCase("debug")) {
                        if (Debugger.getDebug()) {
                            for (World world : this.wm.getAllWorlds()) {
                                Debugger.log(world);
                            }
                            return true;
                        }
                        sender.sendMessage("Please enable debug mode to use this command.");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("debugperms")) {
                        players = Bukkit.getOnlinePlayers();
                        if (players.length == 0) {
                            System.err.println("You need some online players!");
                        } else {
                            Player[] playerArray = players;
                            int n = players.length;
                            int n3 = 0;
                            while (n3 < n) {
                                player = playerArray[n3];
                                PermissionsTest.test(player);
                                ++n3;
                            }
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("debugset")) {
                        players = Bukkit.getOnlinePlayers();
                        if (players.length == 0) {
                            System.err.println("You need some online players!");
                        } else {
                            player = players[0];
                            BukkitCompat.runTest(player, (Plugin)this);
                        }
                        return true;
                    }
                }
                if ((action = args[0]).equalsIgnoreCase("save")) {
                    this.sendMessage(sender, "All worlds saved!");
                    cmd.save();
                    return true;
                }
                if (action.equalsIgnoreCase("reload")) {
                    for (World world : this.wm.getAllWorlds()) {
                        world.load();
                    }
                    this.wm.getWorld("*").setupAll();
                    this.sendMessage(sender, "All worlds reloaded!");
                    return true;
                }
                if (action.equalsIgnoreCase("cleanup")) {
                    this.sendMessage(sender, "Cleaning up files!");
                    this.wm.cleanup();
                    return true;
                }
                if (action.equalsIgnoreCase("examplefiles")) {
                    this.sendMessage(sender, "Created example files!");
                    new ForNoobs(this).addAll();
                    return true;
                }
                if (action.equalsIgnoreCase("backup")) {
                    this.sendMessage(sender, "Creating backup!");
                    new BackupPermissionsCommand(this).backup();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void showPromoteOutput(CommandSender sender, String player) {
        sender.sendMessage("The player: " + ChatColor.GREEN + player + ChatColor.WHITE + " now has these groups");
        for (World world : WorldManager.getInstance().getAllWorlds()) {
            List<String> groups = world.getUser(player).serialiseGroups();
            Object[] g = groups.toArray(new String[groups.size()]);
            String gr = Arrays.toString(g);
            sender.sendMessage("In world: " + world.getName() + " " + gr);
        }
    }

    private String getName(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "CONSOLE";
    }
}

