/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.ApiLayer;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.imp.BukkitCompat;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class SuperPermissionHandler
implements Listener {
    private WorldManager wm = WorldManager.getInstance();
    private Permissions plugin;

    public static synchronized void setPermissions(Permissible p, Plugin plugin, Map<String, Boolean> perm) {
        BukkitCompat.setPermissions(p, plugin, perm);
    }

    protected SuperPermissionHandler(Permissions plugin) {
        this.plugin = plugin;
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        children.put("bPermissions.admin", true);
        Permission permission = new Permission("bPermissions.*", PermissionDefault.OP, children);
        if (plugin.getServer().getPluginManager().getPermission("bPermissions.*") == null) {
            plugin.getServer().getPluginManager().addPermission(permission);
        }
    }

    public void setupAllPlayers() {
        Player[] playerArray = this.plugin.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.setupPlayer(player);
            ++n2;
        }
    }

    public void setupPlayer(Player player) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        long time = System.currentTimeMillis();
        Map<String, Boolean> perms = ApiLayer.getEffectivePermissions(player.getWorld().getName(), CalculableType.USER, player.getName());
        SuperPermissionHandler.setPermissions((Permissible)player, (Plugin)this.plugin, perms);
        String prefix = ApiLayer.getValue(player.getWorld().getName(), CalculableType.USER, player.getName(), "prefix");
        String suffix = ApiLayer.getValue(player.getWorld().getName(), CalculableType.USER, player.getName(), "suffix");
        player.setMetadata("prefix", (MetadataValue)new FixedMetadataValue((Plugin)Permissions.instance, (Object)prefix));
        player.setMetadata("suffix", (MetadataValue)new FixedMetadataValue((Plugin)Permissions.instance, (Object)suffix));
        long finish = System.currentTimeMillis() - time;
        Debugger.log("Setup superperms for " + player.getName() + ". took " + finish + "ms.");
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.setupPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            final Player player = event.getPlayer();
            final org.bukkit.World start = event.getFrom().getWorld();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!start.equals(player.getWorld())) {
                        SuperPermissionHandler.this.setupPlayer(player);
                    }
                }
            };
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, r, 5L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreLogin(PlayerPreLoginEvent event) {
        for (World world : this.wm.getAllWorlds()) {
            User user = world.getUser(event.getName());
            try {
                user.calculateEffectivePermissions();
                user.calculateEffectiveMeta();
            }
            catch (Exception e) {
                System.err.println(e.getStackTrace()[0].toString());
            }
            Debugger.log("PlayerPreLogin setup: " + user.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerLoginEvent event) {
        this.setupPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerJoinEvent event) {
        this.setupPlayer(event.getPlayer());
    }

    public void setupPlayer(String name) {
        if (Bukkit.getPlayer((String)name) != null) {
            Player player = Bukkit.getPlayer((String)name);
            this.setupPlayer(player);
        }
    }

    static class SuperPermissionReloader
    implements Runnable {
        private final SuperPermissionHandler handler;

        public SuperPermissionReloader(SuperPermissionHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            if (Bukkit.getOnlinePlayers().length == 0) {
                return;
            }
            ArrayList<Player> update = new ArrayList<Player>();
            Player[] playerArray = Bukkit.getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                PermissibleBase pb = BukkitCompat.getBase((Permissible)player);
                List<PermissionAttachment> attach = BukkitCompat.getAttachments(pb);
                boolean up = true;
                for (PermissionAttachment att : attach) {
                    if (att.getPlugin() == null || !(att.getPlugin() instanceof Permissions)) continue;
                    up = false;
                }
                if (up) {
                    update.add(player);
                }
                ++n2;
            }
            if (update.size() > 0) {
                Debugger.log("Force-updating " + update.size() + " players!");
                for (Player player : update) {
                    this.handler.setupPlayer(player.getName());
                }
                update.clear();
            }
        }
    }
}

