/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class YamlFile {
    private final File file;
    private final List<String> data = new ArrayList<String>();

    public YamlFile(File file, boolean fix) {
        this(file);
        if (fix) {
            this.parse();
            this.save();
        }
    }

    public YamlFile(File file) {
        this.file = file;
    }

    public void load() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
            while ((line = br.readLine()) != null) {
                this.data.add(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parse() {
        ArrayList<String> newData = new ArrayList<String>();
        if (this.data.size() == 0) {
            this.load();
        }
        int i = 0;
        while (i < this.data.size()) {
            String line = this.data.get(i);
            if (line.contains("\t")) {
                System.err.println("line " + i + " of " + this.file.getName() + " contained a Yaml error. A fix was attempted.");
                while (line.contains("\t")) {
                    line = line.replace("\t", "  ");
                }
            }
            if (!(line.replaceAll(" ", "").endsWith(":") || line.replaceAll(" ", "").startsWith("-") || line.endsWith("[]") || line.contains(": "))) {
                System.err.println("line " + i + " of " + this.file.getName() + " contained a Yaml error. A fix was attempted.");
                line = String.valueOf(line) + ":";
            }
            if (line.replaceAll(" ", "").startsWith("- ") && line.replaceAll(" ", "").replace("- ", "").startsWith("'") && !line.endsWith("'")) {
                System.err.println("line " + i + " of " + this.file.getName() + " contained a Yaml error. A fix was attempted.");
                line = String.valueOf(line) + "'";
            }
            if (line.replaceAll(" ", "").equals("")) {
                System.err.println("line " + i + " of " + this.file.getName() + " contained a Yaml error. A fix was attempted.");
                line = line.replaceAll(" ", "");
            }
            if (line.equals(":")) {
                System.err.println("line " + i + " of " + this.file.getName() + " contained a Yaml error. A fix was attempted.");
                line = line.replaceAll(":", "");
            } else if (!line.equals(":") && !line.equals("")) {
                newData.add(line);
            }
            ++i;
        }
        this.data.clear();
        i = 0;
        while (i < newData.size()) {
            String d = (String)newData.get(i);
            if (!d.equals("")) {
                this.data.add(d);
            }
            ++i;
        }
    }

    public void save() {
        try {
            PrintWriter br = new PrintWriter(new FileOutputStream(this.file));
            int i = 0;
            while (i < this.data.size()) {
                br.println(this.data.get(i));
                ++i;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }
}

