/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.api.util.MetaData;
import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.fake.FakeYaml;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.Permissions;
import de.bananaco.bpermissions.imp.YamlConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class YamlWorldBackup
extends World {
    protected static final String GROUPS = "groups";
    protected static final String PERMISSIONS = "permissions";
    protected static final String META = "meta";
    protected static final String USERS = "users";
    protected YamlConfiguration uconfig = new YamlConfiguration();
    protected YamlConfiguration gconfig = new YamlConfiguration();
    private final File ufile;
    private final File gfile;
    protected final Permissions permissions;
    protected final WorldManager wm = WorldManager.getInstance();
    protected boolean error = false;

    public YamlWorldBackup(String world, Permissions permissions, File root) {
        super(world);
        this.permissions = permissions;
        this.ufile = new File(root, "users.yml");
        this.gfile = new File(root, "groups.yml");
    }

    @Override
    public String getDefaultGroup() {
        if (this.gconfig != null) {
            return this.gconfig.getString("default", "default");
        }
        return "default";
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.uconfig = new YamlConfiguration();
        this.gconfig = new YamlConfiguration();
        try {
            this.saveUnsafe(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean load() {
        try {
            this.clear();
            this.loadUnsafe();
            this.loadFake();
            this.error = false;
        }
        catch (Exception e) {
            this.error = true;
            Bukkit.getServer().broadcastMessage(ChatColor.RED + "Permissions for world:" + this.getName() + " did not load correctly! Please consult server.log");
            e.printStackTrace();
        }
        return true;
    }

    protected void loadFake() throws Exception {
        long s = System.currentTimeMillis();
        FakeYaml ufake = new FakeYaml();
        FakeYaml gfake = new FakeYaml();
        ufake.load(new FileInputStream(this.ufile));
        gfake.load(new FileInputStream(this.gfile));
        long f = System.currentTimeMillis();
        Debugger.log("New method: " + (f - s) + "ms");
    }

    protected synchronized void loadUnsafe() throws Exception {
        boolean autoSave = this.wm.getAutoSave();
        this.wm.setAutoSave(false);
        if (!this.ufile.exists()) {
            if (this.ufile.getParentFile() != null) {
                this.ufile.getParentFile().mkdirs();
            }
            this.ufile.createNewFile();
            this.gfile.createNewFile();
        }
        this.uconfig = new YamlConfiguration();
        this.gconfig = new YamlConfiguration();
        long t = System.currentTimeMillis();
        this.uconfig.load(this.ufile);
        this.gconfig.load(this.gfile);
        long f = System.currentTimeMillis();
        Debugger.log("Loading files took " + (f - t) + "ms");
        ConfigurationSection usersConfig = this.uconfig.getConfigurationSection(USERS);
        if (usersConfig != null) {
            Set names = usersConfig.getKeys(false);
            for (String name : names) {
                Set keys;
                List nPerm = usersConfig.getStringList(String.valueOf(name) + "." + PERMISSIONS);
                List nGroup = usersConfig.getStringList(String.valueOf(name) + "." + GROUPS);
                Set<Permission> perms = Permission.loadFromString(nPerm);
                User user = new User(name, nGroup, perms, this.getName(), this);
                ConfigurationSection meta = usersConfig.getConfigurationSection(String.valueOf(name) + "." + META);
                if (meta != null && (keys = meta.getKeys(false)) != null && keys.size() > 0) {
                    for (String key : keys) {
                        user.setValue(key, meta.get(key).toString());
                    }
                }
                this.add(user);
            }
        } else {
            Debugger.log("Empty ConfigurationSection:users:" + this.ufile.getPath());
        }
        ConfigurationSection groupsConfig = this.gconfig.getConfigurationSection(GROUPS);
        if (groupsConfig != null) {
            Set names = groupsConfig.getKeys(false);
            for (String name : names) {
                Set keys;
                List nPerm = groupsConfig.getStringList(String.valueOf(name) + "." + PERMISSIONS);
                List nGroup = groupsConfig.getStringList(String.valueOf(name) + "." + GROUPS);
                Set<Permission> perms = Permission.loadFromString(nPerm);
                Group group = new Group(name, nGroup, perms, this.getName(), this);
                ConfigurationSection meta = groupsConfig.getConfigurationSection(String.valueOf(name) + "." + META);
                if (meta != null && (keys = meta.getKeys(false)) != null && keys.size() > 0) {
                    for (String key : keys) {
                        group.setValue(key, meta.get(key).toString());
                    }
                }
                this.add(group);
            }
        } else {
            Debugger.log("Empty ConfigurationSection:groups:" + this.gfile.getPath());
        }
        Debugger.log(String.valueOf(this.getAll(CalculableType.USER).size()) + " users loaded.");
        Debugger.log(String.valueOf(this.getAll(CalculableType.GROUP).size()) + " groups loaded.");
        Player[] playerArray = this.permissions.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            String name = player.getName();
            String world = player.getWorld().getName();
            if (this.wm.getWorld(world) == this) {
                this.getUser(name).calculateEffectivePermissions();
                this.getUser(name).calculateEffectiveMeta();
            }
            ++n2;
        }
        this.wm.setAutoSave(autoSave);
    }

    @Override
    public boolean save() {
        if (this.error) {
            Bukkit.getServer().broadcastMessage(ChatColor.RED + "Permissions for world:" + this.getName() + " did not load correctly, please consult server.log.");
            return false;
        }
        try {
            this.saveUnsafe(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void saveUnsafe(boolean sort) throws Exception {
        if (!this.ufile.exists()) {
            this.ufile.getParentFile().mkdirs();
            this.ufile.createNewFile();
            this.gfile.createNewFile();
        }
        String def = this.getDefaultGroup();
        this.gconfig.set("default", def);
        Set<Calculable> usr = this.getAll(CalculableType.USER);
        Debugger.log(String.valueOf(usr.size()) + " users saved.");
        ArrayList<Calculable> users = new ArrayList<Calculable>(usr);
        if (sort) {
            MetaData.sort(users);
        }
        for (Calculable user : users) {
            String name = user.getName();
            this.uconfig.set("users." + name + "." + PERMISSIONS, user.serialisePermissions());
            this.uconfig.set("users." + name + "." + GROUPS, user.serialiseGroups());
            Map<String, String> meta = user.getMeta();
            if (meta.size() <= 0) continue;
            for (String key : meta.keySet()) {
                this.uconfig.set("users." + name + "." + META + "." + key, meta.get(key));
            }
        }
        Set<Calculable> grp = this.getAll(CalculableType.GROUP);
        Debugger.log(String.valueOf(grp.size()) + " groups saved.");
        ArrayList<Calculable> groups = new ArrayList<Calculable>(grp);
        if (sort) {
            MetaData.sort(groups);
        }
        for (Calculable group : groups) {
            String name = group.getName();
            this.gconfig.set("groups." + name + "." + PERMISSIONS, group.serialisePermissions());
            this.gconfig.set("groups." + name + "." + GROUPS, group.serialiseGroups());
            Map<String, String> meta = group.getMeta();
            if (meta.size() <= 0) continue;
            for (String key : meta.keySet()) {
                this.gconfig.set("groups." + name + "." + META + "." + key, meta.get(key));
            }
        }
        long t = System.currentTimeMillis();
        this.uconfig.save(this.ufile);
        this.gconfig.save(this.gfile);
        long f = System.currentTimeMillis();
        Debugger.log("Saving files took " + (f - t) + "ms");
    }

    @Override
    public boolean setupAll() {
        Player[] players;
        Player[] playerArray = players = Bukkit.getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.setupPlayer(player.getName());
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isOnline(User user) {
        return Bukkit.getPlayer((String)user.getName()) != null;
    }

    @Override
    public boolean setupPlayer(String player) {
        this.permissions.handler.setupPlayer(player);
        return true;
    }

    @Override
    public void setDefaultGroup(String group) {
        this.gconfig.set("default", group);
        try {
            this.gconfig.save(this.gfile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

