/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.unit;

import de.bananaco.bpermissions.api.ApiLayer;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Calculable;
import de.bananaco.bpermissions.api.util.CalculableType;
import de.bananaco.bpermissions.api.util.GroupCarrier;
import de.bananaco.bpermissions.api.util.MetaData;
import de.bananaco.bpermissions.api.util.Permission;
import de.bananaco.bpermissions.api.util.PermissionCarrier;
import de.bananaco.bpermissions.api.util.RecursiveGroupException;
import java.util.Arrays;
import java.util.Map;

public class CalculableTest {
    private final World world;

    public CalculableTest(World world) {
        this.world = world;
    }

    public void printLine() {
        System.out.println("#################################################");
    }

    public void heroChatTest() {
        this.printLine();
        System.out.println("Setting up whitelist group:");
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "whitelist", Permission.loadFromString("herochat.speak.*"));
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "whitelist", Permission.loadFromString("^herochat.speak.admin"));
        ApiLayer.setGroup(this.world.getName(), CalculableType.USER, "test", "whitelist");
        ApiLayer.update();
        Map<String, Boolean> perms = ApiLayer.getEffectivePermissions(this.world.getName(), CalculableType.USER, "test");
        System.out.println("Whitelist permissions: ");
        for (String key : perms.keySet()) {
            System.out.println(String.valueOf(key) + ":" + perms.get(key));
        }
        boolean user = ApiLayer.hasPermission(this.world.getName(), CalculableType.USER, "test", "herochat.speak.user");
        boolean admin = ApiLayer.hasPermission(this.world.getName(), CalculableType.USER, "test", "herochat.speak.admin");
        System.out.println("Has permission herochat.speak.user: " + user);
        System.out.println("Has permission herochat.speak.admin: " + admin);
    }

    public void slipcorTest() {
        this.printLine();
        System.out.println("slipcor test begin!");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "donator", "priority", "52");
        ApiLayer.addGroup(this.world.getName(), CalculableType.GROUP, "donator", "default");
        ApiLayer.setGroup(this.world.getName(), CalculableType.USER, "slipcor", "donator");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "mage", "priority", "55");
        ApiLayer.addGroup(this.world.getName(), CalculableType.GROUP, "mage", "default");
        ApiLayer.addGroup(this.world.getName(), CalculableType.USER, "slipcor", "mage");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "mayor", "priority", "66");
        ApiLayer.addGroup(this.world.getName(), CalculableType.USER, "slipcor", "mayor");
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "default", Permission.loadFromString("^test.test"));
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "mage", Permission.loadFromString("test.test"));
        ApiLayer.update();
        boolean perm = ApiLayer.hasPermission(this.world.getName(), CalculableType.USER, "slipcor", "test.test");
        if (perm) {
            System.out.println("Test passed!");
        } else {
            System.out.println("Test failed!");
        }
    }

    public void slipcorTest2() {
        this.printLine();
        System.out.println("slipcor test2 begin!");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "smage", "priority", "51");
        ApiLayer.addGroup(this.world.getName(), CalculableType.GROUP, "smage", "mage");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "mage", "priority", "50");
        ApiLayer.addGroup(this.world.getName(), CalculableType.GROUP, "mage", "default");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "default", "priority", "1");
        ApiLayer.setGroup(this.world.getName(), CalculableType.USER, "slipcor", "default");
        ApiLayer.addGroup(this.world.getName(), CalculableType.USER, "slipcor", "smage");
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "default", Permission.loadFromString("^test.test"));
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "smage", Permission.loadFromString("test.test"));
        ApiLayer.update();
        String[] stringArray = ApiLayer.getGroups(this.world.getName(), CalculableType.USER, "slipcor");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            System.out.print(String.valueOf(group) + " ");
            ++n2;
        }
        boolean perm = ApiLayer.hasPermission(this.world.getName(), CalculableType.USER, "slipcor", "test.test");
        if (perm) {
            System.out.println("Test passed!");
        } else {
            System.out.println("Test failed!");
        }
    }

    public void slipcorTest3() {
        this.printLine();
        System.out.println("slipcor test3 begin!");
        ApiLayer.addPermission(this.world.getName(), CalculableType.GROUP, "groupA", Permission.loadFromString("node"));
        ApiLayer.addGroup(this.world.getName(), CalculableType.GROUP, "groupB", "groupA");
        ApiLayer.addGroup(this.world.getName(), CalculableType.GROUP, "groupC", "groupB");
        ApiLayer.setGroup(this.world.getName(), CalculableType.USER, "test", "groupC");
        ApiLayer.addGroup(this.world.getName(), CalculableType.USER, "test", "groupD");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "groupC", "priority", "5");
        ApiLayer.setValue(this.world.getName(), CalculableType.GROUP, "groupD", "priority", "25");
        ApiLayer.update();
        boolean perm = ApiLayer.hasPermission(this.world.getName(), CalculableType.USER, "test", "node");
        if (perm) {
            System.out.println("Test passed!");
        } else {
            System.out.println("Test failed!");
        }
    }

    public void negativeInheritanceCheck() {
        this.printLine();
        WorldManager.getInstance().setDefaultWorld(this.world);
        try {
            ApiLayer.addPermission(null, CalculableType.GROUP, "groupA", Permission.loadFromString("command.node"));
            ApiLayer.addPermission(null, CalculableType.GROUP, "groupB", Permission.loadFromString("^command.node"));
            ApiLayer.addGroup(null, CalculableType.GROUP, "groupB", "groupA");
            ApiLayer.addGroup(null, CalculableType.USER, "test", "groupB");
            Calculable test = WorldManager.getInstance().getDefaultWorld().get("test", CalculableType.USER);
            System.out.println("Testing (true if passed) groupA: command.node groupB: ^command.node");
            System.out.println("user hasgroup groupB - expected negative node: result");
            test.calculateEffectivePermissions();
            System.out.println(!test.hasPermission("command.node"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testGlobalPermissionsCalculation() {
        this.printLine();
        WorldManager.getInstance().setUseGlobalFiles(true);
        ApiLayer.setGroup(null, CalculableType.USER, "test", "default");
        ApiLayer.setGroup(this.world.getName(), CalculableType.USER, "test", "default");
        ApiLayer.addPermission(null, CalculableType.USER, "test", Permission.loadFromString("^global.negative"));
        ApiLayer.addPermission(null, CalculableType.USER, "test", Permission.loadFromString("global.positive"));
        ApiLayer.addPermission(null, CalculableType.USER, "test", Permission.loadFromString("^world.positive"));
        ApiLayer.addPermission(this.world.getName(), CalculableType.USER, "test", Permission.loadFromString("world.positive"));
        WorldManager.getInstance().update();
        Map<String, Boolean> permissions = ApiLayer.getEffectivePermissions(this.world.getName(), CalculableType.USER, "test");
        for (String key : permissions.keySet()) {
            System.out.println(String.valueOf(key) + ":" + String.valueOf(permissions.get(key)));
        }
        if (!permissions.get("global.negative").booleanValue() && permissions.get("global.positive").booleanValue() && permissions.get("world.positive").booleanValue()) {
            System.out.println("test passed!");
        } else {
            System.out.println("test failed");
        }
    }

    public void nullPassCheck() {
        this.printLine();
        WorldManager.getInstance().setDefaultWorld(this.world);
        try {
            ApiLayer.getValue(null, CalculableType.USER, "test", "test");
            System.out.println("test passed!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("test failed!");
        }
    }

    public void ApiLayerTest() {
        this.printLine();
        User user = new User("codename_B", this.world);
        user.setValue("prefix", "test");
        try {
            user.calculateEffectiveMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.world.add(user);
        System.out.println("Expected: test");
        System.out.println("Got: " + ApiLayer.getValue(this.world.getName(), CalculableType.USER, user.getName(), "prefix"));
    }

    public void gv1222PrefixTest() {
        this.printLine();
        User user = new User("gv1222", this.world);
        user.addGroup("a");
        Group a = new Group("A", this.world);
        a.setValue("priority", "100");
        a.setValue("prefix", "a");
        Group b = new Group("B", this.world);
        b.setValue("priority", "50");
        b.setValue("prefix", "b");
        this.world.add(a);
        this.world.add(b);
        this.world.add(user);
        try {
            user.calculateEffectiveMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("gv1222 has group a with prefix: " + user.getEffectiveValue("prefix"));
        user.addGroup("b");
        try {
            user.calculateEffectiveMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("gv1222 has group a and b with prefix: " + user.getEffectiveValue("prefix"));
        System.out.println("Test " + (user.getEffectiveValue("prefix").equals("a") ? "passed" : "failed"));
    }

    public void testNegativeToPositive() {
        this.printLine();
        User user = new User("user", this.world);
        user.addGroup("moderator");
        this.world.add(user);
        Group group0 = new Group("default", this.world);
        group0.addPermission("permission.*", true);
        group0.addPermission("permission.moderator", false);
        this.world.add(group0);
        Group group1 = new Group("moderator", this.world);
        group1.addGroup("default");
        group1.addPermission("permission.moderator", true);
        this.world.add(group1);
        try {
            user.calculateEffectivePermissions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("user has group moderator");
        System.out.println("moderator inherits default");
        System.out.println("default has permission.* and ^permission.moderator");
        System.out.println("moderator has permission.moderator");
        System.out.print("expected false got ");
        System.out.println(group0.hasPermission("permission.moderator"));
        System.out.print("expected true got ");
        System.out.println(group0.hasPermission("permission.default"));
        System.out.print("expected true got ");
        System.out.println(group1.hasPermission("permission.moderator"));
        System.out.print("expected true got ");
        System.out.println(group1.hasPermission("permission.default"));
        System.out.print("expected true got ");
        System.out.println(user.hasPermission("permission.moderator"));
    }

    public void test100LevelInheritance() {
        Group base = new Group("base", this.world);
        ((PermissionCarrier)base).addPermission("base.node", true);
        ((MetaData)base).setValue("priority", "0");
        ((MetaData)base).setValue("prefix", "base");
        this.world.add(base);
        Calculable last = null;
        int i = 1;
        while (i < 100) {
            Group next = new Group("next" + String.valueOf(i), this.world);
            ((MetaData)next).setValue("priority", String.valueOf(i));
            ((MetaData)next).setValue("prefix", "next" + String.valueOf(i));
            if (i == 1) {
                ((GroupCarrier)next).addGroup("base");
            } else {
                ((GroupCarrier)next).addGroup("next" + String.valueOf(i - 1));
            }
            this.world.add(next);
            last = next;
            ++i;
        }
        User user = new User("test", this.world);
        ((GroupCarrier)user).addGroup(last.getName());
        this.world.add(user);
        try {
            user.calculateEffectiveMeta();
        }
        catch (RecursiveGroupException e) {
            e.printStackTrace();
        }
        this.printLine();
        System.out.println("Expected " + last.getEffectiveValue("prefix"));
        System.out.println("Got " + user.getEffectiveValue("prefix"));
        System.out.println("base.node " + String.valueOf(((Calculable)user).hasPermission("base.node")));
    }

    public void testPriority() {
        this.printLine();
        Group group0 = new Group("default", this.world);
        Group group1 = new Group("moderator", this.world);
        Group group2 = new Group("admin", this.world);
        ((MetaData)group0).setValue("priority", "0");
        ((MetaData)group1).setValue("priority", "5");
        ((MetaData)group2).setValue("priority", "20");
        ((MetaData)group0).setValue("test0", group0.getName());
        ((MetaData)group1).setValue("test0", group1.getName());
        ((MetaData)group2).setValue("test0", group2.getName());
        ((MetaData)group0).setValue("test1", group0.getName());
        ((MetaData)group1).setValue("test1", group1.getName());
        ((MetaData)group0).setValue("test2", group0.getName());
        this.world.add(group0);
        this.world.add(group1);
        this.world.add(group2);
        User user = new User("test", this.world);
        ((GroupCarrier)user).addGroup(group0.getName());
        ((GroupCarrier)user).addGroup(group1.getName());
        ((GroupCarrier)user).addGroup(group2.getName());
        this.world.add(user);
        try {
            user.calculateEffectiveMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String test0 = user.getEffectiveValue("test0");
        String test1 = user.getEffectiveValue("test1");
        String test2 = user.getEffectiveValue("test2");
        System.out.println("default, moderator, admin assigned to User 'user'");
        System.out.println("'user' has groups:");
        System.out.println(Arrays.toString(ApiLayer.getGroups(this.world.getName(), CalculableType.USER, user.getName())));
        System.out.println("Primary group " + ApiLayer.getGroups(this.world.getName(), CalculableType.USER, user.getName())[0]);
        System.out.println("default priority: " + group0.getPriority());
        System.out.println("moderator priority: " + group1.getPriority());
        System.out.println("admin priority: " + group2.getPriority());
        System.out.println("test0 expected admin got " + test0);
        System.out.println("test1 expected moderator got " + test1);
        System.out.println("test2 expected default got " + test2);
    }

    public void testPermissions() {
        this.printLine();
        Group group0 = new Group("default", this.world);
        Group group1 = new Group("moderator", this.world);
        Group group2 = new Group("admin", this.world);
        Group group3 = new Group("non-builder", this.world);
        ((MetaData)group3).setValue("priority", "100");
        ((PermissionCarrier)group0).addPermission("permission.build", false);
        ((PermissionCarrier)group1).addPermission("permission.build", true);
        ((PermissionCarrier)group3).addPermission("permission.build", false);
        this.world.add(group0);
        this.world.add(group1);
        this.world.add(group2);
        this.world.add(group3);
        User user = new User("test", this.world);
        ((GroupCarrier)group1).addGroup(group0.getName());
        ((GroupCarrier)group2).addGroup(group1.getName());
        ((GroupCarrier)user).addGroup(group2.getName());
        this.world.add(user);
        try {
            ((Calculable)user).calculateEffectivePermissions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("default: permission.build:false");
        System.out.println("moderator: permission.build: true");
        System.out.println("admin: unset");
        System.out.println("non-builder: permission.build: false priority: 100");
        System.out.println("admin -> moderator -> default");
        System.out.println("user has group: admin");
        System.out.println("expected: true - user has permission.build:" + ((Calculable)user).hasPermission("permission.build"));
        System.out.println("addgroup: non-builder");
        ((GroupCarrier)user).addGroup(group3.getName());
        System.out.println("expected: false - user has permission.build:" + ((Calculable)user).hasPermission("permission.build"));
        System.out.println("remove permission.build from group: non-builder");
        ((PermissionCarrier)group3).removePermission("permission.build");
        System.out.println("expected: true - user has permission.build:" + ((Calculable)user).hasPermission("permission.build"));
    }
}

