/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.permissions;

import de.bananaco.bpermissions.api.CalculableWrapper;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.Permission;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ImportManager {
    private WorldManager wm = WorldManager.getInstance();
    private final JavaPlugin plugin;

    public ImportManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void importPEX() throws Exception {
        Object suffix;
        String prefix;
        CalculableWrapper u;
        List p;
        List g;
        File file = new File("plugins/PermissionsEx/permissions.yml");
        if (!file.exists()) {
            System.err.println("File not exist");
            return;
        }
        YamlConfiguration perm = new YamlConfiguration();
        perm.load(file);
        World world = (World)this.plugin.getServer().getWorlds().get(0);
        de.bananaco.bpermissions.api.World wd = this.wm.getWorld(world.getName());
        ConfigurationSection users = perm.getConfigurationSection("users");
        ConfigurationSection groups = perm.getConfigurationSection("groups");
        if (users.getKeys(false) != null && users.getKeys(false).size() > 0) {
            for (String user : users.getKeys(false)) {
                g = users.getStringList(String.valueOf(user) + ".group");
                p = users.getStringList(String.valueOf(user) + ".permissions");
                u = wd.getUser(user);
                u.getGroupsAsString().clear();
                if (g != null && g.size() > 0) {
                    for (String gr : g) {
                        u.addGroup(gr);
                    }
                }
                if (p != null && p.size() > 0) {
                    for (String pr : p) {
                        if (pr.startsWith("-")) {
                            u.addPermission(pr.replace("-", ""), false);
                            continue;
                        }
                        u.addPermission(pr, true);
                    }
                }
                if ((prefix = users.getString(String.valueOf(user) + ".prefix")) != null) {
                    u.setValue("prefix", prefix);
                }
                if ((suffix = users.getString(String.valueOf(user) + ".suffix")) == null) continue;
                u.setValue("suffix", (String)suffix);
            }
        }
        if (groups.getKeys(false) != null && groups.getKeys(false).size() > 0) {
            for (String group : groups.getKeys(false)) {
                String priority;
                if (groups.getBoolean(String.valueOf(group) + ".default")) {
                    wd.setDefaultGroup(group);
                    System.out.println("DEFAULT GROUP DETECTED: " + group);
                }
                g = groups.getStringList(String.valueOf(group) + ".inheritance");
                p = groups.getStringList(String.valueOf(group) + ".permissions");
                u = wd.getGroup(group);
                u.getGroupsAsString().clear();
                if (g != null && g.size() > 0) {
                    suffix = g.iterator();
                    while (suffix.hasNext()) {
                        String gr;
                        gr = (String)suffix.next();
                        u.addGroup(gr);
                    }
                }
                if (p != null && p.size() > 0) {
                    suffix = p.iterator();
                    while (suffix.hasNext()) {
                        String pr;
                        pr = (String)suffix.next();
                        if (pr.startsWith("-")) {
                            u.addPermission(pr.replace("-", ""), false);
                            continue;
                        }
                        u.addPermission(pr, true);
                    }
                }
                if ((prefix = groups.getString(String.valueOf(group) + ".prefix")) != null) {
                    u.setValue("prefix", prefix);
                }
                if ((suffix = groups.getString(String.valueOf(group) + ".suffix")) != null) {
                    u.setValue("suffix", (String)suffix);
                }
                if ((priority = groups.getString(String.valueOf(group) + ".options.rank")) == null) continue;
                u.setValue("priority", priority);
            }
        }
    }

    public void importYML() throws Exception {
        for (World world : this.plugin.getServer().getWorlds()) {
            de.bananaco.bpermissions.api.World wd = this.wm.getWorld(world.getName());
            File perms = new File("plugins/bPermissions/worlds/" + world.getName() + ".yml");
            if (perms.exists()) {
                System.out.println("Importing world: " + world.getName());
                YamlConfiguration pConfig = new YamlConfiguration();
                pConfig.load(perms);
                ConfigurationSection users = pConfig.getConfigurationSection("players");
                ConfigurationSection groups = pConfig.getConfigurationSection("groups");
                if (users != null && users.getKeys(false) != null && users.getKeys(false).size() > 0) {
                    Set u = users.getKeys(false);
                    for (String usr : u) {
                        System.out.println("Importing user: " + usr);
                        List g = users.getStringList(usr);
                        wd.getUser(usr).getGroupsAsString().clear();
                        if (g == null || g.size() <= 0) continue;
                        for (String group : g) {
                            wd.getUser(usr).addGroup(group);
                        }
                    }
                }
                if (groups != null && groups.getKeys(false) != null && groups.getKeys(false).size() > 0) {
                    Set g = groups.getKeys(false);
                    for (String grp : g) {
                        System.out.println("Importing group: " + grp);
                        List p = groups.getStringList(grp);
                        if (p == null || p.size() <= 0) continue;
                        for (String perm : p) {
                            wd.getGroup(grp).getPermissions().add(Permission.loadFromString(perm));
                        }
                    }
                }
            }
            wd.save();
        }
        this.wm.cleanup();
    }

    public void importGroupManager() throws Exception {
        for (World world : this.plugin.getServer().getWorlds()) {
            String suffix;
            String prefix;
            List i;
            List p;
            de.bananaco.bpermissions.api.World wd = this.wm.getWorld(world.getName());
            File users = new File("plugins/GroupManager/worlds/" + world.getName() + "/users.yml");
            File groups = new File("plugins/GroupManager/worlds/" + world.getName() + "/groups.yml");
            if (!users.exists() || !groups.exists()) continue;
            System.out.println("Importing world: " + world.getName());
            YamlConfiguration uConfig = new YamlConfiguration();
            YamlConfiguration gConfig = new YamlConfiguration();
            try {
                uConfig.load(users);
                gConfig.load(groups);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ConfigurationSection usConfig = uConfig.getConfigurationSection("users");
            ConfigurationSection grConfig = gConfig.getConfigurationSection("groups");
            Set usersList = null;
            if (usConfig != null) {
                usersList = usConfig.getKeys(false);
            }
            Set groupsList = null;
            if (grConfig != null) {
                groupsList = grConfig.getKeys(false);
            }
            if (usersList != null) {
                for (String player : usersList) {
                    System.out.println("Importing user: " + player);
                    User user = wd.getUser(player);
                    try {
                        p = uConfig.getStringList("users." + player + ".permissions");
                        i = uConfig.getStringList("users." + player + ".subgroups");
                        i.add(uConfig.getString("users." + player + ".group"));
                        prefix = uConfig.getString("users." + player + ".info." + "prefix");
                        suffix = uConfig.getString("users." + player + ".info." + "suffix");
                        if (p != null) {
                            user.getPermissions().addAll(Permission.loadFromString(p));
                        }
                        if (i != null) {
                            user.getGroupsAsString().clear();
                            user.getGroupsAsString().addAll(i);
                        }
                        if (prefix != null) {
                            user.setValue("prefix", prefix);
                        }
                        if (suffix == null) continue;
                        user.setValue("suffix", suffix);
                    }
                    catch (Exception e) {
                        System.err.println("Error importing user: " + player);
                    }
                }
            }
            if (groupsList != null) {
                for (String group : groupsList) {
                    System.out.println("Importing group: " + group);
                    Group gr = wd.getGroup(group);
                    try {
                        p = gConfig.getStringList("groups." + group + ".permissions");
                        i = gConfig.getStringList("groups." + group + ".inheritance");
                        prefix = gConfig.getString("groups." + group + ".info." + "prefix");
                        suffix = gConfig.getString("groups." + group + ".info." + "suffix");
                        if (gConfig.getBoolean("groups." + group + ".default")) {
                            wd.setDefaultGroup(group);
                            System.out.println("DEFAULT GROUP DETECTED: " + group);
                        }
                        if (p != null) {
                            gr.getPermissions().addAll(Permission.loadFromString(p));
                        }
                        if (i != null) {
                            ArrayList<String> fp = new ArrayList<String>();
                            int j = 0;
                            while (j < i.size()) {
                                String fpp = (String)i.get(j);
                                if (!fpp.startsWith("g:")) {
                                    fp.add(fpp);
                                }
                                ++j;
                            }
                            i.clear();
                            i.addAll(fp);
                            gr.getGroupsAsString().addAll(i);
                        }
                        if (prefix != null) {
                            gr.setValue("prefix", prefix);
                        }
                        if (suffix == null) continue;
                        gr.setValue("suffix", suffix);
                    }
                    catch (Exception e) {
                        System.err.println("Error importing group: " + group);
                    }
                }
            }
            wd.save();
        }
        this.wm.cleanup();
    }

    public void importPermissions3() throws Exception {
        for (World world : this.plugin.getServer().getWorlds()) {
            String suffix;
            String prefix;
            List i;
            List p;
            de.bananaco.bpermissions.api.World wd = this.wm.getWorld(world.getName());
            File users = new File("plugins/Permissions/" + world.getName() + "/users.yml");
            File groups = new File("plugins/Permissions/" + world.getName() + "/groups.yml");
            if (!users.exists() || !groups.exists()) continue;
            System.out.println("Importing world: " + world.getName());
            YamlConfiguration uConfig = new YamlConfiguration();
            YamlConfiguration gConfig = new YamlConfiguration();
            try {
                uConfig.load(users);
                gConfig.load(groups);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ConfigurationSection usConfig = uConfig.getConfigurationSection("users");
            ConfigurationSection grConfig = gConfig.getConfigurationSection("groups");
            Set usersList = null;
            if (usConfig != null) {
                usersList = usConfig.getKeys(false);
            }
            Set groupsList = null;
            if (grConfig != null) {
                groupsList = grConfig.getKeys(false);
            }
            if (usersList != null) {
                for (String player : usersList) {
                    System.out.println("Importing user: " + player);
                    User user = wd.getUser(player);
                    try {
                        p = uConfig.getStringList("users." + player + ".permissions");
                        i = uConfig.getStringList("users." + player + ".groups");
                        prefix = uConfig.getString("users." + player + ".info." + "prefix");
                        suffix = uConfig.getString("users." + player + ".info." + "suffix");
                        if (p != null) {
                            user.getPermissions().addAll(Permission.loadFromString(p));
                        }
                        if (i != null) {
                            user.getGroupsAsString().clear();
                            user.getGroupsAsString().addAll(i);
                        }
                        if (prefix != null) {
                            user.setValue("prefix", prefix);
                        }
                        if (suffix == null) continue;
                        user.setValue("suffix", suffix);
                    }
                    catch (Exception e) {
                        System.err.println("Error importing user: " + player);
                    }
                }
            }
            if (groupsList != null) {
                for (String group : groupsList) {
                    System.out.println("Importing group: " + group);
                    Group gr = wd.getGroup(group);
                    try {
                        p = gConfig.getStringList("groups." + group + ".permissions");
                        i = gConfig.getStringList("groups." + group + ".inheritance");
                        prefix = gConfig.getString("groups." + group + ".info." + "prefix");
                        suffix = gConfig.getString("groups." + group + ".info." + "suffix");
                        if (p != null) {
                            gr.getPermissions().addAll(Permission.loadFromString(p));
                        }
                        if (i != null) {
                            gr.getGroupsAsString().addAll(i);
                        }
                        if (prefix != null) {
                            gr.setValue("prefix", prefix);
                        }
                        if (suffix == null) continue;
                        gr.setValue("suffix", suffix);
                    }
                    catch (Exception e) {
                        System.err.println("Error importing group: " + group);
                    }
                }
            }
            wd.save();
        }
        this.wm.cleanup();
    }
}

