/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlockQuestioner;

import java.util.HashMap;
import org.bukkit.entity.Player;

class Question {
    private String answer = null;
    private final HashMap<Integer, String> answers;
    private final String questionMessage;
    private final Player respondent;
    private final int respondentHash;
    private final long start = System.currentTimeMillis();

    Question(Player respondent, String questionMessage, String[] answers) {
        this.respondent = respondent;
        this.respondentHash = respondent.getName().hashCode();
        this.questionMessage = questionMessage;
        this.answers = new HashMap(answers.length);
        String[] stringArray = answers;
        int n = answers.length;
        int n2 = 0;
        while (n2 < n) {
            String ans = stringArray[n2];
            this.answers.put(ans.toLowerCase().hashCode(), ans);
            ++n2;
        }
    }

    synchronized String ask() {
        StringBuilder options = new StringBuilder();
        for (String ans : this.answers.values()) {
            options.append("/" + ans + ", ");
        }
        options.delete(options.length() - 2, options.length());
        this.respondent.sendMessage(this.questionMessage);
        this.respondent.sendMessage("- " + options + "?");
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            this.answer = "interrupted";
        }
        return this.answer;
    }

    synchronized boolean isExpired() {
        if (System.currentTimeMillis() - this.start > 300000L) {
            this.answer = "timed out";
            this.notify();
            return true;
        }
        return false;
    }

    boolean isPlayerQuestioned(int playerNameHash) {
        return playerNameHash == this.respondentHash;
    }

    boolean isRightAnswer(int answerHash) {
        return this.answers.containsKey(answerHash);
    }

    synchronized void returnAnswer(int answerHash) {
        this.answer = this.answers.get(answerHash);
        this.notify();
    }
}

