/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.staticaccess.VanishNoPacket;

public class Settings {
    private static boolean enablePermTest;
    private static String fakeQuit;
    private static String fakeJoin;
    private static boolean autoFakeJoinSilent;
    private static boolean worldChangeCheck;
    private static int lightningEffectCount;
    private static final int confVersion = 5;

    public static void deployDefaultConfig(String name) {
        try {
            File target = new File(VanishNoPacket.getPlugin().getDataFolder(), name);
            InputStream source = VanishNoPacket.getPlugin().getResource(name);
            if (source == null) {
                Bukkit.getServer().getLogger().log(Level.SEVERE, "Could not find default config " + name);
                return;
            }
            if (!VanishNoPacket.getPlugin().getDataFolder().exists()) {
                VanishNoPacket.getPlugin().getDataFolder().mkdir();
            }
            if (!target.exists()) {
                int len;
                FileOutputStream output = new FileOutputStream(target);
                byte[] buffer = new byte[1024];
                while ((len = source.read(buffer)) > 0) {
                    ((OutputStream)output).write(buffer, 0, len);
                }
                ((OutputStream)output).close();
            }
            source.close();
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.SEVERE, "Could not save default config to " + name, ex);
        }
    }

    public static void freshStart(VanishPlugin plugin) {
        FileConfiguration config = plugin.getConfig();
        config.options().copyDefaults(true);
        int ver = config.getInt("configVersionDoNotTouch.SeriouslyThisWillEraseYourConfig", 0);
        if (ver != 5) {
            plugin.log("Attempting to update your configuration. Check to make sure it's ok");
            if (ver < 1) {
                config.set("hooks.spoutcraft", (Object)config.getBoolean("spoutcraft.enable", true));
                config.set("spoutcraft.enable", null);
                config.set("spoutcraft", null);
            }
            if (ver <= 1 || config.contains("permtest.enable")) {
                boolean permtest = config.getBoolean("permtest.enable", false);
                config.set("permtest.enable", null);
                config.set("permtest", (Object)permtest);
                config.set("enableColoration", null);
                config.set("enableTabControl", null);
                boolean updates = config.getBoolean("updates.check", true);
                config.set("updates.check", null);
                config.set("checkupdates", (Object)updates);
            }
            if (ver <= 3) {
                config.set("effects.lightning.count", (Object)30);
            }
            if (ver <= 4) {
                config.set("colornametags", (Object)true);
            }
            config.set("configVersionDoNotTouch.SeriouslyThisWillEraseYourConfig", (Object)5);
            plugin.saveConfig();
        }
        enablePermTest = config.getBoolean("permtest", false);
        fakeJoin = config.getString("fakeannounce.join", "%p joined the game.").replace("&&", String.valueOf('\u00a7'));
        fakeQuit = config.getString("fakeannounce.quit", "%p left the game.").replace("&&", String.valueOf('\u00a7'));
        autoFakeJoinSilent = config.getBoolean("fakeannounce.automaticforsilentjoin", false);
        worldChangeCheck = config.getBoolean("permissionsupdates.checkonworldchange", false);
        lightningEffectCount = config.getInt("effects.lightning.count", 30);
        if (lightningEffectCount < 1) {
            lightningEffectCount = 1;
        }
        if (config.getBoolean("debug", false)) {
            Debuggle.itsGoTime();
        } else {
            Debuggle.nah();
        }
    }

    public static boolean getAutoFakeJoinSilent() {
        return autoFakeJoinSilent;
    }

    public static boolean getEnablePermTest() {
        return enablePermTest;
    }

    public static String getFakeJoin() {
        return fakeJoin;
    }

    public static String getFakeQuit() {
        return fakeQuit;
    }

    public static int getLightningCount() {
        return lightningEffectCount;
    }

    public static boolean getWorldChangeCheck() {
        return worldChangeCheck;
    }
}

