/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.BPermissionsHook;
import org.kitteh.vanish.hooks.GeoIPToolsHook;
import org.kitteh.vanish.hooks.HookManager;
import org.kitteh.vanish.metrics.MetricsOverlord;

public class VanishAnnounceManipulator {
    private final ArrayList<String> delayedAnnouncePlayerList;
    private final VanishPlugin plugin;
    private final HashMap<String, Boolean> playerOnlineStatus;

    public VanishAnnounceManipulator(VanishPlugin plugin) {
        this.plugin = plugin;
        this.playerOnlineStatus = new HashMap();
        this.delayedAnnouncePlayerList = new ArrayList();
    }

    public void addToDelayedAnnounce(String player) {
        this.playerOnlineStatus.put(player, false);
        if (!Settings.getAutoFakeJoinSilent()) {
            return;
        }
        this.delayedAnnouncePlayerList.add(player);
    }

    public void dropDelayedAnnounce(String player) {
        this.delayedAnnouncePlayerList.remove(player);
    }

    public void fakeJoin(Player player, boolean force) {
        if (force || !this.playerOnlineStatus.containsKey(player.getName()) || !this.playerOnlineStatus.get(player.getName()).booleanValue()) {
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + this.injectPlayerInformation(Settings.getFakeJoin(), player));
            this.plugin.log(player.getName() + " faked joining");
            MetricsOverlord.fakejoin.increment();
            this.playerOnlineStatus.put(player.getName(), true);
        }
    }

    public void fakeQuit(Player player, boolean force) {
        if (force || !this.playerOnlineStatus.containsKey(player.getName()) || this.playerOnlineStatus.get(player.getName()).booleanValue()) {
            this.plugin.getServer().broadcastMessage(ChatColor.YELLOW + this.injectPlayerInformation(Settings.getFakeQuit(), player));
            this.plugin.log(player.getName() + " faked quitting");
            MetricsOverlord.fakequit.increment();
            this.playerOnlineStatus.put(player.getName(), false);
        }
    }

    public boolean getFakeOnlineStatus(String playerName) {
        Player player = this.plugin.getServer().getPlayerExact(playerName);
        if (player == null) {
            return false;
        }
        playerName = player.getName();
        if (this.playerOnlineStatus.containsKey(playerName)) {
            return this.playerOnlineStatus.get(playerName);
        }
        return true;
    }

    public void vanishToggled(Player player) {
        if (!Settings.getAutoFakeJoinSilent() || !this.delayedAnnouncePlayerList.contains(player.getName())) {
            return;
        }
        this.fakeJoin(player, false);
        this.dropDelayedAnnounce(player.getName());
    }

    public boolean wasPlayerMarkedOnline(String player) {
        if (this.playerOnlineStatus.containsKey(player)) {
            return this.playerOnlineStatus.remove(player);
        }
        return true;
    }

    private String injectPlayerInformation(String message, Player player) {
        GeoIPToolsHook geoip = (GeoIPToolsHook)this.plugin.getHookManager().getHook(HookManager.HookType.GeoIPTools);
        BPermissionsHook bperms = (BPermissionsHook)this.plugin.getHookManager().getHook(HookManager.HookType.BPermissions);
        return message.replace("%p", player.getName()).replace("%d", player.getDisplayName()).replace("%up", bperms.getPrefix(player)).replace("%us", bperms.getSuffix(player)).replace("%city", geoip.getCity(player)).replace("%country", geoip.getCountry(player));
    }
}

